/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveQualifierFix
implements IntentionAction {
    private final PsiExpression myQualifier;
    private final PsiReferenceExpression myExpression;
    private final PsiClass myResolved;

    public RemoveQualifierFix(@NotNull PsiExpression qualifier, @NotNull PsiReferenceExpression expression, @NotNull PsiClass resolved) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "<init>"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "<init>"));
        }
        this.myQualifier = qualifier;
        this.myExpression = expression;
        this.myResolved = resolved;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.qualifier.action.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "isAvailable"));
        }
        return this.myQualifier.isValid() && this.myQualifier.getManager().isInProject((PsiElement)this.myQualifier) && this.myExpression.isValid() && this.myResolved.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix", "invoke"));
        }
        this.myQualifier.delete();
        this.myExpression.bindToElement((PsiElement)this.myResolved);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

