/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithTryCatchFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix");
    private PsiElement myStatement;

    public SurroundWithTryCatchFix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "<init>"));
        }
        PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFunctionalExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class});
        if (functionalExpression == null) {
            this.myStatement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class});
        } else if (functionalExpression instanceof PsiLambdaExpression) {
            this.myStatement = functionalExpression;
        }
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "isAvailable"));
        }
        return this.myStatement != null && this.myStatement.isValid() && (!(this.myStatement instanceof PsiExpressionStatement) || !RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)((PsiExpressionStatement)this.myStatement).getExpression()));
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiForStatement forStatement;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix", "invoke"));
        }
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        if (this.myStatement.getParent() instanceof PsiForStatement && (this.myStatement.equals((forStatement = (PsiForStatement)this.myStatement.getParent()).getInitialization()) || this.myStatement.equals(forStatement.getUpdate()))) {
            this.myStatement = forStatement;
        }
        if (this.myStatement instanceof PsiLambdaExpression) {
            PsiElement body = ((PsiLambdaExpression)this.myStatement).getBody();
            if (body instanceof PsiExpression) {
                this.myStatement = RefactoringUtil.expandExpressionLambdaToCodeBlock(body);
            }
            body = ((PsiLambdaExpression)this.myStatement).getBody();
            LOG.assertTrue(body instanceof PsiCodeBlock);
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            LOG.assertTrue(statements.length == 1);
            this.myStatement = statements[0];
        }
        TextRange range = null;
        try {
            JavaWithTryCatchSurrounder handler2 = new JavaWithTryCatchSurrounder();
            range = handler2.surroundElements(project2, editor, new PsiElement[]{this.myStatement});
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        LogicalPosition pos = new LogicalPosition(line, col);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (range != null) {
            int offset = range.getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

