/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.PasteHandler");
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customPasteProvider");
    private static final int LINE_LIMIT_FOR_BULK_CHANGE = 5000;
    private final EditorActionHandler myOriginalHandler;

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
        assert (caret == null) : "Invocation of 'paste' operation for specific caret is not supported";
        this.execute(editor, dataContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Editor editor, final DataContext dataContext, @Nullable Producer<Transferable> producer) {
        final Transferable transferable = EditorModificationUtil.getContentsToPasteToEditor(producer);
        if (transferable == null) {
            return;
        }
        if (!EditorModificationUtil.showReadOnlyViewWarning((Editor)editor)) {
            return;
        }
        Document document = editor.getDocument();
        if (!EditorModificationUtil.requestWriting((Editor)editor)) {
            return;
        }
        DataContext context = new DataContext(){

            public Object getData(@NonNls String dataId) {
                return PasteAction.TRANSFERABLE_PROVIDER.is(dataId) ? () -> transferable : dataContext.getData(dataId);
            }
        };
        Project project2 = editor.getProject();
        if (project2 == null || editor.isColumnMode() || editor.getCaretModel().getCaretCount() > 1) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context);
            }
            return;
        }
        DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(true);
        document.startGuardedBlockChecking();
        try {
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions(EP_NAME)) {
                if (!provider.isPasteEnabled(context)) continue;
                provider.performPaste(context);
                return;
            }
            PasteHandler.doPaste(editor, project2, file2, document, transferable);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
            DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(false);
        }
    }

    private static void doPaste(Editor editor, Project project2, PsiFile file2, Document document, @NotNull Transferable content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/editorActions/PasteHandler", "doPaste"));
        }
        CopyPasteManager.getInstance().stopKillRings();
        String text = null;
        try {
            text = (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            editor.getComponent().getToolkit().beep();
        }
        if (text == null) {
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        HashMap extraData = new HashMap();
        ArrayList<TextBlockTransferableData> allValues = new ArrayList<TextBlockTransferableData>();
        for (CopyPastePostProcessor processor2 : (CopyPastePostProcessor[])Extensions.getExtensions(CopyPastePostProcessor.EP_NAME)) {
            List data = processor2.extractTransferableData(content);
            if (data.isEmpty()) continue;
            extraData.put(processor2, data);
            allValues.addAll(data);
        }
        text = TextBlockTransferable.convertLineSeparators(editor, text, allValues);
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        int col = caretModel.getLogicalPosition().column;
        int caretOffset = caretModel.getOffset();
        int blockIndentAnchorColumn = selectionModel.hasSelection() && caretOffset >= selectionModel.getSelectionStart() ? editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).column : col;
        RawText rawText = RawText.fromTransferable((Transferable)content);
        String newText = text;
        for (CopyPastePreProcessor preProcessor : (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME)) {
            newText = preProcessor.preprocessOnPaste(project2, file2, editor, newText, rawText);
        }
        int indentOptions = text.equals(newText) ? settings.REFORMAT_ON_PASTE : 4;
        text = newText;
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null && indentOptions != 1) {
            indentOptions = 2;
        }
        String _text = text;
        ApplicationManager.getApplication().runWriteAction(() -> EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)_text, (boolean)false, (boolean)true));
        int length = text.length();
        int offset = caretModel.getOffset() - length;
        if (offset < 0) {
            length += offset;
            offset = 0;
        }
        RangeMarker bounds = document.createRangeMarker(offset, offset + length);
        caretModel.moveToOffset(bounds.getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        selectionModel.removeSelection();
        Ref indented = new Ref((Object)Boolean.FALSE);
        for (Map.Entry e : extraData.entrySet()) {
            ((CopyPastePostProcessor)e.getKey()).processTransferableData(project2, editor, bounds, caretOffset, (Ref<Boolean>)indented, (List)e.getValue());
        }
        boolean pastedTextContainsWhiteSpacesOnly = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)bounds.getStartOffset(), (String)" \n\t") >= bounds.getEndOffset();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!(pastedTextContainsWhiteSpacesOnly || virtualFile != null && SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile))) {
            int indentOptions1 = indentOptions;
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                switch (indentOptions1) {
                    case 2: {
                        if (((Boolean)indented.get()).booleanValue()) break;
                        PasteHandler.indentBlock(project2, editor, bounds.getStartOffset(), bounds.getEndOffset(), blockIndentAnchorColumn);
                        break;
                    }
                    case 3: {
                        if (((Boolean)indented.get()).booleanValue()) break;
                        PasteHandler.indentEachLine(project2, editor, bounds.getStartOffset(), bounds.getEndOffset());
                        break;
                    }
                    case 4: {
                        PasteHandler.indentEachLine(project2, editor, bounds.getStartOffset(), bounds.getEndOffset());
                        PasteHandler.reformatBlock(project2, editor, bounds.getStartOffset(), bounds.getEndOffset());
                    }
                }
            });
        }
        if (bounds.isValid()) {
            caretModel.moveToOffset(bounds.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
            editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)TextRange.create((Segment)bounds));
        }
    }

    static void indentBlock(Project project2, Editor editor, int startOffset, int endOffset, int originalCaretCol) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitAllDocuments();
        Document document = editor.getDocument();
        PsiFile file2 = documentManager.getPsiFile(document);
        if (file2 == null) {
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            PasteHandler.indentBlockWithFormatter(project2, document, startOffset, endOffset, file2);
        } else {
            PasteHandler.indentPlainTextBlock(document, startOffset, endOffset, originalCaretCol);
        }
    }

    private static void indentEachLine(Project project2, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        CharSequence text = editor.getDocument().getCharsSequence();
        if (startOffset > 0 && endOffset > startOffset + 1 && text.charAt(endOffset - 1) == '\n' && text.charAt(startOffset - 1) == '\n') {
            --endOffset;
        }
        try {
            codeStyleManager.adjustLineIndent(file2, new TextRange(startOffset, endOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void reformatBlock(Project project2, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        try {
            CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)file2, startOffset, endOffset, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void indentPlainTextBlock(Document document, int startOffset, int endOffset, int indentLevel) {
        int endLine;
        CharSequence chars = document.getCharsSequence();
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        int startLine = document.getLineNumber(startOffset);
        if (spaceEnd > endOffset || indentLevel <= 0 || startLine >= document.getLineCount() - 1 || chars.charAt(spaceEnd) == '\n') {
            return;
        }
        for (endLine = startLine + 1; endLine < document.getLineCount() && document.getLineStartOffset(endLine) < endOffset; ++endLine) {
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indentLevel);
        PasteHandler.indentLines(document, startLine + 1, endLine - 1, indentString);
    }

    private static void indentBlockWithFormatter(Project project2, Document document, int startOffset, int endOffset, PsiFile file2) {
        int lastLine;
        CharSequence chars = document.getCharsSequence();
        int firstLine = document.getLineNumber(startOffset);
        int firstLineStart = document.getLineStartOffset(firstLine);
        boolean saveLastLineIndent = false;
        for (int i2 = endOffset - 1; i2 >= startOffset; --i2) {
            char c = chars.charAt(i2);
            if (c == '\n') {
                saveLastLineIndent = true;
                break;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (saveLastLineIndent) {
            int indentToKeepEndOffset;
            int i3;
            lastLine = document.getLineNumber(endOffset) - 1;
            int start = document.getLineStartOffset(lastLine + 1);
            if (start < endOffset && (i3 = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (String)" \t")) > start) {
                i3 = Math.min(i3, endOffset);
                document.deleteString(start, i3);
            }
            if ((indentToKeepEndOffset = Math.min(startOffset, CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t"))) > firstLineStart) {
                document.insertString(start, chars.subSequence(firstLineStart, indentToKeepEndOffset));
            }
        } else {
            lastLine = document.getLineNumber(endOffset);
        }
        int i4 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t");
        if (chars.charAt(startOffset) != '\n' && i4 > 0 && chars.charAt(i4) != '\n') {
            int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (firstNonWsOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, firstNonWsOffset);
                PasteHandler.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (file2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        int j = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t\n");
        if (j >= endOffset) {
            return;
        }
        int anchorLine = document.getLineNumber(j);
        int anchorLineStart = document.getLineStartOffset(anchorLine);
        codeStyleManager.adjustLineIndent(file2, j);
        if (anchorLine == firstLine && j == startOffset) {
            int indentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (indentOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, indentOffset);
                PasteHandler.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)anchorLineStart, (String)" \t");
        int diff = firstNonWsOffset - j;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            CharSequence toInsert = chars.subSequence(anchorLineStart, anchorLineStart + diff);
            PasteHandler.indentLines(document, anchorLine + 1, lastLine, toInsert);
            return;
        }
        if (anchorLine == firstLine && -diff == startOffset - firstLineStart) {
            return;
        }
        if (anchorLine != firstLine || -diff > startOffset - firstLineStart) {
            int desiredSymbolsToRemove = anchorLine == firstLine ? -diff - (startOffset - firstLineStart) : -diff;
            Runnable deindentTask = () -> {
                for (int line = anchorLine + 1; line <= lastLine; ++line) {
                    int currentLineStart = document.getLineStartOffset(line);
                    int currentLineIndentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)currentLineStart, (String)" \t");
                    int symbolsToRemove = Math.min(currentLineIndentOffset - currentLineStart, desiredSymbolsToRemove);
                    if (symbolsToRemove <= 0) continue;
                    document.deleteString(currentLineStart, currentLineStart + symbolsToRemove);
                }
            };
            DocumentUtil.executeInBulk(document, lastLine - anchorLine > 5000, deindentTask);
        } else {
            CharSequence toInsert = chars.subSequence(anchorLineStart, diff + startOffset);
            PasteHandler.indentLines(document, anchorLine + 1, lastLine, toInsert);
        }
    }

    private static void indentLines(@NotNull Document document, int startLine, int endLine, @NotNull CharSequence indentString) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/PasteHandler", "indentLines"));
        }
        if (indentString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentString", "com/intellij/codeInsight/editorActions/PasteHandler", "indentLines"));
        }
        Runnable indentTask = () -> {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/PasteHandler", "lambda$indentLines$3"));
            }
            if (indentString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentString", "com/intellij/codeInsight/editorActions/PasteHandler", "lambda$indentLines$3"));
            }
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset = document.getLineStartOffset(line);
                document.insertString(lineStartOffset, indentString);
            }
        };
        DocumentUtil.executeInBulk(document, endLine - startLine > 5000, indentTask);
    }
}

