/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodOrClassSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return (e instanceof PsiClass && !(e instanceof PsiTypeParameter) || e instanceof PsiMethod) && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList result2 = ContainerUtil.newArrayList();
        PsiElement firstChild = e.getFirstChild();
        PsiElement[] children2 = e.getChildren();
        int i2 = 1;
        if (firstChild instanceof PsiDocComment) {
            while (children2[i2] instanceof PsiWhiteSpace) {
                ++i2;
            }
            TextRange range = new TextRange(children2[i2].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result2.add(range);
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            range = TextRange.create((Segment)firstChild.getTextRange());
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            firstChild = children2[i2++];
        }
        if (firstChild instanceof PsiComment) {
            while (children2[i2] instanceof PsiComment || children2[i2] instanceof PsiWhiteSpace) {
                ++i2;
            }
            PsiElement last = children2[i2 - 1] instanceof PsiWhiteSpace ? children2[i2 - 2] : children2[i2 - 1];
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
            }
            range = new TextRange(children2[i2].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result2.add(range);
            result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, range));
        }
        result2.add(e.getTextRange());
        result2.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, e.getTextRange()));
        if (e instanceof PsiClass) {
            result2.addAll(MethodOrClassSelectioner.selectWithTypeParameters((PsiClass)e));
            result2.addAll(MethodOrClassSelectioner.selectBetweenBracesLines(children2, editorText));
        }
        if (e instanceof PsiAnonymousClass) {
            result2.addAll(MethodOrClassSelectioner.selectWholeBlock((PsiClass)((PsiAnonymousClass)e)));
        }
        return result2;
    }

    private static Collection<TextRange> selectWithTypeParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectWithTypeParameters"));
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiTypeParameterList list = psiClass.getTypeParameterList();
        if (identifier != null && list != null) {
            return Collections.singletonList(new TextRange(identifier.getTextRange().getStartOffset(), list.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectBetweenBracesLines(@NotNull PsiElement[] children2, @NotNull CharSequence editorText) {
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectBetweenBracesLines"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner", "selectBetweenBracesLines"));
        }
        int start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children2);
        if (start != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children2, start);
            return MethodOrClassSelectioner.expandToWholeLinesWithBlanks(editorText, new TextRange(start, end));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectWholeBlock(PsiClass c) {
        PsiJavaToken[] tokens = (PsiJavaToken[])PsiTreeUtil.getChildrenOfType((PsiElement)c, PsiJavaToken.class);
        if (tokens != null && tokens.length == 2 && tokens[0].getTokenType() == JavaTokenType.LBRACE && tokens[1].getTokenType() == JavaTokenType.RBRACE) {
            return Collections.singleton(new TextRange(tokens[0].getTextRange().getStartOffset(), tokens[1].getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }
}

