/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDelegateHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateDelegateHandler");
    private boolean myToCopyJavaDoc;

    public boolean isValidFor(Editor editor, PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        return OverrideImplementUtil.getContextClass(editor.getProject(), editor, file2, false) != null && GenerateDelegateHandler.isApplicable(file2, editor);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (!EditorModificationUtil.showReadOnlyViewWarning((Editor)editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project2)) {
            return;
        }
        PsiElementClassMember target = GenerateDelegateHandler.chooseTarget(file2, editor, project2);
        if (target == null) {
            return;
        }
        PsiMethodMember[] candidates = this.chooseMethods(target, file2, editor, project2);
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "lambda$invoke$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "lambda$invoke$0"));
            }
            try {
                int offset = editor.getCaretModel().getOffset();
                ArrayList<PsiGenerationInfo<PsiMethod>> prototypes = new ArrayList<PsiGenerationInfo<PsiMethod>>(candidates.length);
                for (PsiMethodMember candidate : candidates) {
                    prototypes.add(this.generateDelegatePrototype(candidate, (PsiElement)target.getElement()));
                }
                List results = GenerateMembersUtil.insertMembersAtOffset(file2, offset, prototypes);
                if (!results.isEmpty()) {
                    PsiMethod firstMethod = (PsiMethod)((PsiGenerationInfo)results.get(0)).getPsiMember();
                    PsiCodeBlock block = firstMethod.getBody();
                    assert (block != null);
                    PsiElement first = block.getFirstBodyElement();
                    assert (first != null);
                    editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor.getSelectionModel().removeSelection();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private PsiGenerationInfo<PsiMethod> generateDelegatePrototype(PsiMethodMember methodCandidate, PsiElement target) throws IncorrectOperationException {
        PsiMethod method2 = GenerateMembersUtil.substituteGenericMethod((PsiMethod)methodCandidate.getElement(), methodCandidate.getSubstitutor(), target);
        this.clearMethod(method2);
        GenerateDelegateHandler.clearModifiers(method2);
        StringBuffer call = new StringBuffer();
        PsiModifierList modifierList = null;
        if (!PsiType.VOID.equals((Object)method2.getReturnType())) {
            call.append("return ");
        }
        boolean isMethodStatic = ((PsiMethod)methodCandidate.getElement()).hasModifierProperty("static");
        if (target instanceof PsiField) {
            PsiField field = (PsiField)target;
            modifierList = field.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName());
            } else {
                PsiParameter[] parameters;
                String name = field.getName();
                for (PsiParameter psiParameter : parameters = method2.getParameterList().getParameters()) {
                    if (!name.equals(psiParameter.getName())) continue;
                    call.append("this.");
                    break;
                }
                call.append(name);
            }
            call.append(".");
        } else if (target instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)target;
            modifierList = m.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName()).append(".");
            } else {
                call.append(m.getName());
                call.append("().");
            }
        }
        call.append(method2.getName());
        call.append("(");
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            if (j > 0) {
                call.append(",");
            }
            call.append(parameter.getName());
        }
        call.append(");");
        PsiManager psiManager = method2.getManager();
        PsiStatement stmt = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText(call.toString(), (PsiElement)method2);
        stmt = (PsiStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)stmt);
        method2.getBody().add((PsiElement)stmt);
        for (PsiParameter psiParameter : ((PsiMethod)methodCandidate.getElement()).getModifierList().getAnnotations()) {
            if (SuppressWarnings.class.getName().equals(psiParameter.getQualifiedName())) continue;
            method2.getModifierList().add(psiParameter.copy());
        }
        if (isMethodStatic || modifierList != null && modifierList.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method2, (String)"static", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method2, (String)"public", (boolean)true);
        PsiClass targetClass = ((PsiMember)target).getContainingClass();
        LOG.assertTrue(targetClass != null);
        PsiMethod overridden = targetClass.findMethodBySignature(method2, true);
        if (overridden != null && overridden.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(method2, targetClass, overridden);
        }
        return new PsiGenerationInfo<PsiMethod>(method2);
    }

    private void clearMethod(PsiMethod method2) throws IncorrectOperationException {
        PsiDocComment docComment;
        LOG.assertTrue(!method2.isPhysical());
        PsiCodeBlock codeBlock = JavaPsiFacade.getInstance((Project)method2.getProject()).getElementFactory().createCodeBlock();
        if (method2.getBody() != null) {
            method2.getBody().replace((PsiElement)codeBlock);
        } else {
            method2.add((PsiElement)codeBlock);
        }
        if (!this.myToCopyJavaDoc && (docComment = method2.getDocComment()) != null) {
            docComment.delete();
        }
    }

    private static void clearModifiers(PsiMethod method2) throws IncorrectOperationException {
        PsiElement[] children2;
        for (PsiElement child : children2 = method2.getModifierList().getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            child.delete();
        }
    }

    @Nullable
    private PsiMethodMember[] chooseMethods(PsiElementClassMember targetMember, PsiFile file2, Editor editor, Project project2) {
        PsiMethodMember[] result2;
        PsiMethod[] allMethods;
        PsiClassType.ClassResolveResult resolveResult = null;
        Object target = targetMember.getElement();
        if (target instanceof PsiField) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiField)target).getType()));
        } else if (target instanceof PsiMethod) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiMethod)target).getReturnType()));
        }
        if (resolveResult == null || resolveResult.getElement() == null) {
            return null;
        }
        PsiClass targetClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiMethodMember> methodInstances = new ArrayList<PsiMethodMember>();
        if (targetClass instanceof PsiTypeParameter) {
            LinkedHashSet<PsiMethod> meths = new LinkedHashSet<PsiMethod>();
            for (PsiClass superClass : targetClass.getSupers()) {
                meths.addAll(Arrays.asList(superClass.getAllMethods()));
            }
            allMethods = meths.toArray(new PsiMethod[meths.size()]);
        } else {
            allMethods = targetClass.getAllMethods();
        }
        HashSet signatures = new HashSet();
        HashSet existingSignatures = new HashSet(aClass.getVisibleSignatures());
        HashSet selection = new HashSet();
        HashMap superSubstitutors = new HashMap();
        PsiClass containingClass = targetMember.getContainingClass();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)target.getProject());
        for (PsiMethod method2 : allMethods) {
            PsiSubstitutor methodSubstitutor;
            MethodSignature signature;
            PsiMethod overridden;
            PsiClass superClass = method2.getContainingClass();
            if ("java.lang.Object".equals(superClass.getQualifiedName()) || method2.isConstructor() || method2.hasModifierProperty("final") && (overridden = containingClass.findMethodBySignature(method2, true)) != null && overridden.getContainingClass() != containingClass) continue;
            PsiSubstitutor superSubstitutor = (PsiSubstitutor)superSubstitutors.get(superClass);
            if (superSubstitutor == null) {
                superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)targetClass, (PsiSubstitutor)substitutor);
                superSubstitutors.put(superClass, superSubstitutor);
            }
            if (signatures.contains(signature = method2.getSignature(methodSubstitutor = OverrideImplementExploreUtil.correctSubstitutor(method2, superSubstitutor)))) continue;
            signatures.add(signature);
            if (!facade.getResolveHelper().isAccessible((PsiMember)method2, target, aClass)) continue;
            PsiMethodMember methodMember = new PsiMethodMember(method2, methodSubstitutor);
            methodInstances.add(methodMember);
            if (existingSignatures.contains(signature)) continue;
            selection.add(methodMember);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])methodInstances.toArray(new PsiMethodMember[methodInstances.size()]), false, true, project2);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(true);
            if (!selection.isEmpty()) {
                chooser.selectElements(selection.toArray(new ClassMember[selection.size()]));
            }
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            this.myToCopyJavaDoc = chooser.isCopyJavadoc();
            List<PsiMethodMember> list = chooser.getSelectedElements();
            result2 = list.toArray(new PsiMethodMember[list.size()]);
        } else {
            PsiMethodMember[] psiMethodMemberArray;
            if (methodInstances.isEmpty()) {
                psiMethodMemberArray = new PsiMethodMember[]{};
            } else {
                PsiMethodMember[] psiMethodMemberArray2 = new PsiMethodMember[1];
                psiMethodMemberArray = psiMethodMemberArray2;
                psiMethodMemberArray2[0] = (PsiMethodMember)methodInstances.get(0);
            }
            result2 = psiMethodMemberArray;
        }
        return result2;
    }

    public void setToCopyJavaDoc(boolean toCopyJavaDoc) {
        this.myToCopyJavaDoc = toCopyJavaDoc;
    }

    public static boolean isApplicable(PsiFile file2, Editor editor) {
        PsiElementClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file2, editor);
        return targetElements != null && targetElements.length > 0;
    }

    @Nullable
    private static PsiElementClassMember chooseTarget(PsiFile file2, Editor editor, Project project2) {
        ClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file2, editor);
        if (targetElements == null || targetElements.length == 0) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser(targetElements, false, false, project2);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.target.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            List selectedElements = chooser.getSelectedElements();
            if (selectedElements != null && selectedElements.size() > 0) {
                return (PsiElementClassMember)selectedElements.get(0);
            }
        } else {
            return targetElements[0];
        }
        return null;
    }

    @Nullable
    private static PsiElementClassMember[] getTargetElements(PsiFile file2, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        PsiClass aClass = targetClass;
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiElementClassMember> result2 = new ArrayList<PsiElementClassMember>();
        while (aClass != null) {
            GenerateDelegateHandler.collectTargetsInClass(element, targetClass, aClass, result2);
            if (aClass.hasModifierProperty("static")) break;
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }
        return result2.toArray(new PsiElementClassMember[result2.size()]);
    }

    private static void collectTargetsInClass(PsiElement element, PsiClass targetClass, final PsiClass aClass, List<PsiElementClassMember> result2) {
        PsiMethod[] methods;
        PsiClass containingClass;
        PsiField[] fields = aClass.getAllFields();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (PsiField field : fields) {
            PsiType type = field.getType();
            if (!helper.isAccessible((PsiMember)field, (PsiElement)aClass, aClass) || !(type instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)field, (PsiElement)element, (boolean)false) && targetClass != aClass || (containingClass = field.getContainingClass()) == null) continue;
            result2.add(new PsiFieldMember(field, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        for (PsiMethod method2 : methods = aClass.getAllMethods()) {
            PsiType returnType;
            containingClass = method2.getContainingClass();
            if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName()) || (returnType = method2.getReturnType()) == null || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method2) || !helper.isAccessible((PsiMember)method2, (PsiElement)aClass, aClass) || !(returnType instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)method2, (PsiElement)element, (boolean)false) && targetClass != aClass) continue;
            result2.add(new PsiMethodMember(method2, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClass scope;
            VariablesProcessor proc = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return var.hasModifierProperty("final") && var instanceof PsiLocalVariable || var instanceof PsiParameter;
                }
            };
            for (scope = aClass; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
            }
            if (scope != null) {
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)aClass, (PsiElement)scope);
                for (int i2 = 0; i2 < proc.size(); ++i2) {
                    PsiVariable psiVariable = proc.getResult(i2);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    PsiType type = psiVariable.getType();
                    if (LambdaUtil.notInferredType((PsiType)type)) continue;
                    result2.add(new PsiFieldMember(elementFactory.createField(psiVariable.getName(), type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type)){

                        @Override
                        protected PsiClass getContainingClass() {
                            return aClass;
                        }
                    });
                }
            }
        }
    }
}

