/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterTemplatesManager;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.SetterTemplatesManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersUtil");

    private GenerateMembersUtil() {
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file2, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberPrototypes", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        List<T> list = GenerateMembersUtil.insertMembersAtOffset(file2, offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> GenerateMembersUtil.findClassAtOffset(file2, leaf)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        return list;
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiClass psiClass, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberPrototypes", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        List<T> list = GenerateMembersUtil.insertMembersAtOffset(psiClass.getContainingFile(), offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/generation/GenerateMembersUtil", "lambda$insertMembersAtOffset$1"));
            }
            return psiClass;
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        return list;
    }

    @NotNull
    private static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file2, int offset, @NotNull List<T> memberPrototypes, Function<PsiElement, PsiClass> aClassFunction) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberPrototypes", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        if (memberPrototypes.isEmpty()) {
            List<T> list = memberPrototypes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiElement leaf = file2.findElementAt(offset);
        if (leaf == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiClass aClass = (PsiClass)aClassFunction.fun((Object)leaf);
        if (aClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                PsiParserFacade parserFacade;
                ASTNode singleNewLineWhitespace;
                String whiteSpace = spaceNode.getText().substring(0, offset - spaceNode.getStartOffset());
                if (!StringUtil.containsLineBreak((CharSequence)whiteSpace)) {
                    whiteSpace = whiteSpace + "\n";
                }
                if ((singleNewLineWhitespace = (parserFacade = PsiParserFacade.SERVICE.getInstance((Project)file2.getProject())).createWhiteSpaceFromText(whiteSpace).getNode()) != null) {
                    spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
                }
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        List<T> list = GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        return list;
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(PsiClass aClass, @Nullable PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberPrototypes", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersBeforeAnchor"));
        }
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        List<T> list = memberPrototypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersBeforeAnchor"));
        }
        return list;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        int offset;
        PsiMethod method2;
        PsiCodeBlock body;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "positionCaret"));
        }
        if (firstMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstMember", "com/intellij/codeInsight/generation/GenerateMembersUtil", "positionCaret"));
        }
        LOG.assertTrue(firstMember.isValid());
        Project project2 = firstMember.getProject();
        if (toEditMethodBody && (body = (method2 = (PsiMethod)firstMember).getBody()) != null) {
            CharSequence chars;
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            PsiElement l = firstBodyElement = body.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body;
            }
            PsiElement r = lastBodyElement = body.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            boolean adjustLineIndent = false;
            if (start > end && firstBodyElement == lastBodyElement && firstBodyElement instanceof PsiWhiteSpaceImpl && (chars = ((PsiWhiteSpaceImpl)firstBodyElement).getChars()).length() > 1 && chars.charAt(0) == '\n' && chars.charAt(1) == '\n') {
                start = end = firstBodyElement.getTextRange().getStartOffset() + 1;
                adjustLineIndent = true;
            }
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            } else if (adjustLineIndent) {
                Document document = editor.getDocument();
                RangeMarker marker = document.createRangeMarker(start, start);
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                if (marker.isValid()) {
                    CodeStyleManager.getInstance((Project)project2).adjustLineIndent(document, marker.getStartOffset());
                }
            }
            return;
        }
        if (firstMember instanceof PsiMethod) {
            PsiMethod method3 = (PsiMethod)firstMember;
            PsiCodeBlock body2 = method3.getBody();
            if (body2 == null) {
                offset = method3.getTextRange().getStartOffset();
            } else {
                PsiJavaToken lBrace = body2.getLBrace();
                assert (lBrace != null) : firstMember.getText();
                offset = lBrace.getTextRange().getEndOffset();
            }
        } else {
            offset = firstMember.getTextRange().getStartOffset();
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(@NotNull PsiClass aClass, @NotNull PsiMember member, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insert"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insert"));
        }
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter : parameters) {
                PsiModifierList modifierList = parameter.getModifierList();
                assert (modifierList != null);
                modifierList.setModifierProperty("final", generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(PsiFile file2, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child : psiClass.getChildren()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file2, file2.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    public static PsiMethod substituteGenericMethod(PsiMethod method2, PsiSubstitutor substitutor) {
        return GenerateMembersUtil.substituteGenericMethod(method2, substitutor, null);
    }

    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod sourceMethod, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMethod", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteGenericMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteGenericMethod"));
        }
        Project project2 = sourceMethod.getProject();
        JVMElementFactory factory = GenerateMembersUtil.getFactory(sourceMethod.getProject(), target);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        try {
            PsiMethod resultMethod = GenerateMembersUtil.createMethod(factory, sourceMethod, target);
            GenerateMembersUtil.copyModifiers(sourceMethod.getModifierList(), resultMethod.getModifierList());
            PsiSubstitutor collisionResolvedSubstitutor = GenerateMembersUtil.substituteTypeParameters(factory, target, sourceMethod.getTypeParameterList(), resultMethod.getTypeParameterList(), substitutor, sourceMethod);
            GenerateMembersUtil.substituteReturnType(PsiManager.getInstance((Project)project2), resultMethod, sourceMethod.getReturnType(), collisionResolvedSubstitutor);
            GenerateMembersUtil.substituteParameters(factory, codeStyleManager, sourceMethod.getParameterList(), resultMethod.getParameterList(), collisionResolvedSubstitutor, target);
            GenerateMembersUtil.copyDocComment(sourceMethod, resultMethod, factory);
            GlobalSearchScope scope = sourceMethod.getResolveScope();
            List<PsiClassType> thrownTypes = ExceptionUtil.collectSubstituted(collisionResolvedSubstitutor, sourceMethod.getThrowsList().getReferencedTypes(), scope);
            if (target instanceof PsiClass) {
                PsiMethod[] methods;
                for (PsiMethod psiMethod : methods = ((PsiClass)target).findMethodsBySignature(sourceMethod, true)) {
                    PsiClass aSuper;
                    if (psiMethod == null || psiMethod == sourceMethod || MethodSignatureUtil.isSuperMethod((PsiMethod)psiMethod, (PsiMethod)sourceMethod) || (aSuper = psiMethod.getContainingClass()) == null || aSuper == target) continue;
                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)target), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    ExceptionUtil.retainExceptions(thrownTypes, ExceptionUtil.collectSubstituted(superClassSubstitutor, psiMethod.getThrowsList().getReferencedTypes(), scope));
                }
            }
            GenerateMembersUtil.substituteThrows(factory, resultMethod.getThrowsList(), collisionResolvedSubstitutor, sourceMethod, thrownTypes);
            return resultMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return sourceMethod;
        }
    }

    private static void copyModifiers(@NotNull PsiModifierList sourceModifierList, @NotNull PsiModifierList targetModifierList) {
        if (sourceModifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceModifierList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyModifiers"));
        }
        if (targetModifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetModifierList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyModifiers"));
        }
        VisibilityUtil.setVisibility((PsiModifierList)targetModifierList, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)sourceModifierList));
    }

    @NotNull
    private static PsiSubstitutor substituteTypeParameters(@NotNull JVMElementFactory factory, @Nullable PsiElement target, @Nullable PsiTypeParameterList sourceTypeParameterList, @Nullable PsiTypeParameterList targetTypeParameterList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMethod", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (sourceTypeParameterList == null || targetTypeParameterList == null || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)sourceMethod, (PsiSubstitutor)substitutor)) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
            }
            return psiSubstitutor;
        }
        HashMap substitutionMap = new HashMap(substitutor.getSubstitutionMap());
        for (PsiTypeParameter typeParam : sourceTypeParameterList.getTypeParameters()) {
            PsiTypeParameter substitutedTypeParam = GenerateMembersUtil.substituteTypeParameter(factory, typeParam, substitutor, sourceMethod);
            PsiTypeParameter resolvedTypeParam = GenerateMembersUtil.resolveTypeParametersCollision(factory, sourceTypeParameterList, target, substitutedTypeParam, substitutor);
            targetTypeParameterList.add((PsiElement)resolvedTypeParam);
            if (substitutedTypeParam == resolvedTypeParam) continue;
            substitutionMap.put(typeParam, factory.createType((PsiClass)resolvedTypeParam));
        }
        PsiSubstitutor psiSubstitutor = substitutionMap.isEmpty() ? substitutor : factory.createSubstitutor((Map)substitutionMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiTypeParameter resolveTypeParametersCollision(@NotNull JVMElementFactory factory, @NotNull PsiTypeParameterList sourceTypeParameterList, @Nullable PsiElement target, @NotNull PsiTypeParameter typeParam, @NotNull PsiSubstitutor substitutor) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (sourceTypeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTypeParameterList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (typeParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParam", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        for (PsiType type : substitutor.getSubstitutionMap().values()) {
            if (type == null || !Comparing.equal((String)type.getCanonicalText(), (String)typeParam.getName())) continue;
            String newName = GenerateMembersUtil.suggestUniqueTypeParameterName(typeParam.getName(), sourceTypeParameterList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class, (boolean)false));
            PsiTypeParameter newTypeParameter = factory.createTypeParameter(newName, typeParam.getSuperTypes());
            substitutor.put(typeParam, (PsiType)factory.createType((PsiClass)newTypeParameter));
            PsiTypeParameter psiTypeParameter = newTypeParameter;
            if (psiTypeParameter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
            }
            return psiTypeParameter;
        }
        PsiTypeParameter psiTypeParameter = factory.createTypeParameter(typeParam.getName(), typeParam.getSuperTypes());
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        return psiTypeParameter;
    }

    @NotNull
    private static String suggestUniqueTypeParameterName(String baseName, @NotNull PsiTypeParameterList typeParameterList, @Nullable PsiClass targetClass) {
        String newName;
        if (typeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "suggestUniqueTypeParameterName"));
        }
        int i2 = 0;
        while (!GenerateMembersUtil.checkUniqueTypeParameterName(newName = baseName + ++i2, typeParameterList) || targetClass != null && !GenerateMembersUtil.checkUniqueTypeParameterName(newName, targetClass.getTypeParameterList())) {
        }
        String string = newName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "suggestUniqueTypeParameterName"));
        }
        return string;
    }

    private static boolean checkUniqueTypeParameterName(@NotNull String baseName, @Nullable PsiTypeParameterList typeParameterList) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/codeInsight/generation/GenerateMembersUtil", "checkUniqueTypeParameterName"));
        }
        if (typeParameterList == null) {
            return true;
        }
        for (PsiTypeParameter typeParameter : typeParameterList.getTypeParameters()) {
            if (!Comparing.equal((String)typeParameter.getName(), (String)baseName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static PsiTypeParameter substituteTypeParameter(final @NotNull JVMElementFactory factory, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMethod", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        PsiElement copy = typeParameter.copy();
        HashMap replacementMap = new HashMap();
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Map)replacementMap, substitutor, sourceMethod){
            final /* synthetic */ Map val$replacementMap;
            final /* synthetic */ PsiSubstitutor val$substitutor;
            final /* synthetic */ PsiMethod val$sourceMethod;
            {
                this.val$replacementMap = map;
                this.val$substitutor = psiSubstitutor;
                this.val$sourceMethod = psiMethod;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiTypeParameter) {
                    PsiClassType type = factory.createType((PsiClass)((PsiTypeParameter)resolve));
                    this.val$replacementMap.put(reference, factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(this.val$substitutor, (PsiType)type, (PsiTypeParameterListOwner)this.val$sourceMethod)));
                }
            }
        });
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)RefactoringUtil.replaceElementsWithMap(copy, (Map<PsiElement, PsiElement>)replacementMap);
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        return psiTypeParameter;
    }

    private static void substituteParameters(@NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiParameterList sourceParameterList, @NotNull PsiParameterList targetParameterList, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (codeStyleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleManager", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (sourceParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceParameterList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (targetParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        PsiParameter[] parameters = sourceParameterList.getParameters();
        PsiParameter[] newParameters = GenerateMembersUtil.overriddenParameters(parameters, factory, codeStyleManager, substitutor, target);
        for (int i2 = 0; i2 < newParameters.length; ++i2) {
            PsiParameter newParameter = newParameters[i2];
            GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)parameters[i2], target, (PsiModifierListOwner)newParameter);
            targetParameterList.add((PsiElement)newParameter);
        }
    }

    public static PsiParameter[] overriddenParameters(PsiParameter[] parameters, @NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        if (codeStyleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleManager", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        PsiParameter[] result2 = new PsiParameter[parameters.length];
        UniqueNameGenerator generator = new UniqueNameGenerator();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter parameter = parameters[i2];
            PsiType parameterType = parameter.getType();
            PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType, (PsiTypeParameterListOwner)((PsiMethod)parameter.getDeclarationScope()));
            String paramName = parameter.getName();
            boolean isBaseNameGenerated = true;
            boolean isSubstituted = substituted.equals(parameterType);
            if (!isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, TypeConversionUtil.erasure((PsiType)parameterType), paramName)) {
                isBaseNameGenerated = false;
            }
            if (paramName == null || isBaseNameGenerated && !isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, parameterType, paramName) || !factory.isValidParameterName(paramName)) {
                String[] names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                paramName = names.length > 0 ? generator.generateUniqueName(names[0]) : generator.generateUniqueName("p");
            } else if (!generator.value(paramName)) {
                paramName = generator.generateUniqueName(paramName);
            }
            generator.addExistingName(paramName);
            result2[i2] = factory.createParameter(paramName, GenericsUtil.getVariableTypeByExpressionType((PsiType)substituted), target);
        }
        return result2;
    }

    private static void substituteThrows(@NotNull JVMElementFactory factory, @NotNull PsiReferenceList targetThrowsList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod, List<PsiClassType> thrownTypes) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (targetThrowsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetThrowsList", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMethod", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        for (PsiClassType thrownType : thrownTypes) {
            targetThrowsList.add(factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)thrownType, (PsiTypeParameterListOwner)sourceMethod)));
        }
    }

    private static void copyDocComment(PsiMethod source, PsiMethod target, JVMElementFactory factory) {
        PsiDocComment docComment;
        PsiElement navigationElement = source.getNavigationElement();
        if (navigationElement instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)navigationElement).getDocComment()) != null) {
            target.addAfter((PsiElement)factory.createDocCommentFromText(docComment.getText()), null);
        }
        PsiParameter[] sourceParameters = source.getParameterList().getParameters();
        PsiParameterList targetParameterList = target.getParameterList();
        RefactoringUtil.fixJavadocsForParams(target, new HashSet<PsiParameter>(Arrays.asList(targetParameterList.getParameters())), (Condition<Pair<PsiParameter, String>>)((Condition)pair -> {
            int parameterIndex = targetParameterList.getParameterIndex((PsiParameter)pair.first);
            if (parameterIndex >= 0 && parameterIndex < sourceParameters.length) {
                return Comparing.strEqual((String)((String)pair.second), (String)sourceParameters[parameterIndex].getName());
            }
            return false;
        }));
    }

    @NotNull
    private static PsiMethod createMethod(@NotNull JVMElementFactory factory, @NotNull PsiMethod method2, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        if (method2.isConstructor()) {
            PsiMethod psiMethod = factory.createConstructor(method2.getName(), target);
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
            }
            return psiMethod;
        }
        PsiMethod psiMethod = factory.createMethod(method2.getName(), (PsiType)PsiType.VOID, target);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        return psiMethod;
    }

    private static void substituteReturnType(@NotNull PsiManager manager, @NotNull PsiMethod method2, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        PsiTypeElement returnTypeElement = method2.getReturnTypeElement();
        if (returnTypeElement == null || returnType == null) {
            return;
        }
        PsiType substitutedReturnType = GenerateMembersUtil.substituteType(substitutor, returnType, (PsiTypeParameterListOwner)method2);
        returnTypeElement.replace((PsiElement)new LightTypeElement(manager, substitutedReturnType instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)substitutedReturnType) : substitutedReturnType));
    }

    @NotNull
    private static JVMElementFactory getFactory(@NotNull Project p, @Nullable PsiElement target) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/generation/GenerateMembersUtil", "getFactory"));
        }
        Object object = target == null ? JavaPsiFacade.getInstance((Project)p).getElementFactory() : JVMElementFactories.requireFactory((Language)target.getLanguage(), (Project)p);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "getFactory"));
        }
        return object;
    }

    private static boolean isBaseNameGenerated(JavaCodeStyleManager csManager, PsiType parameterType, String paramName) {
        if (Arrays.asList(csManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names).contains(paramName)) {
            return true;
        }
        String typeName = JavaCodeStyleManagerImpl.getTypeName(parameterType);
        return typeName != null && NameUtil.getSuggestionsByName((String)typeName, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)(parameterType instanceof PsiArrayType)).contains(paramName);
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type, @NotNull PsiTypeParameterListOwner owner) {
        PsiType deepComponentType;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteType"));
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)substitutor)) {
            return TypeConversionUtil.erasure((PsiType)type);
        }
        PsiType psiType = substitutor.substitute(type);
        if (psiType != null && !((deepComponentType = psiType.getDeepComponentType()) instanceof PsiCapturedWildcardType) && !(deepComponentType instanceof PsiWildcardType)) {
            return psiType;
        }
        return TypeConversionUtil.erasure((PsiType)type);
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }

    public static void setupGeneratedMethod(PsiMethod method2) {
        PsiClass containingClass = method2.getContainingClass();
        PsiClass base = containingClass == null ? null : containingClass.getSuperClass();
        PsiMethod overridden = base == null ? null : base.findMethodBySignature(method2, true);
        boolean emptyTemplate = true;
        PsiCodeBlock body = method2.getBody();
        if (body != null) {
            PsiJavaToken lBrace = body.getLBrace();
            int left = lBrace != null ? lBrace.getStartOffsetInParent() + 1 : 0;
            PsiJavaToken rBrace = body.getRBrace();
            int right = rBrace != null ? rBrace.getStartOffsetInParent() : body.getTextLength();
            emptyTemplate = StringUtil.isEmptyOrSpaces((String)body.getText().substring(left, right));
        }
        if (overridden == null) {
            if (emptyTemplate) {
                CreateFromUsageUtils.setupMethodBody(method2, containingClass);
            }
            return;
        }
        if (emptyTemplate) {
            OverrideImplementUtil.setupMethodBody(method2, overridden, containingClass);
        }
        OverrideImplementUtil.annotateOnOverrideImplement(method2, base, overridden);
    }

    @Deprecated
    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @NotNull PsiModifierListOwner targetParam) {
        if (sourceParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceParam", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        if (targetParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParam", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        GenerateMembersUtil.copyOrReplaceModifierList(sourceParam, null, targetParam);
    }

    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @Nullable PsiElement targetClass, @NotNull PsiModifierListOwner targetParam) {
        if (sourceParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceParam", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        if (targetParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParam", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        PsiModifierList sourceModifierList = sourceParam.getModifierList();
        PsiModifierList targetModifierList = targetParam.getModifierList();
        if (sourceModifierList != null && targetModifierList != null) {
            for (String m : PsiModifier.MODIFIERS) {
                targetModifierList.setModifierProperty(m, sourceParam.hasModifierProperty(m));
            }
            OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource(sourceParam, targetClass, targetParam);
        }
    }

    public static PsiMethod generateSimpleGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSimpleGetterPrototype"));
        }
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateGetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSimpleSetterPrototype"));
        }
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateSetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(PsiField field, PsiClass targetClass) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateSetterPrototype((PsiField)field, (PsiClass)targetClass));
    }

    public static String suggestGetterName(PsiField field) {
        PsiMethod prototype = GenerateMembersUtil.generateGetterPrototype(field);
        return prototype != null ? prototype.getName() : PropertyUtil.suggestGetterName((PsiField)field);
    }

    public static String suggestGetterName(String name, PsiType type, Project project2) {
        return GenerateMembersUtil.suggestGetterName(JavaPsiFacade.getElementFactory((Project)project2).createField(name, type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type));
    }

    public static String suggestSetterName(PsiField field) {
        PsiMethod prototype = GenerateMembersUtil.generateSetterPrototype(field);
        return prototype != null ? prototype.getName() : PropertyUtil.suggestSetterName((PsiField)field);
    }

    public static String suggestSetterName(String name, PsiType type, Project project2) {
        return GenerateMembersUtil.suggestSetterName(JavaPsiFacade.getElementFactory((Project)project2).createField(name, type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type));
    }

    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateGetterPrototype"));
        }
        return GenerateMembersUtil.generateGetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSetterPrototype"));
        }
        return GenerateMembersUtil.generateSetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, PsiClass aClass) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSetterPrototype"));
        }
        return GenerateMembersUtil.generatePrototype(field, aClass, true, SetterTemplatesManager.getInstance());
    }

    static PsiMethod generateGetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateGetterPrototype"));
        }
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, GetterTemplatesManager.getInstance());
    }

    static PsiMethod generateSetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSetterPrototype"));
        }
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, SetterTemplatesManager.getInstance());
    }

    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiClass psiClass, boolean ignoreInvalidTemplate, TemplatesManager templatesManager) {
        PsiMethod annotationTarget;
        PsiMethod result2;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generatePrototype"));
        }
        Project project2 = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String template = templatesManager.getDefaultTemplate().getTemplate();
        String methodText = GenerationUtil.velocityGenerateCode(psiClass, Collections.singletonList(field), (Map<String, String>)new HashMap(), template, 0, false);
        boolean isGetter = templatesManager instanceof GetterTemplatesManager;
        try {
            result2 = factory.createMethodFromText(methodText, (PsiElement)psiClass);
        }
        catch (IncorrectOperationException e) {
            if (ignoreInvalidTemplate) {
                LOG.info((Throwable)e);
                PsiMethod psiMethod = result2 = isGetter ? PropertyUtil.generateGetterPrototype((PsiField)field) : PropertyUtil.generateSetterPrototype((PsiField)field);
                assert (result2 != null) : field.getText();
            }
            throw new GenerateCodeException(e);
        }
        result2 = (PsiMethod)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)result2);
        if (isGetter) {
            annotationTarget = result2;
        } else {
            PsiParameter[] parameters = result2.getParameterList().getParameters();
            PsiParameter psiParameter = annotationTarget = parameters.length == 1 ? parameters[0] : null;
        }
        if (annotationTarget != null) {
            NullableNotNullManager.getInstance((Project)project2).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)annotationTarget);
        }
        return GenerateMembersUtil.generatePrototype(field, result2);
    }

    @Nullable
    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiMethod result2) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generatePrototype"));
        }
        return GenerateMembersUtil.setVisibility((PsiMember)field, GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), result2));
    }

    @Contract(value="_, null -> null")
    public static PsiMethod setVisibility(PsiMember member, PsiMethod prototype) {
        String newVisibility;
        if (prototype == null) {
            return null;
        }
        String visibility = CodeStyleSettingsManager.getSettings((Project)member.getProject()).VISIBILITY;
        if ("EscalateVisible".equals(visibility)) {
            PsiClass aClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
            newVisibility = PsiUtil.getMaximumModifierForMember((PsiClass)aClass, (boolean)false);
        } else {
            newVisibility = visibility;
        }
        VisibilityUtil.setVisibility((PsiModifierList)prototype.getModifierList(), (String)newVisibility);
        return prototype;
    }

    @Nullable
    public static PsiMethod annotateOnOverrideImplement(@Nullable PsiClass targetClass, @Nullable PsiMethod generated) {
        PsiMethod superMethod;
        if (generated == null || targetClass == null) {
            return generated;
        }
        if (CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).INSERT_OVERRIDE_ANNOTATION && (superMethod = targetClass.findMethodBySignature(generated, true)) != null && superMethod.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(generated, targetClass, superMethod, true);
        }
        return generated;
    }
}

