/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateSuperMethodCallHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GenerateSuperMethodCallHandler.class);

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/GenerateSuperMethodCallHandler", "invoke"));
        }
        PsiMethod method2 = GenerateSuperMethodCallHandler.canInsertSuper(editor, file2);
        LOG.assertTrue(method2 != null);
        PsiMethod template = (PsiMethod)method2.copy();
        OverrideImplementUtil.setupMethodBody(template, method2, method2.getContainingClass());
        PsiCodeBlock templateBody = template.getBody();
        LOG.assertTrue(templateBody != null, (Object)template);
        PsiStatement superCall = templateBody.getStatements()[0];
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        LOG.assertTrue(codeBlock != null);
        PsiElement toGo = codeBlock.getLBrace() == null ? codeBlock.addBefore((PsiElement)superCall, null) : (element.getParent() == codeBlock ? codeBlock.addBefore((PsiElement)superCall, element) : codeBlock.addAfter((PsiElement)superCall, (PsiElement)codeBlock.getLBrace()));
        toGo = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(toGo);
        editor.getCaretModel().moveToOffset(toGo.getTextOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static PsiMethod canInsertSuper(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        if (codeBlock == null) {
            return null;
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (method2 == null) {
            return null;
        }
        List superSignatures = method2.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            if (superSignature.getMethod().hasModifierProperty("abstract")) continue;
            return method2;
        }
        return null;
    }
}

