/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && HintManagerImpl.getInstanceImpl().hideHints(3, true, false)) {
            return;
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        HintManagerImpl hintManager;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/EscapeHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/hint/EscapeHandler", "isEnabledForCaret"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && (hintManager = HintManagerImpl.getInstanceImpl()).isEscapeHandlerEnabled()) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }
}

