/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.CallArgumentInfo;
import com.intellij.codeInsight.hints.CallInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.JavaHintUtilsKt;
import com.intellij.codeInsight.hints.JavaInlayParameterHintsProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiNewExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010%\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020*H\u0002\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayHintsProvider;", "", "()V", "createHintSet", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "info", "Lcom/intellij/codeInsight/hints/CallInfo;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "createHints", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "createHintsForResolvedMethod", "resolveResult", "Lcom/intellij/psi/ResolveResult;", "createInlayInfo", "callArgument", "Lcom/intellij/psi/PsiExpression;", "methodParam", "Lcom/intellij/psi/PsiParameter;", "createMergedHints", "results", "", "(Lcom/intellij/psi/PsiCallExpression;[Lcom/intellij/psi/ResolveResult;)Ljava/util/Set;", "createSameTypeInlays", "", "args", "Lcom/intellij/codeInsight/hints/CallArgumentInfo;", "createUnclearInlays", "getCallInfo", "method", "Lcom/intellij/psi/PsiMethod;", "getVarArgInlay", "isBuilderLike", "", "expression", "isMethodToShow", "isParamNameContainedInMethodName", "parameter", "isSetterNamed", "isUnclearExpression", "Lcom/intellij/psi/PsiElement;", "java-impl"})
public final class JavaInlayHintsProvider {
    public static final JavaInlayHintsProvider INSTANCE;

    @NotNull
    public final Set<InlayInfo> createHints(@NotNull PsiCallExpression callExpression) {
        Set<InlayInfo> set2;
        Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
        JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
        ResolveResult resolveResult2 = (ResolveResult)resolveResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveResult2, (String)"resolveResult");
        Set<InlayInfo> hints = this.createHintsForResolvedMethod(callExpression, resolveResult2);
        Collection collection = hints;
        if (!collection.isEmpty()) {
            return hints;
        }
        collection = callExpression;
        if (collection instanceof PsiMethodCallExpressionImpl) {
            ResolveResult[] resolveResultArray = (ResolveResult[])((PsiMethodCallExpressionImpl)callExpression).getMethodExpression().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"callExpression.methodExp\u2026ssion.multiResolve(false)");
            set2 = this.createMergedHints(callExpression, resolveResultArray);
        } else if (collection instanceof PsiNewExpressionImpl) {
            ResolveResult[] resolveResultArray = ((PsiNewExpressionImpl)callExpression).getConstructorFakeReference().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"callExpression.construct\u2026rence.multiResolve(false)");
            set2 = this.createMergedHints(callExpression, resolveResultArray);
        } else {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InlayInfo> createMergedHints(PsiCallExpression callExpression, ResolveResult[] results) {
        Set it;
        List resultSet;
        Iterable $receiver$iv;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Collection destination$iv$iv;
                    ResolveResult it2;
                    Iterable $receiver$iv$iv;
                    Object[] objectArray = results;
                    void var5_4 = $receiver$iv;
                    Collection collection = new ArrayList();
                    for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                        void element$iv$iv = $receiver$iv$iv[j];
                        it2 = (ResolveResult)element$iv$iv;
                        if (!(it2.getElement() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        it2 = (ResolveResult)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        Set<InlayInfo> set2 = INSTANCE.createHintsForResolvedMethod(callExpression, it2);
                        collection2.add(set2);
                    }
                    resultSet = (List)destination$iv$iv;
                    if (resultSet.isEmpty()) break block9;
                    $receiver$iv = resultSet;
                    for (Object element$iv : $receiver$iv) {
                        it = (Set)element$iv;
                        if (!it.isEmpty()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) break block10;
            }
            return SetsKt.emptySet();
        }
        $receiver$iv = resultSet;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right;
            it = (Set)iterator$iv.next();
            Set left = (Set)accumulator$iv;
            accumulator$iv = CollectionsKt.intersect((Iterable)left, (Iterable)((Iterable)right));
        }
        return (Set)accumulator$iv;
    }

    private final Set<InlayInfo> createHintsForResolvedMethod(PsiCallExpression callExpression, ResolveResult resolveResult) {
        JavaResolveResult substitutor;
        JavaResolveResult javaResolveResult;
        PsiElement element = resolveResult.getElement();
        ResolveResult resolveResult2 = resolveResult;
        if (!(resolveResult2 instanceof JavaResolveResult)) {
            resolveResult2 = null;
        }
        if ((javaResolveResult = (JavaResolveResult)resolveResult2) == null || (javaResolveResult = javaResolveResult.getSubstitutor()) == null) {
            javaResolveResult = substitutor = PsiSubstitutor.EMPTY;
        }
        if (element instanceof PsiMethod && this.isMethodToShow((PsiMethod)element, callExpression)) {
            CallInfo info = this.getCallInfo(callExpression, (PsiMethod)element);
            JavaResolveResult javaResolveResult2 = substitutor;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult2, (String)"substitutor");
            return this.createHintSet(info, (PsiSubstitutor)javaResolveResult2);
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InlayInfo> createHintSet(CallInfo info, PsiSubstitutor substitutor) {
        JavaInlayParameterHintsProvider hintsProvider;
        void $receiver;
        InlayInfo destination$iv$iv;
        Set $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = info.getRegularArgs();
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (!JavaHintUtilsKt.access$isAssignable(it, substitutor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List args = (List)destination$iv$iv;
        Set resultSet = SetsKt.mutableSetOf((Object[])new InlayInfo[0]);
        $receiver$iv$iv = resultSet;
        InlayInfo inlayInfo = INSTANCE.getVarArgInlay(info);
        if (inlayInfo != null) {
            destination$iv$iv = inlayInfo;
            InlayInfo it = destination$iv$iv;
            $receiver.add(it);
        }
        if ((hintsProvider = JavaInlayParameterHintsProvider.Companion.getInstance()).isShowForParamsWithSameType().get()) {
            $receiver.addAll((Collection)INSTANCE.createSameTypeInlays(args));
        }
        $receiver.addAll((Collection)INSTANCE.createUnclearInlays(args));
        return resultSet;
    }

    private final boolean isMethodToShow(PsiMethod method2, PsiCallExpression callExpression) {
        PsiParameter[] params = method2.getParameterList().getParameters();
        Object[] objectArray = params;
        if (objectArray.length == 0) {
            return false;
        }
        if (((Object[])params).length == 1) {
            if (this.isBuilderLike(callExpression, method2) || this.isSetterNamed(method2)) {
                return false;
            }
            JavaInlayParameterHintsProvider hintsProvider = JavaInlayParameterHintsProvider.Companion.getInstance();
            if (hintsProvider.isDoNotShowIfMethodNameContainsParameterName().get()) {
                PsiParameter psiParameter = params[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"params[0]");
                if (this.isParamNameContainedInMethodName(psiParameter, method2)) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> createUnclearInlays(List<CallArgumentInfo> args) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = args;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (!INSTANCE.isUnclearExpression((PsiElement)it.getArgument())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable iterable2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            InlayInfo inlayInfo;
            Object element$iv$iv = element$iv$iv$iv;
            CallArgumentInfo it = (CallArgumentInfo)element$iv$iv;
            if (INSTANCE.createInlayInfo(it.getArgument(), it.getParameter()) == null) continue;
            InlayInfo it$iv$iv = inlayInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final InlayInfo getVarArgInlay(CallInfo info) {
        boolean hasUnclearExpressions;
        Object v0;
        block3: {
            if (info.getVarArg() == null || info.getVarArgExpressions().isEmpty()) {
                return null;
            }
            Iterable iterable = info.getVarArgExpressions();
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                PsiExpression it = (PsiExpression)t;
                if (!INSTANCE.isUnclearExpression((PsiElement)it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        boolean bl = hasUnclearExpressions = v0 != null;
        if (hasUnclearExpressions) {
            return this.createInlayInfo((PsiExpression)CollectionsKt.first(info.getVarArgExpressions()), info.getVarArg());
        }
        return null;
    }

    private final boolean isBuilderLike(PsiCallExpression expression, PsiMethod method2) {
        if (expression instanceof PsiNewExpression) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)method2.getReturnType());
        if (psiType == null) {
            return false;
        }
        PsiType returnType = psiType;
        Object object = method2.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object calledMethodClassFqn = object;
        return returnType.equalsToText((String)calledMethodClassFqn);
    }

    private final boolean isSetterNamed(PsiMethod method2) {
        block2: {
            block3: {
                String methodName = method2.getName();
                if (!StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null)) break block2;
                if (methodName.length() == 3) break block3;
                if (methodName.length() <= 3) break block2;
                char c = methodName.charAt(3);
                if (!Character.isUpperCase(c)) break block2;
            }
            return true;
        }
        return false;
    }

    private final boolean isParamNameContainedInMethodName(PsiParameter parameter, PsiMethod method2) {
        String string = parameter.getName();
        if (string == null) {
            return false;
        }
        String parameterName = string;
        if (parameterName.length() > 1) {
            CharSequence charSequence = method2.getName();
            CharSequence charSequence2 = parameterName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"parameterName");
            return StringsKt.contains((CharSequence)charSequence, (CharSequence)charSequence2, (boolean)true);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> createSameTypeInlays(List<CallArgumentInfo> args) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Object it;
        Object element$iv2;
        Iterable $receiver$iv;
        Iterable destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2 = args;
        Iterable iterable = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it2;
            CallArgumentInfo callArgumentInfo = (CallArgumentInfo)item$iv$iv;
            void var20_6 = destination$iv$iv2;
            String string = JavaHintUtilsKt.access$typeText(it2.getParameter());
            var20_6.add(string);
        }
        List all = (List)destination$iv$iv2;
        List duplicated = CollectionsKt.toMutableList((Collection)all);
        $receiver$iv$iv2 = CollectionsKt.distinct((Iterable)all);
        for (Object element$iv2 : $receiver$iv) {
            it = (String)element$iv2;
            duplicated.remove(it);
        }
        $receiver$iv = args;
        destination$iv$iv2 = $receiver$iv;
        element$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallArgumentInfo it3 = (CallArgumentInfo)element$iv$iv;
            if (!duplicated.contains(JavaHintUtilsKt.access$typeText(it3.getParameter()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            InlayInfo inlayInfo;
            Object element$iv$iv = element$iv$iv$iv;
            CallArgumentInfo it4 = (CallArgumentInfo)element$iv$iv;
            if (INSTANCE.createInlayInfo(it4.getArgument(), it4.getParameter()) == null) continue;
            InlayInfo it$iv$iv = inlayInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final InlayInfo createInlayInfo(PsiExpression callArgument, PsiParameter methodParam) {
        String string = methodParam.getName();
        if (string == null) {
            return null;
        }
        String paramName = string;
        String paramToShow = (methodParam.getType() instanceof PsiEllipsisType ? "..." : "") + paramName;
        return new InlayInfo(paramToShow, callArgument.getTextRange().getStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final CallInfo getCallInfo(PsiCallExpression callExpression, PsiMethod method2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        PsiParameter[] params = method2.getParameterList().getParameters();
        PsiParameter psiParameter = (PsiParameter)ArraysKt.lastOrNull((Object[])params);
        boolean hasVarArg = psiParameter != null ? psiParameter.isVarArgs() : false;
        int regularParamsCount = hasVarArg ? ((Object[])params).length - 1 : ((Object[])params).length;
        PsiExpression[] psiExpressionArray = callExpression.getArgumentList();
        if (psiExpressionArray == null || (psiExpressionArray = psiExpressionArray.getExpressions()) == null) {
            psiExpressionArray = (PsiExpression[])((Object[])new PsiExpression[0]);
        }
        PsiExpression[] arguments = psiExpressionArray;
        Iterable iterable = ArraysKt.take((Object[])params, (int)regularParamsCount);
        Object[] objectArray = arguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"arguments");
        Iterable iterable2 = CollectionsKt.zip((Iterable)iterable, (Object[])objectArray);
        void var9_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            void var17_13 = destination$iv$iv;
            PsiParameter psiParameter2 = (PsiParameter)it.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter2, (String)"it.first");
            PsiExpression psiExpression = (PsiExpression)it.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression, (String)"it.second");
            CallArgumentInfo callArgumentInfo = new CallArgumentInfo(psiParameter2, psiExpression);
            var17_13.add(callArgumentInfo);
        }
        List regularArgInfos = (List)destination$iv$iv;
        PsiParameter varargParam = hasVarArg ? (PsiParameter)ArraysKt.last((Object[])params) : (PsiParameter)null;
        List varargExpressions = ArraysKt.drop((Object[])arguments, (int)regularParamsCount);
        return new CallInfo(regularArgInfos, varargParam, varargExpressions);
    }

    private final boolean isUnclearExpression(PsiElement callArgument) {
        boolean bl;
        PsiElement psiElement = callArgument;
        if (psiElement instanceof PsiLiteralExpression) {
            bl = true;
        } else if (psiElement instanceof PsiThisExpression) {
            bl = true;
        } else if (psiElement instanceof PsiBinaryExpression) {
            bl = true;
        } else if (psiElement instanceof PsiPolyadicExpression) {
            bl = true;
        } else if (psiElement instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)callArgument).getOperationTokenType();
            boolean isLiteral = ((PsiPrefixExpression)callArgument).getOperand() instanceof PsiLiteralExpression;
            bl = isLiteral && (Intrinsics.areEqual((Object)JavaTokenType.MINUS, (Object)tokenType) || Intrinsics.areEqual((Object)JavaTokenType.PLUS, (Object)tokenType));
        } else {
            bl = false;
        }
        boolean isShowHint = bl;
        return isShowHint;
    }

    private JavaInlayHintsProvider() {
        INSTANCE = this;
    }

    static {
        new JavaInlayHintsProvider();
    }
}

