/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSubclassAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ImplementAbstractClassAction");
    private String myText = CodeInsightBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]);
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSubclassAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.implement.abstract.class.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSubclassAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        TextRange elementTextRange;
        PsiElement lBrace;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSubclassAction", "isAvailable"));
        }
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file2.findElementAt(position);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null || psiClass.isAnnotationType() || psiClass.isEnum() || psiClass instanceof PsiAnonymousClass || psiClass.hasModifierProperty("final")) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
        if (virtualFile == null || virtualFile.getFileType() == ScratchFileType.INSTANCE) {
            return false;
        }
        if (!this.isSupportedLanguage(psiClass)) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length > 0) {
            boolean hasNonPrivateConstructor = false;
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                hasNonPrivateConstructor = true;
                break;
            }
            if (!hasNonPrivateConstructor) {
                return false;
            }
        }
        if ((lBrace = psiClass.getLBrace()) == null) {
            return false;
        }
        if (element.getTextOffset() >= lBrace.getTextOffset()) {
            return false;
        }
        TextRange declarationRange = HighlightNamesUtil.getClassDeclarationTextRange(psiClass);
        if (!declarationRange.contains(elementTextRange = element.getTextRange()) && (!(element instanceof PsiWhiteSpace) || declarationRange.getStartOffset() != elementTextRange.getEndOffset() && declarationRange.getEndOffset() != elementTextRange.getStartOffset())) {
            return false;
        }
        this.myText = CreateSubclassAction.getTitle(psiClass);
        return true;
    }

    protected boolean isSupportedLanguage(PsiClass aClass) {
        return aClass.getLanguage() == JavaLanguage.INSTANCE;
    }

    protected static String getTitle(PsiClass psiClass) {
        return psiClass.isInterface() ? CodeInsightBundle.message((String)"intention.implement.abstract.class.interface.text", (Object[])new Object[0]) : (psiClass.hasModifierProperty("abstract") ? CodeInsightBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"intention.implement.abstract.class.subclass.text", (Object[])new Object[0]));
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSubclassAction", "invoke"));
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        LOG.assertTrue(psiClass != null);
        if (psiClass.hasModifierProperty("private") && psiClass.getContainingClass() != null) {
            CreateSubclassAction.createInnerClass(psiClass);
            return;
        }
        this.createTopLevelClass(psiClass);
    }

    public static void createInnerClass(final PsiClass aClass) {
        new WriteCommandAction(aClass.getProject(), CreateSubclassAction.getTitle(aClass), CreateSubclassAction.getTitle(aClass), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/CreateSubclassAction$1", "run"));
                }
                PsiClass containingClass = aClass.getContainingClass();
                LOG.assertTrue(containingClass != null);
                PsiTypeParameterList oldTypeParameterList = aClass.getTypeParameterList();
                PsiClass classFromText = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createClass(aClass.getName() + CreateSubclassAction.IMPL_SUFFIX);
                classFromText = (PsiClass)containingClass.addAfter((PsiElement)classFromText, (PsiElement)aClass);
                CreateSubclassAction.startTemplate(oldTypeParameterList, aClass.getProject(), aClass, classFromText, true);
            }
        }.execute();
    }

    protected void createTopLevelClass(PsiClass psiClass) {
        CreateClassDialog dlg = CreateSubclassAction.chooseSubclassToCreate(psiClass);
        if (dlg != null) {
            CreateSubclassAction.createSubclass(psiClass, dlg.getTargetDirectory(), dlg.getClassName());
        }
    }

    @Nullable
    public static CreateClassDialog chooseSubclassToCreate(PsiClass psiClass) {
        final PsiDirectory sourceDir = psiClass.getContainingFile().getContainingDirectory();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        PsiPackage aPackage = sourceDir != null ? JavaDirectoryService.getInstance().getPackage(sourceDir) : null;
        CreateClassDialog dialog2 = new CreateClassDialog(psiClass.getProject(), CreateSubclassAction.getTitle(psiClass), psiClass.getName() + IMPL_SUFFIX, aPackage != null ? aPackage.getQualifiedName() : "", CreateClassKind.CLASS, true, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)){

            @Override
            protected PsiDirectory getBaseDir(String packageName) {
                return sourceDir != null && fileIndex.getSourceRootForFile(sourceDir.getVirtualFile()) != null ? sourceDir : super.getBaseDir(packageName);
            }

            @Override
            protected boolean reportBaseInTestSelectionInSource() {
                return true;
            }
        };
        if (!dialog2.showAndGet()) {
            return null;
        }
        PsiDirectory targetDirectory = dialog2.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return dialog2;
    }

    public static PsiClass createSubclass(final PsiClass psiClass, final PsiDirectory targetDirectory, final String className) {
        final Project project2 = psiClass.getProject();
        final PsiClass[] targetClass = new PsiClass[1];
        new WriteCommandAction(project2, CreateSubclassAction.getTitle(psiClass), CreateSubclassAction.getTitle(psiClass), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/CreateSubclassAction$3", "run"));
                }
                IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
                PsiTypeParameterList oldTypeParameterList = psiClass.getTypeParameterList();
                try {
                    targetClass[0] = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project2, (String)(CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{className}) + "\n" + e.getLocalizedMessage()), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
                    return;
                }
                CreateSubclassAction.startTemplate(oldTypeParameterList, project2, psiClass, targetClass[0], false);
            }
        }.execute();
        if (targetClass[0] == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !psiClass.hasTypeParameters()) {
            Editor editor = CodeInsightUtil.positionCursorAtLBrace(project2, targetClass[0].getContainingFile(), targetClass[0]);
            if (editor == null) {
                return targetClass[0];
            }
            CreateSubclassAction.chooseAndImplement(psiClass, project2, targetClass[0], editor);
        }
        return targetClass[0];
    }

    private static void startTemplate(PsiTypeParameterList oldTypeParameterList, final Project project2, final PsiClass psiClass, PsiClass targetClass, boolean includeClassName) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiJavaCodeReferenceElement ref = elementFactory.createClassReferenceElement(psiClass);
        try {
            ref = psiClass.isInterface() ? (PsiJavaCodeReferenceElement)targetClass.getImplementsList().add((PsiElement)ref) : (PsiJavaCodeReferenceElement)targetClass.getExtendsList().add((PsiElement)ref);
            if (psiClass.hasTypeParameters() || includeClassName) {
                TemplateBuilderImpl templateBuilder;
                final Editor editor = CodeInsightUtil.positionCursorAtLBrace(project2, targetClass.getContainingFile(), targetClass);
                TemplateBuilderImpl templateBuilderImpl = templateBuilder = editor != null ? (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)targetClass) : null;
                if (includeClassName && templateBuilder != null) {
                    templateBuilder.replaceElement((PsiElement)targetClass.getNameIdentifier(), targetClass.getName());
                }
                if (oldTypeParameterList != null) {
                    for (PsiTypeParameter parameter : oldTypeParameterList.getTypeParameters()) {
                        PsiElement param = ref.getParameterList().add((PsiElement)elementFactory.createTypeElement((PsiType)elementFactory.createType((PsiClass)parameter)));
                        if (templateBuilder == null) continue;
                        templateBuilder.replaceElement(param, param.getText());
                    }
                }
                CreateSubclassAction.replaceTypeParamsList(targetClass, oldTypeParameterList);
                if (templateBuilder != null) {
                    templateBuilder.setEndVariableBefore((PsiElement)ref);
                    Template template = templateBuilder.buildTemplate();
                    template.addEndVariable();
                    final PsiFile containingFile = targetClass.getContainingFile();
                    PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    TextRange textRange = targetClass.getTextRange();
                    final RangeMarker startClassOffset = editor.getDocument().createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
                    startClassOffset.setGreedyToLeft(true);
                    startClassOffset.setGreedyToRight(true);
                    editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                    CreateFromUsageBaseFix.startTemplate(editor, template, project2, new TemplateEditingAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void templateFinished(Template template, boolean brokenOff) {
                            try {
                                LOG.assertTrue(startClassOffset.isValid(), (Object)startClassOffset);
                                PsiElement psiElement = containingFile.findElementAt(startClassOffset.getStartOffset());
                                PsiClass aTargetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
                                LOG.assertTrue(aTargetClass != null, (Object)psiElement);
                                CreateSubclassAction.chooseAndImplement(psiClass, project2, aTargetClass, editor);
                            }
                            finally {
                                startClassOffset.dispose();
                            }
                        }
                    }, CreateSubclassAction.getTitle(psiClass));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiElement replaceTypeParamsList(PsiClass psiClass, PsiTypeParameterList oldTypeParameterList) {
        PsiTypeParameterList typeParameterList = psiClass.getTypeParameterList();
        assert (typeParameterList != null);
        return typeParameterList.replace((PsiElement)oldTypeParameterList);
    }

    protected static void chooseAndImplement(PsiClass psiClass, Project project2, @NotNull PsiClass targetClass, Editor editor) {
        PsiMethod[] constructors;
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/codeInsight/intention/impl/CreateSubclassAction", "chooseAndImplement"));
        }
        boolean hasNonTrivialConstructor = false;
        for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() <= 0) continue;
            hasNonTrivialConstructor = true;
            break;
        }
        if (hasNonTrivialConstructor) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            ArrayList<PsiMethodMember> baseConstructors = new ArrayList<PsiMethodMember>();
            for (PsiMethod baseConstr : constructors) {
                if (!PsiUtil.isAccessible((Project)project2, (PsiMember)baseConstr, (PsiElement)targetClass, (PsiClass)targetClass)) continue;
                baseConstructors.add(new PsiMethodMember(baseConstr, substitutor));
            }
            int offset = editor.getCaretModel().getOffset();
            CreateConstructorMatchingSuperFix.chooseConstructor2Delegate(project2, editor, substitutor, baseConstructors, constructors, targetClass);
            editor.getCaretModel().moveToOffset(offset);
        }
        OverrideImplementUtil.chooseAndImplementMethods(project2, editor, targetClass);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

