/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchIntention
extends BaseElementAtCaretIntentionAction {
    public static final String TEXT = "Create switch statement";

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "invoke"));
        }
        PsiExpressionStatement expressionStatement = CreateSwitchIntention.resolveExpressionStatement(element);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)elementFactory.createStatementFromText(String.format("switch (%s) {}", expressionStatement.getExpression().getText()), null);
        switchStatement = (PsiSwitchStatement)expressionStatement.replace((PsiElement)switchStatement);
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)switchStatement);
        PsiJavaToken lBrace = switchStatement.getBody().getLBrace();
        editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + lBrace.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "isAvailable"));
        }
        PsiExpressionStatement expressionStatement = CreateSwitchIntention.resolveExpressionStatement(element);
        return expressionStatement != null && CreateSwitchIntention.isValidTypeForSwitch(expressionStatement.getExpression().getType(), (PsiElement)expressionStatement);
    }

    private static PsiExpressionStatement resolveExpressionStatement(PsiElement element) {
        if (element instanceof PsiExpressionStatement) {
            return (PsiExpressionStatement)element;
        }
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        return psiStatement instanceof PsiExpressionStatement ? (PsiExpressionStatement)psiStatement : null;
    }

    private static boolean isValidTypeForSwitch(@Nullable PsiType type, PsiElement context) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            if (resolvedClass == null) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && resolvedClass.isEnum() || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && "java.lang.String".equals(resolvedClass.getQualifiedName());
        }
        return type.equals(PsiType.INT) || type.equals(PsiType.BYTE) || type.equals(PsiType.SHORT) || type.equals(PsiType.CHAR);
    }

    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "getFamilyName"));
        }
        return TEXT;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "getText"));
        }
        return string;
    }
}

