/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementationSearcher {
    public static final String SEARCHING_FOR_IMPLEMENTATIONS = CodeInsightBundle.message((String)"searching.for.implementations", (Object[])new Object[0]);

    @Nullable
    PsiElement[] searchImplementations(Editor editor, PsiElement element, int offset) {
        TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
        boolean onRef = (Boolean)ReadAction.compute(() -> targetElementUtil.findTargetElement(editor, ImplementationSearcher.getFlags() & 0xFFFFFFF6, offset) == null);
        return this.searchImplementations(element, editor, onRef && (Boolean)ReadAction.compute(() -> element == null || targetElementUtil.includeSelfInGotoImplementation(element)) != false, onRef);
    }

    @Nullable
    public PsiElement[] searchImplementations(PsiElement element, Editor editor, boolean includeSelfAlways, boolean includeSelfIfNoOthers) {
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        Object[] elements = this.searchDefinitions(element, editor);
        if (elements == null) {
            return null;
        }
        if (elements.length > 0) {
            return this.filterElements(element, (PsiElement[])(includeSelfAlways ? (PsiElement[])ArrayUtil.prepend((Object)element, (Object[])elements) : elements));
        }
        if (includeSelfAlways || includeSelfIfNoOthers) {
            return new PsiElement[]{element};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected static SearchScope getSearchScope(PsiElement element, Editor editor) {
        return (SearchScope)ReadAction.compute(() -> TargetElementUtil.getInstance().getSearchScope(editor, element));
    }

    @Nullable(value="For the case the search has been cancelled")
    protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
        PsiElement[][] result2 = new PsiElement[1][];
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                result2[0] = (PsiElement[])this.search(element, editor).toArray((Object[])PsiElement.EMPTY_ARRAY);
            }
            catch (IndexNotReadyException e) {
                ImplementationSearcher.dumbModeNotification(element);
                result2[0] = null;
            }
        }, SEARCHING_FOR_IMPLEMENTATIONS, true, element.getProject())) {
            return null;
        }
        return result2[0];
    }

    protected Query<PsiElement> search(PsiElement element, Editor editor) {
        return DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)ImplementationSearcher.getSearchScope(element, editor), (boolean)this.isSearchDeep());
    }

    protected boolean isSearchDeep() {
        return true;
    }

    private static void dumbModeNotification(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/ImplementationSearcher", "dumbModeNotification"));
        }
        Project project2 = (Project)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/ImplementationSearcher", "lambda$dumbModeNotification$4"));
            }
            return element.getProject();
        });
        DumbService.getInstance((Project)project2).showDumbModeNotification("Implementation information isn't available while indices are built");
    }

    protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
        return targetElements;
    }

    public static int getFlags() {
        return TargetElementUtil.getInstance().getDefinitionSearchFlags();
    }

    public static abstract class BackgroundableImplementationSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
            CommonProcessors.CollectProcessor<PsiElement> processor2 = new CommonProcessors.CollectProcessor<PsiElement>(){

                public boolean process(PsiElement element) {
                    this.processElement(element);
                    return super.process((Object)element);
                }
            };
            try {
                this.search(element, editor).forEach((Processor)processor2);
            }
            catch (IndexNotReadyException e) {
                ImplementationSearcher.dumbModeNotification(element);
                return null;
            }
            return (PsiElement[])processor2.toArray((Object[])PsiElement.EMPTY_ARRAY);
        }

        protected abstract void processElement(PsiElement var1);
    }

    public static class FirstImplementationsSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(final PsiElement element, final Editor editor) {
            PsiElement[] psiElementArray;
            if (this.canShowPopupWithOneItem(element)) {
                return new PsiElement[]{element};
            }
            final PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
            final PsiElement[] result2 = new PsiElement[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.search(element, editor).forEach((Processor)new PsiElementProcessorAdapter<PsiElement>((PsiElementProcessor)collectProcessor){

                            public boolean processInReadAction(PsiElement element) {
                                return !this.accept(element) || super.processInReadAction(element);
                            }
                        });
                        result2[0] = collectProcessor.getFoundElement();
                    }
                    catch (IndexNotReadyException e) {
                        ImplementationSearcher.dumbModeNotification(element);
                        result2[0] = null;
                    }
                }
            }, SEARCHING_FOR_IMPLEMENTATIONS, true, element.getProject())) {
                return null;
            }
            PsiElement foundElement = result2[0];
            if (foundElement != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = foundElement;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }

        protected boolean canShowPopupWithOneItem(PsiElement element) {
            return this.accept(element);
        }

        protected boolean accept(PsiElement element) {
            return true;
        }
    }
}

