/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateContext {
    private final Map<String, Boolean> myContextStates = ContainerUtil.newTroveMap();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    @Nullable
    TemplateContextType getDifference(@NotNull TemplateContext defaultContext) {
        if (defaultContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultContext", "com/intellij/codeInsight/template/impl/TemplateContext", "getDifference"));
        }
        return (TemplateContextType)ContainerUtil.find((Object[])TemplateManagerImpl.getAllContextTypes(), type -> {
            if (defaultContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultContext", "com/intellij/codeInsight/template/impl/TemplateContext", "lambda$getDifference$0"));
            }
            return this.isEnabled((TemplateContextType)type) != defaultContext.isEnabled((TemplateContextType)type);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/intellij/codeInsight/template/impl/TemplateContext", "isEnabled"));
        }
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            Boolean storedValue = this.getOwnValue(contextType);
            if (storedValue == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                TemplateContextType baseContextType = contextType.getBaseContextType();
                return baseContextType != null && this.isEnabled(baseContextType);
            }
            return storedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean getOwnValue(TemplateContextType contextType) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            return this.myContextStates.get(contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            this.myContextStates.put(contextType.getContextId(), value);
        }
    }

    @VisibleForTesting
    public void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defContext", "com/intellij/codeInsight/template/impl/TemplateContext", "setDefaultContext"));
        }
        HashMap<String, Boolean> copy = new HashMap<String, Boolean>(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll(copy);
    }

    @VisibleForTesting
    public void readTemplateContext(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/impl/TemplateContext", "readTemplateContext"));
        }
        for (Element option : element.getChildren("option")) {
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            this.myContextStates.put((String)ContainerUtil.getOrElse((Map)ContextInterner.internMap, (Object)name, (Object)name), Boolean.parseBoolean(value));
        }
        this.myContextStates.putAll(this.makeInheritanceExplicit());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit() {
        HashMap explicitStates = ContainerUtil.newHashMap();
        for (TemplateContextType type : ContainerUtil.filter((Object[])TemplateManagerImpl.getAllContextTypes(), this::isDisabledByInheritance)) {
            explicitStates.put(type.getContextId(), false);
        }
        HashMap hashMap = explicitStates;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateContext", "makeInheritanceExplicit"));
        }
        return hashMap;
    }

    private boolean isDisabledByInheritance(TemplateContextType type) {
        return !this.hasOwnValue(type) && !this.isEnabled(type) && JBIterable.generate((Object)type, TemplateContextType::getBaseContextType).filter(this::hasOwnValue).first() != null;
    }

    private boolean hasOwnValue(TemplateContextType t) {
        return this.getOwnValue(t) != null;
    }

    public Element writeTemplateContext(@Nullable TemplateContext defaultContext) {
        return this.writeTemplateContext(defaultContext, TemplateContext.getIdToType());
    }

    @VisibleForTesting
    @Nullable
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext, @NotNull Lazy<Map<String, TemplateContextType>> idToType) {
        if (idToType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToType", "com/intellij/codeInsight/template/impl/TemplateContext", "writeTemplateContext"));
        }
        if (this.myContextStates.isEmpty()) {
            return null;
        }
        Element element = new Element("context");
        ArrayList<Map.Entry<String, Boolean>> entries = new ArrayList<Map.Entry<String, Boolean>>(this.myContextStates.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : entries) {
            Boolean ownValue = (Boolean)entry.getValue();
            if (ownValue == null) continue;
            TemplateContextType type = (TemplateContextType)((Map)idToType.getValue()).get(entry.getKey());
            if (type == null) {
                JdomKt.addOptionTag(element, (String)entry.getKey(), ownValue.toString());
                continue;
            }
            if (!this.isValueChanged(ownValue, type, defaultContext)) continue;
            JdomKt.addOptionTag(element, type.getContextId(), ownValue.toString());
        }
        return element;
    }

    @NotNull
    public static Lazy<Map<String, TemplateContextType>> getIdToType() {
        Lazy lazy = LazyKt.lazy((Function0)new Function0<Map<String, TemplateContextType>>(){

            public Map<String, TemplateContextType> invoke() {
                THashMap idToType = new THashMap();
                for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                    idToType.put(type.getContextId(), type);
                }
                return idToType;
            }
        });
        if (lazy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateContext", "getIdToType"));
        }
        return lazy;
    }

    private boolean isValueChanged(@NotNull Boolean ownValue, @NotNull TemplateContextType type, @Nullable TemplateContext defaultContext) {
        Boolean defaultValue;
        if (ownValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownValue", "com/intellij/codeInsight/template/impl/TemplateContext", "isValueChanged"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/template/impl/TemplateContext", "isValueChanged"));
        }
        Boolean bl = defaultValue = defaultContext == null ? null : defaultContext.getOwnValue(type);
        if (defaultValue == null) {
            TemplateContextType base = type.getBaseContextType();
            boolean baseEnabled = base != null && this.isEnabled(base);
            return ownValue != baseEnabled;
        }
        return !ownValue.equals(defaultValue);
    }

    public String toString() {
        return this.myContextStates.toString();
    }

    private static class ContextInterner {
        private static final Map<String, String> internMap = Arrays.stream(TemplateContextType.EP_NAME.getExtensions()).map(TemplateContextType::getContextId).distinct().collect(Collectors.toMap(Function.identity(), Function.identity()));

        private ContextInterner() {
        }
    }
}

