/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class PostfixTemplate {
    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myKey;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExample;

    protected PostfixTemplate(@NotNull String name, @NotNull String example) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        this(name, "." + name, example);
    }

    protected PostfixTemplate(@NotNull String name, @NotNull String key2, @NotNull String example) {
        String tempDescription;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "<init>"));
        }
        this.myPresentableName = name;
        this.myKey = key2;
        this.myExample = example;
        try {
            tempDescription = new PostfixTemplateMetaData(this).getDescription().getText();
        }
        catch (IOException e) {
            tempDescription = "Under construction";
        }
        this.myDescription = tempDescription;
    }

    @NotNull
    public final String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getKey"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getExample() {
        String string = this.myExample;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate", "getExample"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isEnabled(PostfixTemplateProvider provider) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplateEnabled(this, provider);
    }

    public abstract boolean isApplicable(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    public abstract void expand(@NotNull PsiElement var1, @NotNull Editor var2);
}

