/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInefficientStreamCountInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final CallMatcher STREAM_COUNT = CallMatcher.instanceCall("java.util.stream.Stream", "count").parameterCount(0);
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMatcher STREAM_FLAT_MAP = CallMatcher.instanceCall("java.util.stream.Stream", "flatMap").parameterTypes("java.util.function.Function");
    private static final CallMapper<CountFix> FIX_MAPPER = new CallMapper<Function<PsiMethodCallExpression, CountFix>>().register(COLLECTION_STREAM, call -> new CountFix(false)).register(STREAM_FLAT_MAP, call -> ReplaceInefficientStreamCountInspection.doesFlatMapCallCollectionStream(call) ? new CountFix(true) : null);
    private static final Logger LOG = Logger.getInstance(ReplaceInefficientStreamCountInspection.class);
    private static final String SIZE_METHOD = "size";
    private static final String STREAM_METHOD = "stream";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                if (STREAM_COUNT.test(methodCall)) {
                    PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(methodCall);
                    CountFix fix = (CountFix)FIX_MAPPER.mapFirst(qualifierCall);
                    if (fix != null) {
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        LOG.assertTrue(nameElement != null);
                        holder.registerProblem((PsiElement)methodCall, nameElement.getTextRange().shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new LocalQuickFix[]{fix});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static boolean doesFlatMapCallCollectionStream(PsiMethodCallExpression flatMapCall) {
        PsiExpression function = flatMapCall.getArgumentList().getExpressions()[0];
        if (function instanceof PsiMethodReferenceExpression) {
            PsiClass containingClass;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)function;
            if (!STREAM_METHOD.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method2 = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (method2 != null && STREAM_METHOD.equals(method2.getName()) && method2.getParameterList().getParametersCount() == 0 && (containingClass = method2.getContainingClass()) != null && "java.util.Collection".equals(containingClass.getQualifiedName())) {
                return true;
            }
        } else if (function instanceof PsiLambdaExpression) {
            PsiExpression expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)function);
            return expression instanceof PsiMethodCallExpression && COLLECTION_STREAM.test((PsiMethodCallExpression)expression);
        }
        return false;
    }

    @Nullable
    private static PsiExpression extractLambdaReturnExpression(PsiLambdaExpression lambda2) {
        PsiStatement[] statements;
        PsiElement lambdaBody = lambda2.getBody();
        PsiExpression expression = null;
        if (lambdaBody instanceof PsiExpression) {
            expression = (PsiExpression)lambdaBody;
        } else if (lambdaBody instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambdaBody).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            expression = ((PsiReturnStatement)statements[0]).getReturnValue();
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
    }

    private static class CountFix
    implements LocalQuickFix {
        private final boolean myFlatMapMode;

        CountFix(boolean flatMapMode) {
            this.myFlatMapMode = flatMapMode;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myFlatMapMode ? "Replace Stream.flatMap().count() with Stream.mapToLong().sum()" : "Replace Collection.stream().count() with Collection.size()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace inefficient Stream.count()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "getFamilyName"));
            }
            return "Replace inefficient Stream.count()";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression countCall = (PsiMethodCallExpression)element;
            PsiElement countName = countCall.getMethodExpression().getReferenceNameElement();
            if (countName == null) {
                return;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(countCall);
            if (qualifierCall == null) {
                return;
            }
            if (this.myFlatMapMode) {
                CountFix.replaceFlatMap(countName, qualifierCall);
            } else {
                CountFix.replaceSimpleCount(countCall, qualifierCall);
            }
        }

        private static void replaceSimpleCount(PsiMethodCallExpression countCall, PsiMethodCallExpression qualifierCall) {
            String replacementText;
            PsiElement replacement;
            PsiTypeElement castElement;
            if (!COLLECTION_STREAM.test(qualifierCall)) {
                return;
            }
            PsiReferenceExpression methodExpression = qualifierCall.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            methodExpression.handleElementRename(ReplaceInefficientStreamCountInspection.SIZE_METHOD);
            boolean addCast = true;
            PsiMethodCallExpression toReplace = countCall;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)countCall.getParent());
            if (parent instanceof PsiExpressionStatement) {
                addCast = false;
            } else if (parent instanceof PsiTypeCastExpression && (castElement = ((PsiTypeCastExpression)parent).getCastType()) != null && castElement.getType() instanceof PsiPrimitiveType) {
                addCast = false;
                if (PsiType.INT.equals((Object)castElement.getType())) {
                    toReplace = parent;
                }
            }
            CommentTracker ct = new CommentTracker();
            PsiReferenceParameterList parameterList = methodExpression.getParameterList();
            if (parameterList != null) {
                ct.delete((PsiElement)parameterList);
            }
            if ((replacement = ct.replaceAndRestoreComments((PsiElement)toReplace, replacementText = (addCast ? "(long) " : "") + ct.text((PsiElement)methodExpression) + "()")) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)replacement))) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)replacement));
            }
        }

        private static void replaceFlatMap(PsiElement countName, PsiMethodCallExpression qualifierCall) {
            PsiExpression expression;
            if (!STREAM_FLAT_MAP.test(qualifierCall)) {
                return;
            }
            PsiElement flatMapName = qualifierCall.getMethodExpression().getReferenceNameElement();
            if (flatMapName == null) {
                return;
            }
            PsiExpression parameter = qualifierCall.getArgumentList().getExpressions()[0];
            PsiElement streamCallName = null;
            if (parameter instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)parameter;
                streamCallName = methodRef.getReferenceNameElement();
            } else if (parameter instanceof PsiLambdaExpression && (expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression) {
                streamCallName = ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement();
            }
            if (streamCallName == null || !streamCallName.getText().equals(ReplaceInefficientStreamCountInspection.STREAM_METHOD)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)qualifierCall.getProject());
            streamCallName.replace((PsiElement)factory.createIdentifier(ReplaceInefficientStreamCountInspection.SIZE_METHOD));
            flatMapName.replace((PsiElement)factory.createIdentifier("mapToLong"));
            countName.replace((PsiElement)factory.createIdentifier("sum"));
            PsiReferenceParameterList parameterList = qualifierCall.getMethodExpression().getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }

        public String getMessage() {
            return this.myFlatMapMode ? "Stream.flatMap().count() can be replaced with Stream.mapToLong().sum()" : "Collection.stream().count() can be replaced with Collection.size()";
        }
    }
}

