/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMatcher STREAM_FIND = CallMatcher.instanceCall("java.util.stream.Stream", "findFirst", "findAny").parameterCount(0);
    private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall("java.util.stream.Stream", "filter").parameterTypes("java.util.function.Predicate");
    private static final CallMatcher STREAM_MAP = CallMatcher.instanceCall("java.util.stream.Stream", "map").parameterTypes("java.util.function.Function");
    private static final CallMatcher STREAM_ANY_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "anyMatch").parameterCount(1);
    private static final CallMatcher STREAM_NONE_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "noneMatch").parameterCount(1);
    private static final CallMatcher STREAM_ALL_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "allMatch").parameterCount(1);
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.instanceCall("java.util.Optional", "isPresent").parameterCount(0);
    private static final CallMatcher STREAM_MATCH = CallMatcher.anyOf(STREAM_ANY_MATCH, STREAM_NONE_MATCH, STREAM_ALL_MATCH);
    private static final CallMapper<CallChainSimplification> CALL_TO_FIX_MAPPER = new CallMapper(ReplaceCollectionStreamFix.handler(), ReplaceWithToArrayFix.handler(), ReplaceStreamSupportWithCollectionStreamFix.handler(), ReplaceWithBoxedFix.handler(), ReplaceWithElementIterationFix.handler(), ReplaceForEachMethodFix.handler(), RemoveBooleanIdentityFix.handler()).registerAll(SimplifyMatchNegationFix.handlers());
    private static final Logger LOG = Logger.getInstance((String)("#" + SimplifyStreamApiCallChainsInspection.class.getName()));
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String OF_METHOD = "of";
    private static final String ANY_MATCH_METHOD = "anyMatch";
    private static final String NONE_MATCH_METHOD = "noneMatch";
    private static final String ALL_MATCH_METHOD = "allMatch";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                CALL_TO_FIX_MAPPER.mapAll(methodCall).forEach(simplification -> {
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$1", "lambda$visitMethodCallExpression$0"));
                    }
                    holder.registerProblem(nameElement, simplification.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix((CallChainFix)simplification)});
                });
                if (STREAM_COLLECT.test(methodCall)) {
                    this.handleStreamCollect(methodCall);
                } else if (OPTIONAL_IS_PRESENT.test(methodCall)) {
                    this.handleOptionalIsPresent(methodCall);
                }
            }

            private void handleOptionalIsPresent(PsiMethodCallExpression methodCall) {
                PsiMethodCallExpression optionalQualifier = MethodCallUtils.getQualifierMethodCall(methodCall);
                if (!STREAM_FIND.test(optionalQualifier)) {
                    return;
                }
                PsiMethodCallExpression streamQualifier = MethodCallUtils.getQualifierMethodCall(optionalQualifier);
                if (!STREAM_FILTER.test(streamQualifier)) {
                    return;
                }
                ReplaceOptionalIsPresentChainFix fix = new ReplaceOptionalIsPresentChainFix(optionalQualifier.getMethodExpression().getReferenceName());
                holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, streamQualifier), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
            }

            private void handleStreamCollect(PsiMethodCallExpression methodCall) {
                PsiExpression parameter = methodCall.getArgumentList().getExpressions()[0];
                if (parameter instanceof PsiMethodCallExpression) {
                    String replacement;
                    PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                    ReplaceCollectorFix fix = ReplaceCollectorFix.COLLECTOR_TO_FIX_MAPPER.mapFirst(collectorCall);
                    if (fix != null) {
                        TextRange range = methodCall.getTextRange();
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        if (nameElement != null) {
                            range = new TextRange(nameElement.getTextOffset(), range.getEndOffset());
                        }
                        holder.registerProblem((PsiElement)methodCall, range.shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
                    } else if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)methodCall.getType()) instanceof PsiTypeParameter) && (replacement = SimplifyCollectionCreationFix.COLLECTOR_TO_CLASS_MAPPER.mapFirst(collectorCall)) != null) {
                        PsiElement startElement;
                        PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(methodCall);
                        if (COLLECTION_STREAM.test(qualifier) && (startElement = qualifier.getMethodExpression().getReferenceNameElement()) != null) {
                            holder.registerProblem((PsiElement)methodCall, new TextRange(startElement.getTextOffset() - methodCall.getTextOffset(), methodCall.getTextLength()), "Can be replaced with '" + replacement + "' constructor", new LocalQuickFix[]{new SimplifyCallChainFix(new SimplifyCollectionCreationFix(replacement))});
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public static PsiElement simplifyStreamExpressions(PsiElement element) {
        boolean replaced = true;
        while (replaced) {
            replaced = false;
            Map callToSimplification = StreamEx.ofTree((Object)element, e -> StreamEx.of((Object[])e.getChildren())).select(PsiMethodCallExpression.class).mapToEntry(CALL_TO_FIX_MAPPER::mapFirst).nonNullValues().toMap();
            for (Map.Entry entry : callToSimplification.entrySet()) {
                PsiElement replacement;
                if (!((PsiMethodCallExpression)entry.getKey()).isValid() || (replacement = ((CallChainSimplification)entry.getValue()).simplify((PsiMethodCallExpression)entry.getKey())) == null) continue;
                replaced = true;
                if (element != entry.getKey()) continue;
                element = replacement;
            }
        }
        return element;
    }

    static CallMatcher collectorMatcher(String name, int parameterCount) {
        return CallMatcher.staticCall("java.util.stream.Collectors", name).parameterCount(parameterCount);
    }

    static boolean isParentNegated(PsiMethodCallExpression methodCall) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    static boolean isArgumentLambdaNegated(PsiMethodCallExpression methodCall) {
        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return false;
        }
        PsiExpression arg = expressions[0];
        if (!(arg instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiElement body = ((PsiLambdaExpression)arg).getBody();
        return body instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)body);
    }

    @NotNull
    protected static TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    private static class ReplaceStreamSupportWithCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_SUPPORT = CallMatcher.staticCall("java.util.stream.StreamSupport", "stream").parameterTypes("java.util.Spliterator", "boolean");
        private static final CallMatcher SPLITERATOR = CallMatcher.instanceCall("java.util.Collection", "spliterator").parameterCount(0);
        private boolean myParallel;

        public ReplaceStreamSupportWithCollectionStreamFix(boolean parallel) {
            this.myParallel = parallel;
        }

        @Override
        public String getName() {
            return "Replace with 'collection." + this.getMethodName() + "' call";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with 'collection." + this.getMethodName() + "' call";
        }

        @NotNull
        private String getMethodName() {
            String string = this.myParallel ? "parallelStream" : SimplifyStreamApiCallChainsInspection.STREAM_METHOD;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamSupportWithCollectionStreamFix", "getMethodName"));
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return null;
            }
            PsiMethodCallExpression spliteratorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
            if (spliteratorCall == null) {
                return null;
            }
            spliteratorCall.getMethodExpression().handleElementRename(this.getMethodName());
            CommentTracker ct = new CommentTracker();
            return ct.replace((PsiElement)call, (PsiElement)spliteratorCall);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_SUPPORT, call -> {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression parallel = args[1];
                if (!ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.TRUE) && !ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.FALSE)) {
                    return null;
                }
                PsiMethodCallExpression spliterator = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
                if (!SPLITERATOR.test(spliterator)) {
                    return null;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return null;
                }
                return new ReplaceStreamSupportWithCollectionStreamFix(ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.TRUE));
            });
        }
    }

    private static class RemoveBooleanIdentityFix
    implements CallChainSimplification {
        private RemoveBooleanIdentityFix() {
        }

        @Override
        public String getName() {
            return "Merge with previous 'map' call";
        }

        @Override
        public String getMessage() {
            return "Can be merged with previous 'map' call";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(call);
            if (qualifier == null) {
                return null;
            }
            String name = call.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            PsiExpression[] args = qualifier.getArgumentList().getExpressions();
            CommentTracker ct = new CommentTracker();
            if (args.length == 1) {
                PsiExpression arg = args[0];
                String replacement = RemoveBooleanIdentityFix.adaptToPredicate(ct.markUnchanged(arg));
                if (replacement == null) {
                    return null;
                }
                ct.replace((PsiElement)arg, replacement);
            }
            qualifier.getMethodExpression().handleElementRename(name);
            return ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)ct.markUnchanged(qualifier));
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_MATCH, call -> {
                PsiExpression predicate = call.getArgumentList().getExpressions()[0];
                if (!RemoveBooleanIdentityFix.isBooleanIdentity(predicate)) {
                    return null;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!STREAM_MAP.test(qualifierCall)) {
                    return null;
                }
                PsiExpression qualifierArg = qualifierCall.getArgumentList().getExpressions()[0];
                if (RemoveBooleanIdentityFix.adaptToPredicate(qualifierArg) == null) {
                    return null;
                }
                return new RemoveBooleanIdentityFix();
            });
        }

        private static boolean isBooleanIdentity(PsiExpression arg) {
            if (FunctionalExpressionUtils.isFunctionalReferenceTo(arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), "java.lang.Boolean", (PsiType)PsiType.BOOLEAN, "booleanValue", PsiType.EMPTY_ARRAY) || FunctionalExpressionUtils.isFunctionalReferenceTo(arg, "java.lang.Boolean", null, "valueOf", new PsiType[]{PsiType.BOOLEAN})) {
                return true;
            }
            return arg instanceof PsiLambdaExpression && LambdaUtil.isIdentityLambda((PsiLambdaExpression)((PsiLambdaExpression)arg));
        }

        @Nullable
        private static String adaptToPredicate(PsiExpression expression) {
            if (expression == null) {
                return null;
            }
            String text = expression.getText();
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
                return null;
            }
            if (expression instanceof PsiFunctionalExpression) {
                return text;
            }
            if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)expression;
                String thenBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getThenExpression());
                String elseBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getElseExpression());
                if (thenBranch == null || elseBranch == null) {
                    return null;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
                PsiConditionalExpression copy = (PsiConditionalExpression)factory.createExpressionFromText(text, (PsiElement)expression);
                Objects.requireNonNull(copy.getThenExpression()).replace((PsiElement)factory.createExpressionFromText(thenBranch, (PsiElement)expression));
                Objects.requireNonNull(copy.getElseExpression()).replace((PsiElement)factory.createExpressionFromText(elseBranch, (PsiElement)expression));
                return copy.getText();
            }
            String adapted = ParenthesesUtils.getText(expression, 2) + "::apply";
            PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)expression.getType(), PsiClassType.class);
            if (type == null) {
                return null;
            }
            if (type.rawType().equalsToText("java.util.function.Function")) {
                return adapted;
            }
            PsiClass typeClass = type.resolve();
            if (typeClass == null) {
                return null;
            }
            PsiMethod[] methods = typeClass.findMethodsByName("apply", true);
            if (methods.length != 1 || methods[0].getContainingClass() == null || !"java.util.function.Function".equals(methods[0].getContainingClass().getQualifiedName())) {
                return null;
            }
            return adapted;
        }
    }

    private static class ReplaceWithElementIterationFix
    implements CallChainSimplification {
        private static final CallMatcher INT_STREAM_MAP = CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToLong", "mapToDouble", "mapToObj").parameterCount(1);
        private static final CallMatcher INT_STREAM_RANGE = CallMatcher.staticCall("java.util.stream.IntStream", "range").parameterTypes("int", "int");
        private final String myName;

        public ReplaceWithElementIterationFix(IndexedContainer container, String name) {
            PsiType type = container.getQualifier().getType();
            String replacement = type instanceof PsiArrayType ? "Arrays.stream()" : "collection.stream()";
            this.myName = "Replace IntStream.range()." + name + "() with " + replacement;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public String getMessage() {
            return "Can be replaced with element iteration";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression mapToObjCall) {
            String name;
            Project project2 = mapToObjCall.getProject();
            PsiExpression mapper = (PsiExpression)ArrayUtil.getFirstElement((Object[])mapToObjCall.getArgumentList().getExpressions());
            IndexedContainer container = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall(mapToObjCall), mapper);
            if (container == null) {
                return null;
            }
            PsiExpression containerQualifier = container.getQualifier();
            PsiType type = containerQualifier.getType();
            PsiType elementType = container.getElementType();
            PsiType outElementType = StreamApiUtil.getStreamElementType(mapToObjCall.getType());
            if (type == null || elementType == null) {
                return null;
            }
            String replacement = type instanceof PsiArrayType ? "java.util.Arrays.stream(" + containerQualifier.getText() + ")" : ParenthesesUtils.getText(containerQualifier, 2) + ".stream()";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            CommentTracker ct = new CommentTracker();
            if (mapper instanceof PsiMethodReferenceExpression) {
                mapper = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)mapper, false, true);
            }
            if (!(mapper instanceof PsiLambdaExpression)) {
                return null;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)mapper;
            PsiParameter indexParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
            PsiElement body = lambda2.getBody();
            if (body == null || indexParameter == null) {
                return null;
            }
            String nameCandidate = null;
            if (containerQualifier instanceof PsiReferenceExpression && (name = ((PsiReferenceExpression)containerQualifier).getReferenceName()) != null && name.equals(nameCandidate = StringUtil.unpluralize((String)name))) {
                nameCandidate = null;
            }
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, nameCandidate, null, elementType, true);
            nameCandidate = (String)ArrayUtil.getFirstElement((Object[])info.names);
            String name2 = javaCodeStyleManager.suggestUniqueVariableName(nameCandidate == null ? "item" : nameCandidate, (PsiElement)mapToObjCall, true);
            Collection refs = ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body)).findAll();
            for (PsiReference ref : refs) {
                PsiExpression getExpression = container.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref, PsiExpression.class));
                if (getExpression == null) continue;
                PsiElement result2 = ct.replace((PsiElement)getExpression, (PsiElement)factory.createIdentifier(name2));
                if (getExpression != body) continue;
                body = result2;
            }
            PsiLambdaExpression newLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + elementType.getCanonicalText() + " " + name2 + ")->" + ct.text(body), (PsiElement)mapToObjCall);
            PsiParameter newParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])newLambda.getParameterList().getParameters());
            replacement = replacement + StreamApiUtil.generateMapOperation((PsiVariable)newParameter, outElementType, newLambda.getBody());
            PsiElement result3 = ct.replaceAndRestoreComments((PsiElement)mapToObjCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result3);
            result3 = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result3);
            return CodeStyleManager.getInstance((Project)project2).reformat(result3);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(INT_STREAM_MAP, call -> {
                PsiExpression mapper = call.getArgumentList().getExpressions()[0];
                IndexedContainer container = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall(call), mapper);
                if (container == null) {
                    return null;
                }
                return new ReplaceWithElementIterationFix(container, call.getMethodExpression().getReferenceName());
            });
        }

        @Contract(value="null, _ -> null")
        private static IndexedContainer extractContainer(PsiMethodCallExpression qualifierCall, PsiExpression mapper) {
            if (!INT_STREAM_RANGE.test(qualifierCall)) {
                return null;
            }
            PsiExpression[] rangeArgs = qualifierCall.getArgumentList().getExpressions();
            if (!ExpressionUtils.isZero(rangeArgs[0])) {
                return null;
            }
            PsiExpression bound = rangeArgs[1];
            IndexedContainer container = IndexedContainer.fromLengthExpression(bound);
            if (container == null || !StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                return null;
            }
            if (mapper instanceof PsiMethodReferenceExpression && container.isGetMethodReference((PsiMethodReferenceExpression)mapper)) {
                return container;
            }
            if (mapper instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)mapper;
                PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiParameter indexParameter = parameters[0];
                PsiElement body = lambda2.getBody();
                if (body == null) {
                    return null;
                }
                Collection refs = ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body)).findAll();
                if (!refs.isEmpty() && refs.stream().allMatch(ref -> container.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref, PsiExpression.class)) != null)) {
                    return container;
                }
            }
            return null;
        }
    }

    private static class ReplaceWithToArrayFix
    implements CallChainSimplification {
        private static final CallMatcher TO_ARRAY = CallMatcher.instanceCall("java.util.stream.Stream", "toArray");
        private final String myReplacement;

        private ReplaceWithToArrayFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace 'collection.stream().toArray()' with 'collection.toArray()'";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with collection.toArray()";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression toArrayCall) {
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall(toArrayCall);
            if (streamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            return ct.replaceAndRestoreComments((PsiElement)toArrayCall, ct.text((PsiElement)collectionExpression) + ".toArray(" + this.myReplacement + ")");
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(TO_ARRAY, methodCall -> {
                if (!COLLECTION_STREAM.test(MethodCallUtils.getQualifierMethodCall(methodCall))) {
                    return null;
                }
                PsiArrayType type = ReplaceWithToArrayFix.getArrayType(methodCall);
                if (type == null) {
                    return null;
                }
                String replacement = type.equalsToText("java.lang.Object[]") ? "" : "new " + type.getCanonicalText().replaceFirst("\\[]", "[0]");
                return new ReplaceWithToArrayFix(replacement);
            });
        }

        @Nullable
        private static PsiArrayType getArrayType(PsiMethodCallExpression call) {
            PsiType type = call.getType();
            if (!(type instanceof PsiArrayType)) {
                return null;
            }
            PsiArrayType candidate = (PsiArrayType)type;
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0) {
                return candidate;
            }
            if (args.length != 1) {
                return null;
            }
            PsiExpression supplier = args[0];
            if (supplier instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)supplier;
                PsiTypeElement qualifierType = methodRef.getQualifierType();
                if (methodRef.isConstructor() && qualifierType != null && candidate.isAssignableFrom(qualifierType.getType())) {
                    return candidate;
                }
            } else if (supplier instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)supplier;
                PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiParameter sizeParameter = parameters[0];
                PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                if (body instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)body;
                    PsiExpression[] dimensions = newExpression.getArrayDimensions();
                    PsiType newExpressionType = newExpression.getType();
                    if (dimensions.length != 0 && ExpressionUtils.isReferenceTo(dimensions[0], (PsiVariable)sizeParameter) && newExpressionType != null && candidate.isAssignableFrom(newExpressionType)) {
                        return candidate;
                    }
                }
            }
            return null;
        }
    }

    private static class ReplaceWithBoxedFix
    implements CallChainSimplification {
        private static final CallMatcher MAP_TO_OBJ = CallMatcher.instanceCall("java.util.stream.BaseStream", "mapToObj").parameterCount(1);

        private ReplaceWithBoxedFix() {
        }

        @Override
        public String getName() {
            return "Replace with 'boxed'";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with 'boxed'";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            call.getMethodExpression().handleElementRename("boxed");
            args[0].delete();
            call.getTypeArgumentList().delete();
            return call;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(MAP_TO_OBJ, call -> {
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                PsiType type = StreamApiUtil.getStreamElementType(call.getType());
                PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (targetClass == null) {
                    return null;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null || !TypeConversionUtil.boxingConversionApplicable((PsiType)StreamApiUtil.getStreamElementType(qualifier.getType()), (PsiType)type) || !ReplaceWithBoxedFix.isBoxingFunction(arg, targetClass)) {
                    return null;
                }
                return new ReplaceWithBoxedFix();
            });
        }

        @Contract(value="null, _ -> false")
        private static boolean isBoxingFunction(PsiExpression arg, PsiClass targetClass) {
            PsiMethod method2;
            PsiElement target;
            if (arg instanceof PsiMethodReferenceExpression && (target = ((PsiMethodReferenceExpression)arg).resolve()) instanceof PsiMethod && targetClass == (method2 = (PsiMethod)target).getContainingClass() && (method2.isConstructor() || method2.getName().equals("valueOf")) && method2.getParameterList().getParametersCount() == 1) {
                return true;
            }
            if (arg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg;
                PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return false;
                }
                PsiParameter parameter = parameters[0];
                PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
                if (ExpressionUtils.isReferenceTo(expression, (PsiVariable)parameter)) {
                    return true;
                }
                if (expression instanceof PsiCallExpression) {
                    PsiMethod method3;
                    PsiJavaCodeReferenceElement ref;
                    PsiExpressionList list = ((PsiCallExpression)expression).getArgumentList();
                    if (list == null) {
                        return false;
                    }
                    PsiExpression[] args = list.getExpressions();
                    if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter)) {
                        return false;
                    }
                    if (expression instanceof PsiNewExpression && (ref = ((PsiNewExpression)expression).getClassReference()) != null && ref.isReferenceTo((PsiElement)targetClass)) {
                        return true;
                    }
                    if (expression instanceof PsiMethodCallExpression && (method3 = ((PsiMethodCallExpression)expression).resolveMethod()) != null && method3.getContainingClass() == targetClass && method3.getName().equals("valueOf")) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class SimplifyCollectionCreationFix
    implements CallChainFix {
        static final CallMapper<String> COLLECTOR_TO_CLASS_MAPPER = new CallMapper<String>().register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toList", 0), "java.util.ArrayList").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toSet", 0), "java.util.HashSet").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toCollection", 1), (String)((Object)((Function<PsiMethodCallExpression, String>)SimplifyCollectionCreationFix::getCollectionClass)));
        private String myReplacement;

        public SimplifyCollectionCreationFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with '" + this.myReplacement + "' constructor";
        }

        @Override
        public void applyFix(@NotNull Project project2, PsiElement element) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCollectionCreationFix", "applyFix"));
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression collectCall = (PsiMethodCallExpression)element;
            PsiType type = collectCall.getType();
            PsiClass resolvedType = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (resolvedType == null || resolvedType instanceof PsiTypeParameter) {
                return;
            }
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall(collectCall);
            if (streamCall == null) {
                return;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            String typeText = type.getCanonicalText();
            if ("java.util.List".equals(resolvedType.getQualifiedName()) || "java.util.Set".equals(resolvedType.getQualifiedName())) {
                PsiType[] parameters = ((PsiClassType)type).getParameters();
                if (parameters.length != 1) {
                    return;
                }
                typeText = this.myReplacement + "<" + parameters[0].getCanonicalText() + ">";
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression result2 = factory.createExpressionFromText("new " + typeText + "(" + collectionExpression.getText() + ")", element);
            PsiNewExpression newExpression = (PsiNewExpression)element.replace((PsiElement)result2);
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            LOG.assertTrue(classReference != null);
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)classReference);
            if (PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)classReference.getParameterList());
            }
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)newExpression);
        }

        @Nullable
        private static String getCollectionClass(PsiMethodCallExpression call) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiMethodReferenceExpression.class);
            if (methodRef == null || !methodRef.isConstructor()) {
                return null;
            }
            PsiMethod ctor = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (ctor == null || ctor.getParameterList().getParametersCount() != 0) {
                return null;
            }
            PsiClass aClass = ctor.getContainingClass();
            if (aClass == null) {
                return null;
            }
            String name = aClass.getQualifiedName();
            if (name != null && name.startsWith("java.util.") && Stream.of(aClass.getConstructors()).anyMatch(SimplifyCollectionCreationFix::isCollectionConstructor)) {
                return name;
            }
            return null;
        }

        @Contract(value="null -> false")
        private static boolean isCollectionConstructor(PsiMethod ctor) {
            if (ctor == null || !ctor.getModifierList().hasExplicitModifier("public")) {
                return false;
            }
            PsiParameterList list = ctor.getParameterList();
            if (list.getParametersCount() != 1) {
                return false;
            }
            PsiTypeElement typeElement = list.getParameters()[0].getTypeElement();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            return aClass != null && "java.util.Collection".equals(aClass.getQualifiedName());
        }
    }

    private static class SimplifyMatchNegationFix
    implements CallChainSimplification {
        private final String myFrom;
        private final String myTo;

        private SimplifyMatchNegationFix(PsiMethodCallExpression call, boolean argNegated, boolean parentNegated, String to) {
            String name = call.getMethodExpression().getReferenceName();
            String arg = argNegated ? "x -> !(...)" : "...";
            String className = Objects.requireNonNull(Objects.requireNonNull(call.resolveMethod()).getContainingClass()).getName();
            this.myFrom = (parentNegated ? "!" : "") + className + "." + name + "(" + arg + ")";
            this.myTo = to;
        }

        @Override
        public String getName() {
            return "Replace " + this.myFrom + " with " + this.myTo + "(...)";
        }

        @Override
        public String getMessage() {
            return this.myFrom + " can be replaced with " + this.myTo + "(...)";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression methodCall) {
            boolean removeParentNegation;
            boolean removeLambdaNegation;
            String from = methodCall.getMethodExpression().getReferenceName();
            if (from == null) {
                return null;
            }
            switch (from) {
                case "allMatch": {
                    removeLambdaNegation = true;
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    break;
                }
                case "anyMatch": {
                    removeParentNegation = true;
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                case "noneMatch": {
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (removeParentNegation && !SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) {
                return null;
            }
            if (removeLambdaNegation && !SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) {
                return null;
            }
            methodCall.getMethodExpression().handleElementRename(this.myTo);
            if (removeLambdaNegation) {
                PsiExpression body = (PsiExpression)((PsiLambdaExpression)methodCall.getArgumentList().getExpressions()[0]).getBody();
                PsiExpression negated = BoolUtils.getNegated(body);
                LOG.assertTrue(negated != null);
                body.replace((PsiElement)negated);
            }
            if (removeParentNegation) {
                return PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent()).replace((PsiElement)methodCall);
            }
            return methodCall;
        }

        static List<CallHandler<CallChainSimplification>> handlers() {
            return Arrays.asList(CallHandler.of(STREAM_ANY_MATCH, methodCall -> {
                boolean argNegated;
                if (!SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, argNegated, true, (argNegated = SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }), CallHandler.of(STREAM_NONE_MATCH, methodCall -> SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, false, true, SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD) : null), CallHandler.of(STREAM_NONE_MATCH, methodCall -> SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, false, SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD) : null), CallHandler.of(STREAM_ALL_MATCH, methodCall -> {
                boolean parentNegated;
                if (!SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, parentNegated, (parentNegated = SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }));
        }
    }

    private static class ReplaceOptionalIsPresentChainFix
    implements CallChainFix {
        private final String myFindMethodName;

        ReplaceOptionalIsPresentChainFix(String findMethodName) {
            this.myFindMethodName = findMethodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Stream.filter()." + this.myFindMethodName + "().isPresent() with Stream.anyMatch()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project2, PsiElement element) {
            PsiMethodCallExpression findCall;
            PsiExpression findQualifier;
            PsiMethodCallExpression isPresentCall;
            PsiExpression isPresentQualifier;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "applyFix"));
            }
            if (element instanceof PsiMethodCallExpression && (isPresentQualifier = (isPresentCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && (findQualifier = (findCall = (PsiMethodCallExpression)isPresentQualifier).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression filterCall = (PsiMethodCallExpression)findQualifier;
                PsiElement replacement = element.replace((PsiElement)filterCall);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiElement filterName = ((PsiMethodCallExpression)replacement).getMethodExpression().getReferenceNameElement();
                LOG.assertTrue(filterName != null);
                filterName.replace((PsiElement)factory.createIdentifier(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD));
            }
        }

        @NotNull
        public String getMessage() {
            String string = "Stream.filter()." + this.myFindMethodName + "().isPresent() can be replaced with Stream.anyMatch()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "getMessage"));
            }
            return string;
        }
    }

    private static class ReplaceCollectorFix
    implements CallChainFix {
        static final CallMapper<ReplaceCollectorFix> COLLECTOR_TO_FIX_MAPPER = new CallMapper(ReplaceCollectorFix.handler("counting", 0, "count()", false), ReplaceCollectorFix.handler("minBy", 1, "min({0})", true), ReplaceCollectorFix.handler("maxBy", 1, "max({0})", true), ReplaceCollectorFix.handler("mapping", 2, "map({0}).collect({1})", false), ReplaceCollectorFix.handler("reducing", 1, "reduce({0})", true), ReplaceCollectorFix.handler("reducing", 2, "reduce({0}, {1})", false), ReplaceCollectorFix.handler("reducing", 3, "map({1}).reduce({0}, {2})", false), ReplaceCollectorFix.handler("summingInt", 1, "mapToInt({0}).sum()", false), ReplaceCollectorFix.handler("summingLong", 1, "mapToLong({0}).sum()", false), ReplaceCollectorFix.handler("summingDouble", 1, "mapToInt({0}).sum()", false));
        private final String myCollector;
        private final String myStreamSequence;
        private final String myStreamSequenceStripped;
        private final boolean myChangeSemantics;

        public ReplaceCollectorFix(String collector, String streamSequence, boolean changeSemantics) {
            this.myCollector = collector;
            this.myStreamSequence = streamSequence;
            this.myStreamSequenceStripped = streamSequence.replaceAll("\\([^)]+\\)", "()");
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Stream.collect(" + this.myCollector + "()) with Stream." + this.myStreamSequenceStripped + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project2, PsiElement element) {
            PsiExpression parameter;
            PsiMethodCallExpression collectCall;
            PsiExpression qualifierExpression;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "applyFix"));
            }
            if (element instanceof PsiMethodCallExpression && (qualifierExpression = (collectCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) != null && (parameter = collectCall.getArgumentList().getExpressions()[0]) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
                String result2 = MessageFormat.format(this.myStreamSequence, Arrays.stream(collectorArgs).map(PsiElement::getText).toArray());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiExpression replacement = factory.createExpressionFromText(qualifierExpression.getText() + "." + result2, (PsiElement)collectCall);
                ReplaceCollectorFix.addBoxingIfNecessary(factory, collectCall.replace((PsiElement)replacement));
            }
        }

        private static void addBoxingIfNecessary(PsiElementFactory factory, PsiElement expression) {
            PsiExpression castExpression;
            PsiElement cast;
            PsiClassType boxedType;
            PsiType type;
            if (expression instanceof PsiExpression && (type = ((PsiExpression)expression).getType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)type).getBoxedType(expression)) != null && (cast = expression.replace((PsiElement)(castExpression = factory.createExpressionFromText("(" + boxedType.getCanonicalText() + ") " + expression.getText(), expression)))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)cast))) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)cast));
            }
        }

        @NotNull
        public String getMessage() {
            String string = "Stream.collect(" + this.myCollector + "()) can be replaced with Stream." + this.myStreamSequenceStripped + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getMessage"));
            }
            return string;
        }

        static CallHandler<ReplaceCollectorFix> handler(String collectorName, int parameterCount, String template, boolean changeSemantics) {
            return CallHandler.of(SimplifyStreamApiCallChainsInspection.collectorMatcher(collectorName, parameterCount), call -> new ReplaceCollectorFix(collectorName, template, changeSemantics));
        }
    }

    static class ReplaceForEachMethodFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_FOR_EACH = CallMatcher.instanceCall("java.util.stream.Stream", "forEach", "forEachOrdered").parameterCount(1);
        private final String myStreamMethod;
        private final String myCollectionMethod;
        private final boolean myChangeSemantics;

        public ReplaceForEachMethodFix(String streamMethod, String collectionMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myCollectionMethod = collectionMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Collection.stream()." + this.myStreamMethod + "() with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceForEachMethodFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = "Collection.stream()." + this.myStreamMethod + "() can be replaced with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceForEachMethodFix", "getMessage"));
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamMethodCall) {
            PsiMethodCallExpression collectionStreamCall = MethodCallUtils.getQualifierMethodCall(streamMethodCall);
            if (collectionStreamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = collectionStreamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return null;
            }
            collectionStreamCall.replace((PsiElement)collectionExpression);
            if (!this.myStreamMethod.equals(this.myCollectionMethod)) {
                streamMethodCall.getMethodExpression().handleElementRename(this.myCollectionMethod);
            }
            return streamMethodCall;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_FOR_EACH, call -> COLLECTION_STREAM.test(MethodCallUtils.getQualifierMethodCall(call)) ? new ReplaceForEachMethodFix(call.getMethodExpression().getReferenceName(), SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true) : null);
        }
    }

    private static class ReplaceSingletonWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix", "getTypeParameter"));
            }
            String typeParameter = super.getTypeParameter(qualifierCall);
            if (typeParameter != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }
    }

    private static class ReplaceCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher EMPTY_LIST = CallMatcher.staticCall("java.util.Collections", "emptyList").parameterCount(0);
        private static final CallMatcher EMPTY_SET = CallMatcher.staticCall("java.util.Collections", "emptySet").parameterCount(0);
        private static final CallMatcher SINGLETON_LIST = CallMatcher.staticCall("java.util.Collections", "singletonList").parameterCount(1);
        private static final CallMatcher SINGLETON = CallMatcher.staticCall("java.util.Collections", "singleton").parameterCount(1);
        private static final CallMatcher AS_LIST = CallMatcher.staticCall("java.util.Arrays", "asList").parameterCount(1);
        private static final CallMapper<ReplaceCollectionStreamFix> COLLECTION_TO_STREAM_MAPPER = new CallMapper<ReplaceCollectionStreamFix>().register(EMPTY_LIST, new ReplaceCollectionStreamFix("Collections.emptyList()", "java.util.stream.Stream", "empty")).register(EMPTY_SET, new ReplaceCollectionStreamFix("Collections.emptySet()", "java.util.stream.Stream", "empty")).register(SINGLETON, (ReplaceCollectionStreamFix)((Object)((Function<PsiMethodCallExpression, ReplaceCollectionStreamFix>)call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singleton()")))).register(SINGLETON_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singletonList()")).register(AS_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD) : new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD));
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = this.myQualifierCall + ".stream() can be replaced with " + ClassUtil.extractClassName((String)this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getMessage"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace " + this.myQualifierCall + ".stream() with " + ClassUtil.extractClassName((String)this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getName"));
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getTypeParameter"));
            }
            PsiType[] parameters = qualifierCall.getMethodExpression().getTypeParameters();
            return parameters.length == 1 ? parameters[0].getCanonicalText() : null;
        }

        @Override
        @Nullable
        public PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression collectionCall = MethodCallUtils.getQualifierMethodCall(streamCall);
            if (collectionCall == null) {
                return null;
            }
            streamCall.getArgumentList().replace((PsiElement)collectionCall.getArgumentList());
            String typeParameter = this.getTypeParameter(collectionCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            Project project2 = streamCall.getProject();
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(replacement, (PsiElement)streamCall);
            return JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(streamCall.getMethodExpression().replace((PsiElement)newMethodExpression));
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(COLLECTION_STREAM, methodCall -> COLLECTION_TO_STREAM_MAPPER.mapFirst(MethodCallUtils.getQualifierMethodCall(methodCall)));
        }

        private static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
            PsiType type;
            PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
            if (argumentExpressions.length == 1 && (type = argumentExpressions[0].getType()) instanceof PsiArrayType) {
                PsiType[] parameters;
                PsiType methodType = qualifierCall.getType();
                return !(methodType instanceof PsiClassType) || (parameters = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable((PsiType)parameters[0], (PsiType)type) || TypeConversionUtil.isAssignable((PsiType)parameters[0], (PsiType)((PsiArrayType)type).getComponentType());
            }
            return false;
        }
    }

    private static class SimplifyCallChainFix
    implements LocalQuickFix {
        private final CallChainFix myFix;

        SimplifyCallChainFix(CallChainFix fix) {
            this.myFix = fix;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify stream call chain" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "getFamilyName"));
            }
            return "Simplify stream call chain";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "applyFix"));
            }
            this.myFix.applyFix(project2, descriptor.getStartElement());
        }
    }

    static interface CallChainSimplification
    extends CallChainFix {
        public String getMessage();

        @Override
        default public void applyFix(@NotNull Project project2, PsiElement element) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainSimplification", "applyFix"));
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
            if (call != null) {
                this.simplify(call);
            }
        }

        public PsiElement simplify(PsiMethodCallExpression var1);
    }

    static interface CallChainFix {
        public String getName();

        public void applyFix(@NotNull Project var1, PsiElement var2);
    }
}

