/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialFunctionalExpressionUsageInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression, (Condition<PsiElement>)((Condition)element -> expression.resolve() != null));
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression, (Condition<PsiElement>)((Condition)ggParent -> {
                    PsiElement callParent = ggParent.getParent();
                    PsiElement body = expression.getBody();
                    if (!(body instanceof PsiCodeBlock)) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || expression.isValueCompatible();
                    }
                    Object[] statements = ((PsiCodeBlock)body).getStatements();
                    if (statements.length == 1) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || statements[0] instanceof PsiReturnStatement && expression.isValueCompatible();
                    }
                    List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)expression);
                    if (returnExpressions.size() > 1 || returnExpressions.size() == 1 && !(ArrayUtil.getLastElement((Object[])statements) instanceof PsiReturnStatement)) {
                        return false;
                    }
                    if (!returnExpressions.isEmpty() && callParent instanceof PsiLocalVariable) {
                        return true;
                    }
                    return callParent instanceof PsiStatement && !(callParent instanceof PsiLoopStatement) || callParent instanceof PsiLambdaExpression;
                }));
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, Collections.emptySet())) {
                    PsiElement newExpression = aClass.getParent();
                    this.doCheckMethodCallOnFunctionalExpression((Condition<PsiElement>)((Condition)ggParent -> {
                        PsiMethod method2 = aClass.getMethods()[0];
                        PsiCodeBlock body = method2.getBody();
                        PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiCodeBlock)body);
                        if (returnStatements.length > 1) {
                            return false;
                        }
                        PsiElement callParent = ggParent.getParent();
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable;
                    }), newExpression, (PsiType)aClass.getBaseClassType(), new ReplaceAnonymousWithLambdaBodyFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(PsiElement expression, Condition<PsiElement> elementContainerCondition) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
                if (parent instanceof PsiTypeCastExpression) {
                    PsiType interfaceType = ((PsiTypeCastExpression)parent).getType();
                    this.doCheckMethodCallOnFunctionalExpression(elementContainerCondition, parent, interfaceType, expression instanceof PsiLambdaExpression ? new ReplaceWithLambdaBodyFix() : new ReplaceWithMethodReferenceFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(Condition<PsiElement> elementContainerCondition, PsiElement parent, PsiType interfaceType, LocalQuickFix fix) {
                PsiElement ggParent;
                PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
                if (gParent instanceof PsiReferenceExpression && (ggParent = gParent.getParent()) instanceof PsiMethodCallExpression) {
                    PsiMethod interfaceMethod;
                    PsiMethod resolveMethod = ((PsiMethodCallExpression)ggParent).resolveMethod();
                    PsiElement referenceNameElement = ((PsiMethodCallExpression)ggParent).getMethodExpression().getReferenceNameElement();
                    if (resolveMethod != null && !resolveMethod.isVarArgs() && ((PsiMethodCallExpression)ggParent).getArgumentList().getExpressions().length == resolveMethod.getParameterList().getParametersCount() && referenceNameElement != null && elementContainerCondition.value((Object)ggParent) && (resolveMethod == (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)interfaceType)) || interfaceMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)resolveMethod))) {
                        holder.registerProblem(referenceNameElement, "Method call can be simplified", new LocalQuickFix[]{fix});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void replaceWithLambdaBody(PsiMethodCallExpression callExpression, PsiLambdaExpression element) {
        PsiElement body = element.getBody();
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
        if (expression != null) {
            CommentTracker ct = new CommentTracker();
            TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
            ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(expression));
        } else if (body instanceof PsiCodeBlock) {
            if ((element = RefactoringUtil.ensureCodeBlock(element)) == null) {
                return;
            }
            body = element.getBody();
            if (!(body instanceof PsiCodeBlock)) {
                return;
            }
            callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (callExpression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
            PsiElement parent = callExpression.getParent();
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length > 0) {
                PsiExpression returnValue;
                PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class, (boolean)false);
                PsiReturnStatement statement2 = (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[statements.length - 1], PsiReturnStatement.class);
                if (anchor != null) {
                    PsiElement gParent = anchor.getParent();
                    for (PsiElement child : body.getChildren()) {
                        if (child == statement2 || child instanceof PsiJavaToken) continue;
                        gParent.addBefore(ct.markUnchanged(child), (PsiElement)anchor);
                    }
                }
                PsiExpression psiExpression = returnValue = statement2 == null ? null : statement2.getReturnValue();
                if (returnValue != null) {
                    ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(returnValue));
                } else {
                    ct.deleteAndRestoreComments((PsiElement)callExpression);
                }
            }
        }
    }

    private static void inlineCallArguments(PsiMethodCallExpression callExpression, PsiLambdaExpression element, CommentTracker ct) {
        PsiExpression[] args = callExpression.getArgumentList().getExpressions();
        PsiParameter[] parameters = element.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter parameter = parameters[i2];
            PsiExpression initializer = args[i2];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                ct.markUnchanged(initializer);
                InlineUtil.inlineVariable((PsiVariable)parameter, initializer, (PsiJavaCodeReferenceElement)referenceElement);
            }
        }
    }

    private static abstract class ReplaceFix
    implements LocalQuickFix {
        private ReplaceFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethodCallExpression.class);
            if (callExpression != null) {
                this.fixExpression(callExpression, PsiUtil.skipParenthesizedExprDown((PsiExpression)callExpression.getMethodExpression().getQualifierExpression()));
            }
        }

        protected abstract void fixExpression(PsiMethodCallExpression var1, PsiExpression var2);
    }

    private static class ReplaceAnonymousWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceAnonymousWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace call with method body" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceAnonymousWithLambdaBodyFix", "getFamilyName"));
            }
            return "Replace call with method body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression) {
            PsiExpression lambdaExpression;
            PsiExpression cast = AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)qualifierExpression, true, false);
            if (cast instanceof PsiTypeCastExpression && (lambdaExpression = ((PsiTypeCastExpression)cast).getOperand()) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, (PsiLambdaExpression)lambdaExpression);
            }
        }
    }

    private static class ReplaceWithMethodReferenceFix
    extends ReplaceFix {
        private ReplaceWithMethodReferenceFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace method call on method reference with corresponding method call" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceWithMethodReferenceFix", "getFamilyName"));
            }
            return "Replace method call on method reference with corresponding method call";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression) {
            PsiLambdaExpression lambdaExpression;
            PsiExpression element;
            if (qualifierExpression instanceof PsiTypeCastExpression && (element = ((PsiTypeCastExpression)qualifierExpression).getOperand()) instanceof PsiMethodReferenceExpression && (lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)element, false, true)) != null) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, lambdaExpression);
            }
        }
    }

    private static class ReplaceWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace method call on lambda with lambda body" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceWithLambdaBodyFix", "getFamilyName"));
            }
            return "Replace method call on lambda with lambda body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression) {
            PsiExpression element;
            if (qualifierExpression instanceof PsiTypeCastExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiTypeCastExpression)qualifierExpression).getOperand())) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, (PsiLambdaExpression)element);
            }
        }
    }
}

