/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class OriginsAnalysis {
    private static final SourceInterpreter ourInterpreter = new SourceInterpreter(){

        public SourceValue copyOperation(AbstractInsnNode insn, SourceValue value) {
            return value;
        }
    };

    @NotNull
    public static boolean[] resultOrigins(Frame<Value>[] frames, InsnList instructions, ControlFlowGraph graph) throws AnalyzerException {
        TIntArrayList[] backTransitions = new TIntArrayList[instructions.size()];
        for (int i2 = 0; i2 < backTransitions.length; ++i2) {
            backTransitions[i2] = new TIntArrayList();
        }
        LinkedList<InsnLocation> queue = new LinkedList<InsnLocation>();
        HashSet<InsnLocation> queued = new HashSet<InsnLocation>();
        for (int from = 0; from < instructions.size(); ++from) {
            for (int to : graph.transitions[from]) {
                InsnLocation sourceLoc;
                TIntArrayList froms = backTransitions[to];
                froms.add(from);
                int opcode = instructions.get(to).getOpcode();
                if (opcode < 172 || opcode > 176 || !queued.add(sourceLoc = new InsnLocation(false, from, frames[to].getStackSize() - 1))) continue;
                queue.push(sourceLoc);
            }
        }
        boolean[] result2 = new boolean[instructions.size()];
        while (!queue.isEmpty()) {
            InsnLocation resultLocation = (InsnLocation)queue.pop();
            int insnIndex = resultLocation.insnIndex;
            AbstractInsnNode insn = instructions.get(insnIndex);
            int opcode = insn.getOpcode();
            Location preLocation = OriginsAnalysis.previousLocation(frames[insnIndex], resultLocation, insn);
            if (preLocation == null) {
                if (opcode == 185 || opcode == 180 || opcode >= 46 && opcode <= 53) continue;
                result2[insnIndex] = true;
                continue;
            }
            TIntArrayList froms = backTransitions[insnIndex];
            for (int i3 = 0; i3 < froms.size(); ++i3) {
                InsnLocation preILoc = new InsnLocation(preLocation.local, froms.getQuick(i3), preLocation.slot);
                if (!queued.add(preILoc)) continue;
                queue.push(preILoc);
            }
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/asm/OriginsAnalysis", "resultOrigins"));
        }
        return result2;
    }

    @Nullable
    private static Location previousLocation(Frame<Value> frame, Location location, AbstractInsnNode insn) throws AnalyzerException {
        int insnType = insn.getType();
        if (insnType == 8 || insnType == 15 || insnType == 14) {
            return location;
        }
        int opCode = insn.getOpcode();
        if (location.local && (opCode < 54 || opCode > 58) && opCode != 132) {
            return location;
        }
        Frame<SourceValue> preFrame = OriginsAnalysis.makePreFrame(frame);
        preFrame.execute(insn, (Interpreter)ourInterpreter);
        if (location.local) {
            SourceValue preVal = (SourceValue)preFrame.getLocal(location.slot);
            if (preVal instanceof PreValue) {
                PreValue val = (PreValue)preVal;
                return new Location(val.local, val.slot);
            }
        } else {
            SourceValue preVal = (SourceValue)preFrame.getStack(location.slot);
            if (preVal instanceof PreValue) {
                PreValue val = (PreValue)preVal;
                return new Location(val.local, val.slot);
            }
        }
        return null;
    }

    @NotNull
    private static Frame<SourceValue> makePreFrame(@NotNull Frame<Value> frame) {
        int i2;
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/codeInspection/bytecodeAnalysis/asm/OriginsAnalysis", "makePreFrame"));
        }
        Frame preFrame = new Frame(frame.getLocals(), frame.getMaxStackSize());
        for (i2 = 0; i2 < frame.getLocals(); ++i2) {
            preFrame.setLocal(i2, (Value)new PreValue(true, i2, frame.getLocal(i2).getSize()));
        }
        for (i2 = 0; i2 < frame.getStackSize(); ++i2) {
            preFrame.push((Value)new PreValue(false, i2, frame.getStack(i2).getSize()));
        }
        Frame frame2 = preFrame;
        if (frame2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/asm/OriginsAnalysis", "makePreFrame"));
        }
        return frame2;
    }

    private static class InsnLocation
    extends Location {
        final int insnIndex;

        private InsnLocation(boolean local, int insnIndex, int slot) {
            super(local, slot);
            this.insnIndex = insnIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            InsnLocation insnLocation = (InsnLocation)o;
            if (this.local != insnLocation.local) {
                return false;
            }
            if (this.insnIndex != insnLocation.insnIndex) {
                return false;
            }
            return this.slot == insnLocation.slot;
        }

        public int hashCode() {
            int result2 = 31 * this.insnIndex + this.slot + 1;
            return this.local ? result2 : -result2;
        }
    }

    private static class Location {
        final boolean local;
        final int slot;

        Location(boolean local, int slot) {
            this.local = local;
            this.slot = slot;
        }
    }

    private static class PreValue
    extends SourceValue {
        final boolean local;
        final int slot;

        public PreValue(boolean local, int slot, int size) {
            super(size);
            this.local = local;
            this.slot = slot;
        }
    }
}

