/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class LoopAnalyzer {
    LoopAnalyzer() {
    }

    static int[] calcInLoop(ControlFlow controlFlow) {
        final int[] loop = new int[controlFlow.getInstructionCount()];
        MyGraph graph = new MyGraph(controlFlow);
        final DFSTBuilder builder = new DFSTBuilder((Graph)graph);
        TIntArrayList sccs = builder.getSCCs();
        sccs.forEach(new TIntProcedure(){
            private int myTNumber;
            private int component;

            public boolean execute(int size) {
                int value = size > 1 ? (this.component = this.component + 1) : 0;
                for (int i2 = 0; i2 < size; ++i2) {
                    Instruction instruction = (Instruction)builder.getNodeByTNumber(this.myTNumber + i2);
                    loop[instruction.getIndex()] = value;
                }
                this.myTNumber += size;
                return true;
            }
        });
        return loop;
    }

    @NotNull
    static int[] getSuccessorIndices(int i2, Instruction[] myInstructions) {
        int[] nArray;
        int offset;
        Instruction instruction = myInstructions[i2];
        if (instruction instanceof GotoInstruction) {
            int[] nArray2 = new int[]{((GotoInstruction)instruction).getOffset()};
            if (nArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer", "getSuccessorIndices"));
            }
            return nArray2;
        }
        if (instruction instanceof ControlTransferInstruction) {
            int[] nArray3 = ArrayUtil.toIntArray(((ControlTransferInstruction)instruction).getPossibleTargetIndices());
            if (nArray3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer", "getSuccessorIndices"));
            }
            return nArray3;
        }
        if (instruction instanceof ConditionalGotoInstruction && (offset = ((ConditionalGotoInstruction)instruction).getOffset()) != i2 + 1) {
            int[] nArray4 = new int[]{i2 + 1, offset};
            if (nArray4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer", "getSuccessorIndices"));
            }
            return nArray4;
        }
        if (i2 == myInstructions.length - 1) {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
        } else {
            int[] nArray5 = new int[1];
            nArray = nArray5;
            nArray5[0] = i2 + 1;
        }
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer", "getSuccessorIndices"));
        }
        return nArray;
    }

    private static class MyGraph
    implements Graph<Instruction> {
        @NotNull
        private final ControlFlow myFlow;
        private final Instruction[] myInstructions;
        private final TIntObjectHashMap<int[]> myIns;

        private MyGraph(@NotNull ControlFlow flow) {
            if (flow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/codeInspection/dataFlow/LoopAnalyzer$MyGraph", "<init>"));
            }
            this.myIns = new TIntObjectHashMap();
            this.myFlow = flow;
            for (Instruction instruction : this.myInstructions = flow.getInstructions()) {
                int[] to;
                int fromIndex = instruction.getIndex();
                for (int toIndex : to = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions)) {
                    int[] froms = (int[])this.myIns.get(toIndex);
                    if (froms == null) {
                        froms = new int[]{fromIndex};
                        this.myIns.put(toIndex, (Object)froms);
                        continue;
                    }
                    froms = ArrayUtil.append((int[])froms, (int)fromIndex);
                    this.myIns.put(toIndex, (Object)froms);
                }
            }
        }

        public Collection<Instruction> getNodes() {
            return Arrays.asList(this.myFlow.getInstructions());
        }

        public Iterator<Instruction> getIn(Instruction n) {
            int[] ins = (int[])this.myIns.get(n.getIndex());
            return this.indicesToInstructions(ins);
        }

        public Iterator<Instruction> getOut(Instruction instruction) {
            int fromIndex = instruction.getIndex();
            int[] next = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions);
            return this.indicesToInstructions(next);
        }

        @NotNull
        private Iterator<Instruction> indicesToInstructions(int[] next) {
            if (next == null) {
                EmptyIterator emptyIterator = EmptyIterator.getInstance();
                if (emptyIterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer$MyGraph", "indicesToInstructions"));
                }
                return emptyIterator;
            }
            ArrayList<Instruction> out = new ArrayList<Instruction>(next.length);
            for (int i2 : next) {
                out.add(this.myInstructions[i2]);
            }
            Iterator<Instruction> iterator = out.iterator();
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LoopAnalyzer$MyGraph", "indicesToInstructions"));
            }
            return iterator;
        }
    }
}

