/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodContract {
    public final ValueConstraint[] arguments;
    public final ValueConstraint returnValue;

    public MethodContract(@NotNull ValueConstraint[] arguments, @NotNull ValueConstraint returnValue) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInspection/dataFlow/MethodContract", "<init>"));
        }
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/dataFlow/MethodContract", "<init>"));
        }
        this.arguments = arguments;
        this.returnValue = returnValue;
    }

    @NotNull
    static ValueConstraint[] createConstraintArray(int paramCount) {
        ValueConstraint[] args = new ValueConstraint[paramCount];
        for (int i2 = 0; i2 < args.length; ++i2) {
            args[i2] = ValueConstraint.ANY_VALUE;
        }
        if (args == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "createConstraintArray"));
        }
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodContract)) {
            return false;
        }
        MethodContract contract = (MethodContract)o;
        if (!Arrays.equals((Object[])this.arguments, (Object[])contract.arguments)) {
            return false;
        }
        return this.returnValue == contract.returnValue;
    }

    public int hashCode() {
        int result2 = 0;
        for (ValueConstraint argument : this.arguments) {
            result2 = 31 * result2 + argument.ordinal();
        }
        result2 = 31 * result2 + this.returnValue.ordinal();
        return result2;
    }

    public String toString() {
        return StringUtil.join((Object[])this.arguments, constraint -> constraint.toString(), (String)", ") + " -> " + (Object)((Object)this.returnValue);
    }

    public static List<MethodContract> parseContract(String text) throws ParseException {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String clause : StringUtil.replace((String)text, (String)" ", (String)"").split(";")) {
            ValueConstraint[] args;
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw new ParseException("A contract clause must be in form arg1, ..., argN -> return-value");
            }
            String beforeArrow = clause.substring(0, arrowIndex);
            if (StringUtil.isNotEmpty((String)beforeArrow)) {
                String[] argStrings = beforeArrow.split(",");
                args = new ValueConstraint[argStrings.length];
                for (int i2 = 0; i2 < args.length; ++i2) {
                    args[i2] = MethodContract.parseConstraint(argStrings[i2]);
                }
            } else {
                args = new ValueConstraint[]{};
            }
            result2.add(new MethodContract(args, MethodContract.parseConstraint(clause.substring(arrowIndex + arrow.length()))));
        }
        return result2;
    }

    private static ValueConstraint parseConstraint(String name) throws ParseException {
        if (StringUtil.isEmpty((String)name)) {
            throw new ParseException("Constraint should not be empty");
        }
        for (ValueConstraint constraint : ValueConstraint.values()) {
            if (!constraint.toString().equals(name)) continue;
            return constraint;
        }
        throw new ParseException("Constraint should be one of: null, !null, true, false, fail, _. Found: " + name);
    }

    public static class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }

    public static enum ValueConstraint {
        ANY_VALUE("_"),
        NULL_VALUE("null"),
        NOT_NULL_VALUE("!null"),
        TRUE_VALUE("true"),
        FALSE_VALUE("false"),
        THROW_EXCEPTION("fail");

        private final String myPresentableName;

        private ValueConstraint(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @Nullable
        DfaConstValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.getConstFactory().getNull();
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.getConstFactory().getTrue();
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public String toString() {
            return this.myPresentableName;
        }
    }
}

