/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EditInspectionToolsSettingsAction
implements IntentionAction,
Iconable,
HighPriorityAction {
    private final String myShortName;

    public EditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "<init>"));
        }
        this.myShortName = key2.toString();
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "invoke"));
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(file2.getProject());
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, this.myShortName);
    }

    public boolean editToolSettings(Project project2, InspectionProfileImpl inspectionProfile) {
        return EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, this.myShortName);
    }

    public static boolean editToolSettings(Project project2, InspectionProfileImpl inspectionProfile, String selectedToolShortName) {
        return EditInspectionToolsSettingsAction.editSettings(project2, inspectionProfile, c -> c.selectInspectionTool(selectedToolShortName));
    }

    public static boolean editSettings(Project project2, InspectionProfileImpl inspectionProfile, Consumer<ErrorsConfigurable> configurableAction) {
        ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
        ProjectInspectionToolsConfigurable errorsConfigurable = new ProjectInspectionToolsConfigurable(ProjectInspectionProfileManager.getInstance(project2)){

            @Override
            protected boolean setActiveProfileAsDefaultOnApply() {
                return false;
            }
        };
        return settingsUtil.editConfigurable(project2, (Configurable)errorsConfigurable, () -> {
            errorsConfigurable.selectProfile(inspectionProfile);
            ApplicationManager.getApplication().invokeLater(() -> configurableAction.accept(errorsConfigurable));
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.Settings;
    }
}

