/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014JR\u0010\u000f\u001aB\u0012>\u0012<\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013*\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u00010\u0011\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0006J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/intellij/codeInspection/ex/InspectionProfileModifiableModel;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "Lcom/intellij/codeInspection/ModifiableModel;", "source", "(Lcom/intellij/codeInspection/ex/InspectionProfileImpl;)V", "modified", "", "getSource", "()Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "commit", "", "copyToolsConfigurations", "profile", "project", "Lcom/intellij/openapi/project/Project;", "createTools", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "Lcom/intellij/codeInspection/InspectionProfileEntry;", "kotlin.jvm.PlatformType", "Lcom/intellij/codeInspection/InspectionEP;", "Lorg/jetbrains/annotations/NotNull;", "isChanged", "isProperSetting", "toolId", "", "resetToBase", "resetToEmpty", "setModified", "value", "toString", "model", "analysis-impl"})
public class InspectionProfileModifiableModel
extends InspectionProfileImpl
implements ModifiableModel {
    private boolean modified;
    @NotNull
    private final InspectionProfileImpl source;

    public final boolean isChanged() {
        return this.modified || this.source.myLockedProfile != this.myLockedProfile;
    }

    public final void setModified(boolean value) {
        this.modified = value;
    }

    @Override
    protected void copyToolsConfigurations(@Nullable Project project2) {
        this.copyToolsConfigurations(this.source, project2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<InspectionToolWrapper<InspectionProfileEntry, InspectionEP>> createTools(@Nullable Project project2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.source.getDefaultStates(project2);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ScopeToolState scopeToolState = (ScopeToolState)item$iv$iv;
            void var11_8 = destination$iv$iv;
            InspectionToolWrapper inspectionToolWrapper = it.getTool();
            var11_8.add(inspectionToolWrapper);
        }
        return (List)destination$iv$iv;
    }

    private final void copyToolsConfigurations(InspectionProfileImpl profile2, Project project2) {
        try {
            for (ToolsImpl toolList : profile2.myTools.values()) {
                Object v = this.myTools.get(toolList.getShortName());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ToolsImpl tools = (ToolsImpl)v;
                ScopeToolState defaultState = toolList.getDefaultState();
                tools.setDefaultState(InspectionProfileImpl.copyToolSettings(defaultState.getTool()), defaultState.isEnabled(), defaultState.getLevel());
                tools.removeAllScopes();
                List<ScopeToolState> nonDefaultToolStates = toolList.getNonDefaultTools();
                if (nonDefaultToolStates != null) {
                    for (ScopeToolState state : nonDefaultToolStates) {
                        InspectionToolWrapper toolWrapper = InspectionProfileImpl.copyToolSettings(state.getTool());
                        NamedScope scope = state.getScope(project2);
                        if (scope == null) {
                            tools.addTool(state.getScopeName(), toolWrapper, state.isEnabled(), state.getLevel());
                            continue;
                        }
                        tools.addTool(scope, toolWrapper, state.isEnabled(), state.getLevel());
                    }
                }
                tools.setEnabled(toolList.isEnabled());
            }
        }
        catch (WriteExternalException e) {
            InspectionProfileImpl.LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            InspectionProfileImpl.LOG.error((Throwable)e);
        }
    }

    public final boolean isProperSetting(@NotNull String toolId) {
        Intrinsics.checkParameterIsNotNull((Object)toolId, (String)"toolId");
        if (this.myBaseProfile != null) {
            ToolsImpl currentTools;
            ToolsImpl tools = this.myBaseProfile.getTools(toolId, null);
            return !Comparing.equal((Object)tools, (Object)(currentTools = (ToolsImpl)this.myTools.get(toolId)));
        }
        return false;
    }

    public final void resetToBase(@Nullable Project project2) {
        this.initInspectionTools(project2);
        InspectionProfileImpl inspectionProfileImpl = this.myBaseProfile;
        Intrinsics.checkExpressionValueIsNotNull((Object)inspectionProfileImpl, (String)"myBaseProfile");
        this.copyToolsConfigurations(inspectionProfileImpl, project2);
        this.myChangedToolNames = null;
    }

    public final void commit() {
        this.commit(this.source, this);
        this.modified = false;
    }

    public final void resetToEmpty(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.initInspectionTools(project2);
        InspectionToolWrapper[] inspectionToolWrapperArray = this.getInspectionTools(null);
        for (int j = 0; j < inspectionToolWrapperArray.length; ++j) {
            InspectionToolWrapper toolWrapper = inspectionToolWrapperArray[j];
            this.disableTool(toolWrapper.getShortName(), project2);
        }
    }

    private final void commit(@NotNull InspectionProfileImpl $receiver, InspectionProfileImpl model) {
        $receiver.setName(model.getName());
        $receiver.setDescription(model.getDescription());
        $receiver.setProjectLevel(model.isProjectLevel());
        $receiver.myLockedProfile = model.myLockedProfile;
        $receiver.myChangedToolNames = model.myChangedToolNames;
        $receiver.myTools = model.myTools;
        $receiver.setProfileManager(model.getProfileManager());
    }

    @Override
    @NotNull
    public String toString() {
        return this.getName() + " (copy)";
    }

    @NotNull
    public final InspectionProfileImpl getSource() {
        return this.source;
    }

    public InspectionProfileModifiableModel(@NotNull InspectionProfileImpl source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super(source.getName(), source.myRegistrar, source.getProfileManager(), source.myBaseProfile, null);
        this.source = source;
        Map<String, Element> map = this.source.myUninitializedSettings;
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"source.myUninitializedSettings");
        this.myUninitializedSettings.putAll(map);
        this.setProjectLevel(this.source.isProjectLevel());
        this.myLockedProfile = this.source.myLockedProfile;
        this.copyFrom(this.source);
    }
}

