/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Java9ModuleExportsPackageToItselfInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaFile javaFile;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        if (file2 instanceof PsiJavaFile && (javaFile = (PsiJavaFile)file2).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && javaFile.getModuleDeclaration() != null) {
            ExportedToSelfVisitor exportedToSelfVisitor = new ExportedToSelfVisitor(holder);
            if (exportedToSelfVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
            }
            return exportedToSelfVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class DeleteExportsToModuleFix
    implements LocalQuickFix {
        private final String myModuleName;

        public DeleteExportsToModuleFix(PsiJavaModuleReferenceElement reference) {
            this.myModuleName = reference.getReferenceText();
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"exports.to.itself.delete.module.fix.name", (Object[])new Object[]{this.myModuleName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"exports.to.itself.delete.module.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection$DeleteExportsToModuleFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(psiElement)) {
                return;
            }
            psiElement.delete();
        }
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitExportsStatement(PsiExportsStatement statement2) {
            super.visitExportsStatement(statement2);
            PsiJavaModule javaModule = (PsiJavaModule)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getModuleName();
                ArrayList referenceElements = ContainerUtil.newArrayList((Iterable)statement2.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : referenceElements) {
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message = InspectionsBundle.message((String)"inspection.module.exports.package.to.itself.message", (Object[])new Object[0]);
                    this.myHolder.registerProblem((PsiElement)referenceElement, message, new LocalQuickFix[]{new DeleteExportsToModuleFix(referenceElement)});
                }
            }
        }
    }
}

