/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9NonAccessibleTypeExposedInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        THashSet exportedPackageNames;
        Module module2;
        VirtualFile vFile;
        PsiJavaModule psiModule;
        PsiJavaFile javaFile;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        if (file2 instanceof PsiJavaFile && (javaFile = (PsiJavaFile)file2).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (psiModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file2)) != null && (vFile = file2.getVirtualFile()) != null && (module2 = ProjectFileIndex.SERVICE.getInstance((Project)holder.getProject()).getModuleForFile(vFile)) != null && (exportedPackageNames = new THashSet((Collection)ContainerUtil.mapNotNull((Iterable)psiModule.getExports(), p -> p.getPackageName()))).contains(javaFile.getPackageName())) {
            NonAccessibleTypeExposedVisitor nonAccessibleTypeExposedVisitor = new NonAccessibleTypeExposedVisitor(holder, module2, (Set<String>)exportedPackageNames);
            if (nonAccessibleTypeExposedVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection", "buildVisitor"));
            }
            return nonAccessibleTypeExposedVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class NonAccessibleTypeExposedVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final ModuleFileIndex myModuleFileIndex;
        private final Set<String> myExportedPackageNames;

        public NonAccessibleTypeExposedVisitor(@NotNull ProblemsHolder holder, @NotNull Module module2, @NotNull Set<String> exportedPackageNames) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection$NonAccessibleTypeExposedVisitor", "<init>"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection$NonAccessibleTypeExposedVisitor", "<init>"));
            }
            if (exportedPackageNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedPackageNames", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection$NonAccessibleTypeExposedVisitor", "<init>"));
            }
            this.myHolder = holder;
            this.myModuleFileIndex = ModuleRootManager.getInstance((Module)module2).getFileIndex();
            this.myExportedPackageNames = exportedPackageNames;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiClass psiClass;
            PsiElement resolved;
            PsiElement grandParent;
            super.visitReferenceElement(reference);
            PsiElement parent = reference.getParent();
            if ((parent instanceof PsiTypeElement || parent instanceof PsiReferenceList) && ((grandParent = PsiTreeUtil.skipParentsOfType((PsiElement)reference, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceList.class, PsiParameter.class, PsiParameterList.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, PsiTypeParameterList.class})) instanceof PsiField || grandParent instanceof PsiMethod || grandParent instanceof PsiClass) && this.isModulePublicApi((PsiMember)grandParent) && (resolved = reference.resolve()) instanceof PsiClass && !(resolved instanceof PsiTypeParameter) && !this.isModulePublicApi((PsiMember)(psiClass = (PsiClass)resolved)) && this.isInModuleSource(psiClass)) {
                this.registerProblem((PsiElement)reference);
            }
        }

        @Contract(value="null -> false")
        private boolean isModulePublicApi(@Nullable PsiMember member) {
            if (member != null && !(member instanceof PsiTypeParameter) && (member.hasModifierProperty("public") || member.hasModifierProperty("protected"))) {
                PsiElement parent = member.getParent();
                if (parent instanceof PsiClass) {
                    return this.isModulePublicApi((PsiMember)((PsiClass)parent));
                }
                if (parent instanceof PsiJavaFile) {
                    String packageName = ((PsiJavaFile)parent).getPackageName();
                    return this.myExportedPackageNames.contains(packageName);
                }
            }
            return false;
        }

        private boolean isInModuleSource(@NotNull PsiClass psiClass) {
            VirtualFile vFile;
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/java19modules/Java9NonAccessibleTypeExposedInspection$NonAccessibleTypeExposedVisitor", "isInModuleSource"));
            }
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                return this.myModuleFileIndex.isInSourceContent(vFile);
            }
            return false;
        }

        private void registerProblem(PsiElement element) {
            this.myHolder.registerProblem(element, InspectionsBundle.message((String)"inspection.non.accessible.type.exposed.name", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }
}

