/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9RedundantRequiresStatementInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java9RedundantRequiresStatementInspection.class);
    private static final Key<Set<String>> IMPORTED_JAVA_PACKAGES = Key.create((String)"imported_java_packages");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "checkElement"));
        }
        if (refEntity instanceof RefJavaModule) {
            List requiredModules;
            Set moduleImportedPackages;
            RefJavaModule refJavaModule = (RefJavaModule)refEntity;
            RefModule refModule = refJavaModule.getModule();
            PsiJavaModule psiJavaModule = refJavaModule.getElement();
            if (refModule != null && psiJavaModule != null && (moduleImportedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES)) != null && !(requiredModules = refJavaModule.getRequiredModules()).isEmpty()) {
                ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                for (RefJavaModule.RequiredModule requiredModule : requiredModules) {
                    PsiRequiresStatement requiresStatement;
                    String requiredModuleName = requiredModule.moduleName;
                    if (!"java.base".equals(requiredModuleName) && !Java9RedundantRequiresStatementInspection.isDependencyUnused(requiredModule.packagesExportedByModule, moduleImportedPackages, refJavaModule.getName()) || (requiresStatement = (PsiRequiresStatement)ContainerUtil.find((Iterable)psiJavaModule.getRequires(), statement2 -> requiredModuleName.equals(statement2.getModuleName()))) == null) continue;
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)requiresStatement, InspectionsBundle.message((String)"inspection.redundant.requires.statement.description", (Object[])new Object[]{requiredModuleName}), (LocalQuickFix)new DeleteRedundantRequiresStatementFix(requiredModuleName, moduleImportedPackages), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    descriptors.add(descriptor);
                }
                if (!ContainerUtil.isEmpty(descriptors)) {
                    return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                }
            }
        }
        return null;
    }

    private static boolean isDependencyUnused(@NotNull Map<String, List<String>> dependencyExportedPackages, @NotNull Set<String> importedPackageNames, @NotNull String contextModuleName) {
        if (dependencyExportedPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyExportedPackages", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        if (importedPackageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedPackageNames", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        if (contextModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModuleName", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "isDependencyUnused"));
        }
        for (Map.Entry<String, List<String>> entry : dependencyExportedPackages.entrySet()) {
            String exportedPackageName = entry.getKey();
            List<String> exportedToModules = entry.getValue();
            if (!exportedToModules.isEmpty() && !exportedToModules.contains(contextModuleName) || !importedPackageNames.contains(exportedPackageName)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection", "getAnnotator"));
        }
        return new RedundantRequiresStatementAnnotator();
    }

    private static PsiJavaModule resolveRequiredModule(PsiRequiresStatement requiresStatement) {
        return PsiJavaModuleReference.resolve((PsiElement)requiresStatement, requiresStatement.getModuleName(), false);
    }

    private static class RedundantRequiresStatementAnnotator
    extends RefGraphAnnotator {
        private static final Set<String> DONT_COLLECT_PACKAGES = Collections.emptySet();

        private RedundantRequiresStatementAnnotator() {
        }

        public void onReferencesBuild(RefElement refElement) {
            RefModule refModule;
            if (refElement instanceof RefFile) {
                RefFile refFile = (RefFile)refElement;
                PsiFile file2 = refFile.getElement();
                if (file2 instanceof PsiJavaFile) {
                    RedundantRequiresStatementAnnotator.onJavaFileReferencesBuilt(refFile, (PsiJavaFile)file2);
                }
            } else if (refElement instanceof RefJavaModule && (refModule = refElement.getModule()) != null) {
                RedundantRequiresStatementAnnotator.setImportedPackages(refModule, refElement.getElement() != null);
            }
        }

        private static void onJavaFileReferencesBuilt(@NotNull RefFile refFile, @NotNull PsiJavaFile file2) {
            Set<String> packageNames;
            RefModule refModule;
            PsiImportList importList;
            if (refFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refFile", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "onJavaFileReferencesBuilt"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "onJavaFileReferencesBuilt"));
            }
            if (file2.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (importList = file2.getImportList()) != null && (refModule = refFile.getModule()) != null && (packageNames = RedundantRequiresStatementAnnotator.getImportedPackages(refModule)) != DONT_COLLECT_PACKAGES) {
                PsiImportStatementBase[] statements;
                for (PsiImportStatementBase statement2 : statements = importList.getAllImportStatements()) {
                    String packageName = RedundantRequiresStatementAnnotator.getPackageName(statement2);
                    if (StringUtil.isEmpty((String)packageName)) continue;
                    packageNames.add(packageName);
                }
            }
        }

        @Nullable
        private static String getPackageName(@NotNull PsiImportStatementBase statement2) {
            PsiJavaFile parentFile;
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getPackageName"));
            }
            PsiElement resolved = statement2.resolve();
            if (resolved instanceof PsiPackage) {
                return ((PsiPackage)resolved).getQualifiedName();
            }
            if (resolved instanceof PsiMember && (parentFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiJavaFile.class)) != null) {
                return parentFile.getPackageName();
            }
            return null;
        }

        @NotNull
        private static Set<String> getImportedPackages(@NotNull RefModule refModule) {
            if (refModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getImportedPackages"));
            }
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByModule(refModule.getModule());
                importedPackages = javaModule != null ? new THashSet() : DONT_COLLECT_PACKAGES;
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)importedPackages);
            }
            Set set2 = importedPackages;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$RedundantRequiresStatementAnnotator", "getImportedPackages"));
            }
            return set2;
        }

        private static void setImportedPackages(RefModule refModule, boolean collectPackages) {
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)(collectPackages ? new THashSet() : DONT_COLLECT_PACKAGES));
            }
        }
    }

    private static class DeleteRedundantRequiresStatementFix
    implements LocalQuickFix {
        private String myRequiredModuleName;
        private Set<String> myImportedPackages;

        public DeleteRedundantRequiresStatementFix(String requiredModuleName, Set<String> importedPackages) {
            this.myRequiredModuleName = requiredModuleName;
            this.myImportedPackages = importedPackages;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.name", (Object[])new Object[]{this.myRequiredModuleName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            LOG.assertTrue(element instanceof PsiRequiresStatement, (Object)"Should be 'requires' statement");
            PsiRequiresStatement statementToDelete = (PsiRequiresStatement)element;
            this.addTransitiveDependencies(statementToDelete);
            statementToDelete.delete();
        }

        private Set<String> getReexportedDependencies(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule dependencyModule) {
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getReexportedDependencies"));
            }
            if (dependencyModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "getReexportedDependencies"));
            }
            Set directDependencies = ((StreamEx)StreamEx.of(currentModule.getRequires().iterator()).map(PsiRequiresStatement::getModuleName).nonNull()).toSet();
            List transitiveModules = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(dependencyModule.getRequires().iterator()).filter(PsiRequiresStatement::isPublic)).filter(requiresStatement -> !directDependencies.contains(requiresStatement.getModuleName()))).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).nonNull()).toList();
            return ((StreamEx)StreamEx.of((Collection)transitiveModules).filter(transitiveModule -> {
                if (currentModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$getReexportedDependencies$2"));
                }
                return this.isReexported(currentModule, (PsiJavaModule)transitiveModule);
            })).map(transitiveModule -> transitiveModule.getModuleName()).toSet();
        }

        private boolean isReexported(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule transitiveModule) {
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "isReexported"));
            }
            if (transitiveModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transitiveModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "isReexported"));
            }
            return ((StreamEx)((StreamEx)StreamEx.of(transitiveModule.getExports().iterator()).map(PsiExportsStatement::getPackageName).nonNull()).filter(this.myImportedPackages::contains)).anyMatch(packageName -> {
                if (transitiveModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transitiveModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$isReexported$4"));
                }
                if (currentModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$isReexported$4"));
                }
                return JavaModuleGraphUtil.exports(transitiveModule, packageName, currentModule);
            });
        }

        private void addTransitiveDependencies(@NotNull PsiRequiresStatement statementToDelete) {
            if (statementToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementToDelete", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addTransitiveDependencies"));
            }
            PsiElement parent = statementToDelete.getParent();
            if (parent instanceof PsiJavaModule) {
                PsiJavaModule currentModule = (PsiJavaModule)parent;
                Optional.of(statementToDelete).map(x$0 -> Java9RedundantRequiresStatementInspection.resolveRequiredModule(x$0)).map(dependencyModule -> this.getReexportedDependencies(currentModule, (PsiJavaModule)dependencyModule)).ifPresent(reexportedDependencies -> {
                    if (statementToDelete == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementToDelete", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "lambda$addTransitiveDependencies$7"));
                    }
                    DeleteRedundantRequiresStatementFix.addReexportedDependencies(reexportedDependencies, currentModule, (PsiElement)statementToDelete);
                });
            }
        }

        private static void addReexportedDependencies(@NotNull Set<String> reexportedDependencies, @NotNull PsiJavaModule currentModule, @NotNull PsiElement addingPlace) {
            if (reexportedDependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reexportedDependencies", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (currentModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (addingPlace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addingPlace", "com/intellij/codeInspection/java19modules/Java9RedundantRequiresStatementInspection$DeleteRedundantRequiresStatementFix", "addReexportedDependencies"));
            }
            if (!reexportedDependencies.isEmpty()) {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)currentModule.getProject()).getParserFacade();
                for (String dependencyName : reexportedDependencies) {
                    PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + currentModule.getModuleName() + " { requires " + dependencyName + "; }");
                    Iterable tempModuleRequires = tempModule.getRequires();
                    PsiRequiresStatement requiresStatement = (PsiRequiresStatement)tempModuleRequires.iterator().next();
                    currentModule.addAfter((PsiElement)requiresStatement, addingPlace);
                }
            }
        }
    }
}

