/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.type.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RedundantTypeArguments" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getShortName"));
        }
        return "RedundantTypeArguments";
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "checkMethod"));
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions((PsiElement)body, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection", "getDescriptions"));
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression((PsiJavaCodeReferenceElement)expression.getMethodExpression(), typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                super.visitNewExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference, typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                RedundantTypeArgsInspection.checkMethodReference(expression, inspectionManager, problems);
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiMethod method2;
        PsiTypeParameter[] typeParameters;
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && resolveResult.isValidResult() && (typeParameters = (method2 = (PsiMethod)element).getTypeParameters()).length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression, false, method2, typeParameters)) {
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)expression.getTypeArgumentList(), InspectionsBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
            problems.add(descriptor);
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems) {
        PsiMethodReferenceExpression copy;
        JavaResolveResult simplifiedResolve;
        PsiElement candidate;
        JavaResolveResult result2;
        PsiElement element;
        PsiType psiType;
        PsiTypeElement qualifierTypeElement = expression.getQualifierType();
        if (qualifierTypeElement != null && (psiType = qualifierTypeElement.getType()) instanceof PsiClassType && !((PsiClassType)psiType).isRaw() && (element = (result2 = expression.advancedResolve(false)).getElement()) instanceof PsiTypeParameterListOwner && (candidate = (simplifiedResolve = (copy = RedundantTypeArgsInspection.createMethodReference(expression, qualifierTypeElement)).advancedResolve(false)).getElement()) == element) {
            PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
            LOG.assertTrue(referenceElement != null, (Object)qualifierTypeElement);
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            LOG.assertTrue(parameterList != null);
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)new MyMethodReferenceFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
            problems.add(descriptor);
        }
    }

    private static PsiMethodReferenceExpression createMethodReference(PsiMethodReferenceExpression expression, PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        PsiMethodReferenceExpression copy = (PsiMethodReferenceExpression)expression.copy();
        copy.getQualifierType().replace((PsiElement)elementFactory.createTypeElement((PsiType)((PsiClassType)type).rawType()));
        return copy;
    }

    private static class MyMethodReferenceFixAction
    implements LocalQuickFix {
        private MyMethodReferenceFixAction() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyMethodReferenceFixAction", "applyFix"));
            }
            PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiTypeElement.class);
            PsiMethodReferenceExpression expression = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethodReferenceExpression.class);
            if (expression != null) {
                expression.replace((PsiElement)RedundantTypeArgsInspection.createMethodReference(expression, typeElement));
            }
        }
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace((PsiElement)expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

