/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ToArrayMigration
extends BaseStreamApiMigration {
    protected ToArrayMigration() {
        super("toArray");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body, @NotNull TerminalBlock tb) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ToArrayMigration", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ToArrayMigration", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ToArrayMigration", "migrate"));
        }
        PsiLocalVariable arrayVariable = StreamApiMigrationInspection.extractArray(tb);
        if (arrayVariable == null) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiExpression rValue = assignment.getRExpression();
        if (rValue == null) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)arrayVariable.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiExpression dimension = (PsiExpression)ArrayUtil.getFirstElement((Object[])initializer.getArrayDimensions());
        if (dimension == null) {
            return null;
        }
        StreamApiMigrationInspection.CountingLoopSource loop = tb.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class);
        if (loop == null) {
            return null;
        }
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)initializer.getType(), PsiArrayType.class);
        if (arrayType == null) {
            return null;
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)arrayVariable, tb.getMainLoop());
        if (status == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        PsiType componentType = arrayType.getComponentType();
        String supplier = componentType instanceof PsiPrimitiveType || componentType.equalsToText("java.lang.Object") ? "" : arrayType.getCanonicalText() + "::new";
        StreamApiMigrationInspection.MapOp mapping = new StreamApiMigrationInspection.MapOp(rValue, tb.getVariable(), assignment.getType());
        String replacementText = loop.withBound(dimension).createReplacement() + mapping.createReplacement() + ".toArray(" + supplier + ")";
        return ToArrayMigration.replaceInitializer(tb.getMainLoop(), (PsiVariable)arrayVariable, (PsiExpression)initializer, replacementText, status);
    }
}

