/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedInspectionTreeNodesManager {
    private final Map<Class, Set<Object>> myExcludedNodeObjects = new FactoryMap<Class, Set<Object>>(){

        @Nullable
        protected Set<Object> create(Class key2) {
            return new THashSet();
        }
    };
    private final Map<String, Set<Object>> myExcludedByTool = new FactoryMap<String, Set<Object>>(){

        @Nullable
        protected Set<Object> create(String key2) {
            return new THashSet();
        }
    };
    private final boolean myOffline;
    private final boolean mySingleInspectionRun;

    public ExcludedInspectionTreeNodesManager(boolean offline, boolean singleInspectionRun) {
        this.myOffline = offline;
        this.mySingleInspectionRun = singleInspectionRun;
    }

    public synchronized boolean isExcluded(InspectionTreeNode node) {
        if (!this.mySingleInspectionRun && (node instanceof RefElementNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode)) {
            return this.myExcludedByTool.get(ExcludedInspectionTreeNodesManager.findContainingToolName(node)).contains(node.getUserObject());
        }
        Set<Object> excluded = this.myExcludedNodeObjects.get(node.getClass());
        return excluded.contains(node.getUserObject());
    }

    public synchronized void exclude(InspectionTreeNode node) {
        if (!this.mySingleInspectionRun && (node instanceof RefElementNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode)) {
            this.myExcludedByTool.get(ExcludedInspectionTreeNodesManager.findContainingToolName(node)).add(node.getUserObject());
        } else {
            this.myExcludedNodeObjects.get(node.getClass()).add(node.getUserObject());
        }
    }

    public synchronized void amnesty(InspectionTreeNode node) {
        if (!this.mySingleInspectionRun && (node instanceof RefElementNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode)) {
            this.myExcludedByTool.get(ExcludedInspectionTreeNodesManager.findContainingToolName(node)).remove(node.getUserObject());
        } else {
            this.myExcludedNodeObjects.get(node.getClass()).remove(node.getUserObject());
        }
    }

    public synchronized boolean containsRefEntity(@NotNull RefEntity entity, @NotNull InspectionToolWrapper wrapper) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "containsRefEntity"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "containsRefEntity"));
        }
        return this.myExcludedByTool.get(wrapper.getShortName()).contains(entity);
    }

    public synchronized boolean containsProblemDescriptor(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "containsProblemDescriptor"));
        }
        return this.myExcludedNodeObjects.get(this.myOffline ? OfflineProblemDescriptorNode.class : ProblemDescriptionNode.class).contains(descriptor);
    }

    public synchronized boolean containsInspectionNode(@NotNull InspectionToolWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "containsInspectionNode"));
        }
        return this.myExcludedNodeObjects.get(InspectionNode.class).contains(wrapper);
    }

    @NotNull
    private static String findContainingToolName(@NotNull InspectionTreeNode node) {
        TreeNode parent;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "findContainingToolName"));
        }
        for (parent = node.getParent(); !(parent instanceof InspectionNode) && parent != null; parent = parent.getParent()) {
        }
        if (parent == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "findContainingToolName"));
            }
            return "";
        }
        String string = ((InspectionNode)parent).getToolWrapper().getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/ExcludedInspectionTreeNodesManager", "findContainingToolName"));
        }
        return string;
    }
}

