/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.containers.FactoryMap;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends SuppressableInspectionTreeNode {
    private volatile boolean myHasDescriptorsUnder;
    private volatile CommonProblemDescriptor mySingleDescriptor;
    private final Icon myIcon;

    public RefElementNode(@Nullable RefEntity userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ui/RefElementNode", "<init>"));
        }
        super((Object)userObject, presentation);
        this.init(presentation.getContext().getProject());
        RefEntity refEntity = this.getElement();
        this.myIcon = refEntity == null ? null : refEntity.getIcon(false);
    }

    public boolean hasDescriptorsUnder() {
        return this.myHasDescriptorsUnder;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return (RefEntity)this.getUserObject();
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    protected String calculatePresentableName() {
        RefEntity element = this.getElement();
        if (element == null) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getName();
    }

    @Override
    protected boolean calculateIsValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public void excludeElement(ExcludedInspectionTreeNodesManager excludedManager) {
        super.excludeElement(excludedManager);
    }

    @Override
    public void amnestyElement(ExcludedInspectionTreeNodesManager excludedManager) {
        super.amnestyElement(excludedManager);
    }

    @Override
    public FileStatus getNodeStatus() {
        return this.myPresentation.getElementStatus(this.getElement());
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.checkHasDescriptorUnder(newChild);
        super.add(newChild);
    }

    @Override
    public InspectionTreeNode insertByOrder(InspectionTreeNode child, boolean allowDuplication) {
        this.checkHasDescriptorUnder(child);
        return super.insertByOrder(child, allowDuplication);
    }

    public void setProblem(CommonProblemDescriptor descriptor) {
        this.mySingleDescriptor = descriptor;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.mySingleDescriptor;
    }

    @Override
    public RefEntity getContainingFileLocalEntity() {
        RefEntity element = this.getElement();
        return element instanceof RefElement && !(element instanceof RefDirectory) ? element : super.getContainingFileLocalEntity();
    }

    @Override
    public int getProblemCount(boolean allowSuppressed) {
        return this.isLeaf() ? (!(!this.myPresentation.getIgnoredRefElements().contains(this.getElement()) || allowSuppressed && this.isAlreadySuppressedFromView() && this.isValid()) ? 0 : 1) : super.getProblemCount(allowSuppressed);
    }

    @Override
    public void visitProblemSeverities(FactoryMap<HighlightDisplayLevel, Integer> counter) {
        if (this.isLeaf() && !this.myPresentation.isElementIgnored(this.getElement())) {
            counter.put((Object)HighlightDisplayLevel.WARNING, (Object)((Integer)counter.get((Object)HighlightDisplayLevel.WARNING) + 1));
            return;
        }
        super.visitProblemSeverities(counter);
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return false;
    }

    @Override
    @Nullable
    public String getCustomizedTailText() {
        if (this.myPresentation.isDummy()) {
            return "";
        }
        String customizedText = super.getCustomizedTailText();
        if (customizedText != null) {
            return customizedText;
        }
        return this.isLeaf() ? "" : null;
    }

    private void checkHasDescriptorUnder(MutableTreeNode newChild) {
        if (this.myHasDescriptorsUnder) {
            return;
        }
        if (newChild instanceof ProblemDescriptionNode || newChild instanceof RefElementNode && ((RefElementNode)newChild).hasDescriptorsUnder()) {
            this.myHasDescriptorsUnder = true;
            TreeNode parent = this.getParent();
            while (parent instanceof RefElementNode) {
                ((RefElementNode)parent).myHasDescriptorsUnder = true;
                parent = parent.getParent();
            }
        }
    }
}

