/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedWarningLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"unchecked.warning", (Object[])new Object[0]);
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance((String)("#" + UncheckedWarningLocalInspectionBase.class));
    public boolean IGNORE_UNCHECKED_ASSIGNMENT;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION;
    public boolean IGNORE_UNCHECKED_CALL;
    public boolean IGNORE_UNCHECKED_CAST;
    public boolean IGNORE_UNCHECKED_OVERRIDING;

    @NotNull
    static JCheckBox createSetting(@NotNull String cbText, boolean option, @NotNull Pass<JCheckBox> pass) {
        if (cbText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbText", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        JCheckBox uncheckedCb = new JCheckBox(cbText, option);
        uncheckedCb.addActionListener(e -> {
            if (pass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "lambda$createSetting$0"));
            }
            pass.pass((Object)uncheckedCb);
        });
        JCheckBox jCheckBox = uncheckedCb;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "createSetting"));
        }
        return jCheckBox;
    }

    private static LocalQuickFix[] getChangeVariableTypeFixes(@NotNull PsiVariable parameter, @Nullable PsiType itemType, LocalQuickFix[] generifyFixes) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getChangeVariableTypeFixes"));
        }
        if (itemType instanceof PsiMethodReferenceType) {
            return generifyFixes;
        }
        LOG.assertTrue(parameter.isValid());
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : (ChangeVariableTypeQuickFixProvider[])Extensions.getExtensions((ExtensionPointName)ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                for (IntentionAction action : fixProvider.getFixes(parameter, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result2.add((LocalQuickFix)action);
                }
            }
        }
        if (generifyFixes.length > 0) {
            Collections.addAll(result2, generifyFixes);
        }
        return result2.toArray(new LocalQuickFix[result2.size()]);
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getGroupDisplayName"));
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "getID"));
        }
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "writeSettings"));
        }
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)session2.getFile());
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session2);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        UncheckedWarningsVisitor uncheckedWarningsVisitor = new UncheckedWarningsVisitor(isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull String message, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, @NotNull LocalQuickFix[] quickFixes) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                if (quickFixes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1", "registerProblem"));
                }
                String rawExpression = UncheckedWarningLocalInspectionBase.isMethodCalledOnRawType(callExpression);
                if (rawExpression != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message = message + ". Reason: '" + rawExpression + "' has raw type, so result of " + referenceName + " is erased";
                }
                holder.registerProblem(psiElement, message, quickFixes);
            }
        };
        if (uncheckedWarningsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase", "buildVisitor"));
        }
        return uncheckedWarningsVisitor;
    }

    protected LocalQuickFix[] createFixes() {
        return null;
    }

    private static String isMethodCalledOnRawType(PsiElement expression) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression;
        if (expression instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression.getType())) != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qualifierClass, (PsiSubstitutor)((PsiMethodCallExpression)expression).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression.getText();
        }
        return null;
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final LocalQuickFix[] myGenerifyFixes;

        UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "<init>"));
            }
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
            this.myGenerifyFixes = onTheFly ? UncheckedWarningLocalInspectionBase.this.createFixes() : LocalQuickFix.EMPTY_ARRAY;
        }

        protected abstract void registerProblem(@NotNull String var1, PsiElement var2, @NotNull PsiElement var3, @NotNull LocalQuickFix[] var4);

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result2 = expression.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)expression, (JavaResolveResult)result2, (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", null, (PsiElement)expression, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            if (classReference != null && JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)classReference, (JavaResolveResult)expression.resolveMethodGenerics(), (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", (PsiElement)expression, (PsiElement)classReference, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType exprType = operand.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast((PsiType)castType, (PsiType)exprType)) {
                String description = JavaErrorMessages.message("generics.unchecked.cast", JavaHighlightUtil.formatType(exprType), JavaHighlightUtil.formatType(castType));
                this.registerProblem(description, (PsiElement)operand, (PsiElement)expression, this.myGenerifyFixes);
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            super.visitMethodReferenceExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result2 = expression.advancedResolve(false);
            String description = this.getUncheckedCallDescription((PsiElement)expression, result2);
            if (description != null) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                this.registerProblem(description, (PsiElement)expression, (PsiElement)(referenceNameElement != null ? referenceNameElement : expression), this.myGenerifyFixes);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult result2 = callExpression.resolveMethodGenerics();
            String description = this.getUncheckedCallDescription((PsiElement)callExpression, result2);
            if (description != null) {
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                PsiCallExpression element = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression() : callExpression;
                this.registerProblem(description, null, (PsiElement)element, this.myGenerifyFixes);
            } else {
                PsiMethod method2;
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result2.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method2 = (PsiMethod)result2.getElement()) != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiParameter[] parameters = method2.getParameterList().getParameters();
                    if (parameters.length != 0) {
                        for (int i2 = 0; i2 < expressions.length; ++i2) {
                            PsiParameter parameter = parameters[Math.min(i2, parameters.length - 1)];
                            PsiExpression expression = expressions[i2];
                            PsiType parameterType = substitutor.substitute(parameter.getType());
                            PsiType expressionType = expression.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment((PsiElement)expression, expression, parameterType, expressionType, true, this.myGenerifyFixes);
                        }
                    }
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment((PsiElement)initializer, initializer, variable.getType(), initializerType, true, this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(variable, initializerType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            PsiType parameterType = parameter.getType();
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
            LocalQuickFix[] fixes = this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes((PsiVariable)parameter, itemType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY;
            this.checkRawToGenericsAssignment((PsiElement)parameter, iteratedValue, parameterType, itemType, true, fixes);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiElement element;
            super.visitAssignmentExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            PsiVariable leftVar = null;
            if (lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                leftVar = (PsiVariable)element;
            }
            this.checkRawToGenericsAssignment((PsiElement)rExpr, rExpr, lType, rType, true, this.myOnTheFly && leftVar != null ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(leftVar, rType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType type = arrayInitializer.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)itemType) || !JavaGenericsUtil.isRawToGeneric((PsiType)componentType, (PsiType)itemType)) continue;
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(componentType));
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                    fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, (PsiElement)expression, new LocalQuickFix[]{fix});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter, PsiExpression expression, PsiType parameterType, PsiType itemType, boolean checkAssignability, @NotNull LocalQuickFix[] quickFixes) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "checkRawToGenericsAssignment"));
            }
            if (quickFixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor", "checkRawToGenericsAssignment"));
            }
            if (parameterType == null || itemType == null) {
                return;
            }
            if (checkAssignability && !TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric((PsiType)parameterType, (PsiType)itemType)) {
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(parameterType));
                this.registerProblem(description, (PsiElement)expression, parameter, quickFixes);
            }
        }

        public void visitMethod(PsiMethod method2) {
            List superMethodSignatures;
            super.visitMethod(method2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method2.isConstructor() || (superMethodSignatures = method2.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method2.hasModifierProperty("static"))) {
                MethodSignature signature = method2.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod superSignature : superMethodSignatures) {
                    PsiMethod baseMethod = superSignature.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
                    if (substitutor == null) {
                        substitutor = superSignature.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method2.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric((PsiType)baseReturnType, (PsiType)overriderReturnType)) continue;
                    String message = JavaErrorMessages.message("unchecked.overriding.incompatible.return.type", JavaHighlightUtil.formatType(overriderReturnType), JavaHighlightUtil.formatType(baseReturnType));
                    PsiTypeElement returnTypeElement = method2.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message, null, (PsiElement)returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            PsiType valueType;
            PsiExpression returnValue;
            super.visitReturnStatement(statement2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType returnType = null;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (psiElement instanceof PsiMethod) {
                returnType = ((PsiMethod)psiElement).getReturnType();
            } else if (psiElement instanceof PsiLambdaExpression) {
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)psiElement));
            }
            if (returnType != null && !PsiType.VOID.equals((Object)returnType) && (returnValue = statement2.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                LocalQuickFix[] localQuickFixArray;
                if (psiElement instanceof PsiMethod) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = QuickFixFactory.getInstance().createMethodReturnFix((PsiMethod)psiElement, valueType, true);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                this.checkRawToGenericsAssignment((PsiElement)returnValue, returnValue, returnType, valueType, false, fixes);
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
            PsiType type;
            PsiType interfaceReturnType;
            super.visitLambdaExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement body = expression.getBody();
            if (body instanceof PsiExpression && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression)) != null && !PsiType.VOID.equals((Object)interfaceReturnType) && (type = ((PsiExpression)body).getType()) != null) {
                this.checkRawToGenericsAssignment(body, (PsiExpression)body, interfaceReturnType, type, false, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Nullable
        private String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiParameter[] parameters;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            final PsiMethod method2 = (PsiMethod)element;
            final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method2, (PsiSubstitutor)substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method2)) {
                        PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric((PsiType)substitutor.substitute((PsiType)classType), (PsiType)subst)) continue;
                            return JavaErrorMessages.message("generics.unchecked.call", JavaHighlightUtil.formatMethod(method2));
                        }
                    }
                }
                return null;
            }
            for (PsiParameter parameter : parameters = method2.getParameterList().getParameters()) {
                PsiType parameterType = parameter.getType();
                if (!((Boolean)parameterType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                        return Boolean.FALSE;
                    }

                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitClassType(PsiClassType classType) {
                        PsiType[] parameters;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass instanceof PsiTypeParameter) {
                            if (((PsiTypeParameter)psiClass).getOwner() == method2) {
                                return Boolean.FALSE;
                            }
                            return substitutor.substitute((PsiTypeParameter)psiClass) == null ? Boolean.TRUE : Boolean.FALSE;
                        }
                        for (PsiType parameter : parameters = classType.getParameters()) {
                            if (!((Boolean)parameter.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }

                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound != null) {
                            return (Boolean)bound.accept((PsiTypeVisitor)this);
                        }
                        return Boolean.TRUE;
                    }

                    public Boolean visitEllipsisType(PsiEllipsisType ellipsisType) {
                        return (Boolean)ellipsisType.getComponentType().accept((PsiTypeVisitor)this);
                    }
                })).booleanValue()) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method2.getProject()).getElementFactory();
                PsiClassType type = elementFactory.createType(method2.getContainingClass(), substitutor);
                return JavaErrorMessages.message("generics.unchecked.call.to.member.of.raw.type", JavaHighlightUtil.formatMethod(method2), JavaHighlightUtil.formatType((PsiType)type));
            }
            return null;
        }
    }
}

