/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IteratorDeclaration {
    @NotNull
    private final PsiLocalVariable myIterator;
    @Nullable
    private final PsiExpression myIterable;
    private final boolean myCollection;

    private IteratorDeclaration(@NotNull PsiLocalVariable iterator, @Nullable PsiExpression iterable, boolean collection) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInspection/util/IteratorDeclaration", "<init>"));
        }
        this.myIterator = iterator;
        this.myIterable = iterable;
        this.myCollection = collection;
    }

    @NotNull
    public PsiLocalVariable getIterator() {
        PsiLocalVariable psiLocalVariable = this.myIterator;
        if (psiLocalVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/IteratorDeclaration", "getIterator"));
        }
        return psiLocalVariable;
    }

    @Nullable
    public PsiExpression getIterable() {
        return this.myIterable;
    }

    public boolean isCollection() {
        return this.myCollection;
    }

    public boolean isHasNextCall(PsiExpression condition) {
        return this.isIteratorMethodCall((PsiElement)condition, "hasNext");
    }

    @Nullable
    public PsiElement findOnlyIteratorRef(PsiExpression parent) {
        PsiCodeBlock block;
        PsiElement element = PsiUtil.getVariableCodeBlock((PsiVariable)this.myIterator, null);
        PsiCodeBlock psiCodeBlock = block = element instanceof PsiCodeBlock ? (PsiCodeBlock)element : (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        if (block == null) {
            return null;
        }
        return ((Optional)((StreamEx)StreamEx.of((Object[])DefUseUtil.getRefs(block, (PsiVariable)this.myIterator, (PsiElement)this.myIterator.getInitializer())).filter(e -> PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)e, (boolean)false))).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    public boolean isIteratorMethodCall(PsiElement candidate, String method2) {
        if (!(candidate instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)candidate;
        if (call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiReferenceExpression expression = call.getMethodExpression();
        return method2.equals(expression.getReferenceName()) && ExpressionUtils.isReferenceTo(expression.getQualifierExpression(), (PsiVariable)this.myIterator);
    }

    public PsiVariable getNextElementVariable(PsiStatement statement2) {
        if (!(statement2 instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement2;
        if (declaration.getDeclaredElements().length != 1) {
            return null;
        }
        PsiElement element = declaration.getDeclaredElements()[0];
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        if (!this.isIteratorMethodCall((PsiElement)var.getInitializer(), "next")) {
            return null;
        }
        return var;
    }

    @Contract(value="null -> null")
    private static IteratorDeclaration extract(PsiStatement statement2) {
        if (!(statement2 instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement2;
        if (declaration.getDeclaredElements().length != 1) {
            return null;
        }
        PsiElement element = declaration.getDeclaredElements()[0];
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)element;
        PsiExpression initializer = variable.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)initializer;
        if (call.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!"iterator".equals(methodExpression.getReferenceName())) {
            return null;
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null || !InheritanceUtil.isInheritor((PsiClass)method2.getContainingClass(), (String)"java.lang.Iterable")) {
            return null;
        }
        boolean isCollection = InheritanceUtil.isInheritor((PsiClass)method2.getContainingClass(), (String)"java.util.Collection");
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType) || !((PsiClassType)type).rawType().equalsToText("java.util.Iterator")) {
            return null;
        }
        return new IteratorDeclaration(variable, methodExpression.getQualifierExpression(), isCollection);
    }

    @Nullable
    private static IteratorDeclaration fromForLoop(PsiForStatement statement2) {
        if (statement2.getUpdate() != null) {
            return null;
        }
        PsiStatement initialization = statement2.getInitialization();
        IteratorDeclaration declaration = IteratorDeclaration.extract(initialization);
        if (declaration == null || !declaration.isHasNextCall(statement2.getCondition())) {
            return null;
        }
        return declaration;
    }

    @Nullable
    private static IteratorDeclaration fromWhileLoop(PsiWhileStatement statement2) {
        PsiElement previous = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        if (!(previous instanceof PsiDeclarationStatement)) {
            return null;
        }
        IteratorDeclaration declaration = IteratorDeclaration.extract((PsiStatement)previous);
        if (declaration == null || !declaration.isHasNextCall(statement2.getCondition())) {
            return null;
        }
        if (!ReferencesSearch.search((PsiElement)declaration.myIterator, (SearchScope)declaration.myIterator.getUseScope()).forEach(ref -> PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)ref.getElement(), (boolean)true))) {
            return null;
        }
        return declaration;
    }

    @Contract(value="null -> null")
    public static IteratorDeclaration fromLoop(PsiLoopStatement statement2) {
        if (statement2 instanceof PsiWhileStatement) {
            return IteratorDeclaration.fromWhileLoop((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiForStatement) {
            return IteratorDeclaration.fromForLoop((PsiForStatement)statement2);
        }
        return null;
    }
}

