/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import java.util.Collection;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

enum CompilerHierarchySearchType {
    DIRECT_INHERITOR{

        @Override
        PsiElement[] performSearchInFile(Object[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file2, LanguageLightRefAdapter adapter) {
            return adapter.findDirectInheritorCandidatesInFile((String[])definitions, file2, baseElement);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter adapter) {
            return adapter.getHierarchyObjectClass();
        }

        @Override
        Object[] convertToIds(Collection<LightRef> lightRef, NameEnumerator nameEnumerator) {
            return lightRef.stream().map(r -> nameEnumerator.getName(((LightRef.LightClassHierarchyElementDef)r).getName())).toArray(String[]::new);
        }
    }
    ,
    FUNCTIONAL_EXPRESSION{

        @Override
        PsiElement[] performSearchInFile(Object[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file2, LanguageLightRefAdapter adapter) {
            return adapter.findFunExpressionsInFile((Integer[])definitions, file2);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter adapter) {
            return adapter.getFunExprClass();
        }

        @Override
        Object[] convertToIds(Collection<LightRef> lightRef, NameEnumerator nameEnumerator) {
            return lightRef.stream().map(r -> ((LightRef.LightFunExprDef)r).getId()).toArray(Integer[]::new);
        }
    };


    abstract PsiElement[] performSearchInFile(Object[] var1, PsiNamedElement var2, PsiFileWithStubSupport var3, LanguageLightRefAdapter var4);

    abstract Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter var1);

    abstract Object[] convertToIds(Collection<LightRef> var1, NameEnumerator var2);
}

