/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;

@Tag(value="instance-filter")
public class InstanceFilter
implements JDOMExternalizable {
    public static final InstanceFilter[] EMPTY_ARRAY = new InstanceFilter[0];
    @Attribute(value="id")
    public long ID = 0L;
    @Attribute(value="enabled")
    public boolean ENABLED = true;

    public InstanceFilter() {
    }

    protected InstanceFilter(long ID2, boolean ENABLED) {
        this.ID = ID2;
        this.ENABLED = ENABLED;
    }

    @Transient
    public long getId() {
        return this.ID;
    }

    @Transient
    public boolean isEnabled() {
        return this.ENABLED;
    }

    public void setId(long id) {
        this.ID = id;
    }

    public void setEnabled(boolean enabled) {
        this.ENABLED = enabled;
    }

    public static InstanceFilter create(String pattern) {
        return new InstanceFilter(Long.parseLong(pattern), true);
    }

    public static InstanceFilter create(ClassFilter filter) {
        return new InstanceFilter(Long.parseLong(filter.getPattern()), filter.isEnabled());
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public static ClassFilter[] createClassFilters(InstanceFilter[] filters) {
        ClassFilter[] cFilters = new ClassFilter[filters.length];
        for (int i2 = 0; i2 < cFilters.length; ++i2) {
            InstanceFilter instanceFilter = filters[i2];
            ClassFilter classFilter = new ClassFilter();
            classFilter.setEnabled(instanceFilter.isEnabled());
            classFilter.setPattern(Long.toString(instanceFilter.getId()));
            cFilters[i2] = classFilter;
        }
        return cFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceFilter filter = (InstanceFilter)o;
        if (this.ID != filter.ID) {
            return false;
        }
        return this.ENABLED == filter.ENABLED;
    }

    public int hashCode() {
        int result2 = (int)(this.ID ^ this.ID >>> 32);
        result2 = 31 * result2 + (this.ENABLED ? 1 : 0);
        return result2;
    }
}

