/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.RegistryToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import org.jetbrains.annotations.NotNull;

public class ShowTypesAction
extends RegistryToggleAction {
    public ShowTypesAction() {
        super("debugger.showTypes");
    }

    @Override
    public void doWhenDone(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            XDebugSession session2;
            XDebuggerTree tree;
            if (DebuggerUIUtil.isInDetachedTree(e) && (tree = XDebuggerTree.getTree(e)) != null) {
                tree.rebuildAndRestore(XDebuggerTreeState.saveState(tree));
            }
            if ((session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
                session2.rebuildViews();
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session2;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/ShowTypesAction", "update"));
        }
        Project project2 = e.getProject();
        if (project2 != null && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && session2.getDebugProcess() instanceof JavaDebugProcess) {
            e.getPresentation().setEnabledAndVisible(true);
            super.update(e);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }
}

