/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collections;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;

    public BoxingEvaluator(Evaluator operand) {
        this.myOperand = new DisableGC(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        PrimitiveValue primitiveValue;
        PsiPrimitiveType primitiveType;
        Object result2 = this.myOperand.evaluate(context);
        if (result2 == null || result2 instanceof ObjectReference) {
            return result2;
        }
        if (result2 instanceof PrimitiveValue && (primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((primitiveValue = (PrimitiveValue)result2).type().name())) != null) {
            return BoxingEvaluator.convertToWrapper(context, primitiveValue, primitiveType.getBoxedTypeName());
        }
        throw new EvaluateException("Cannot perform boxing conversion for a value of type " + ((Value)result2).type().name());
    }

    private static Value convertToWrapper(EvaluationContextImpl context, PrimitiveValue value, String wrapperTypeName) throws EvaluateException {
        String methodSignature;
        DebugProcessImpl process2 = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)process2.findClass(context, wrapperTypeName, null);
        Method method2 = wrapperClass.concreteMethodByName("valueOf", methodSignature = "(" + JVMNameUtil.getPrimitiveSignature(value.type().name()) + ")L" + wrapperTypeName.replace('.', '/') + ";");
        if (method2 == null) {
            method2 = wrapperClass.concreteMethodByName("<init>", methodSignature);
        }
        if (method2 == null) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + value.type() + ": Unable to find either valueOf() or constructor method");
        }
        return process2.invokeMethod((EvaluationContext)context, wrapperClass, method2, Collections.singletonList(value));
    }
}

