/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ReferenceType;

public class ShowInstancesFromClassesViewAction
extends ShowInstancesAction {
    private static final String POPUP_ELEMENT_LABEL = "Show Instances";

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && this.getSelectedClass(e) != null;
    }

    @Override
    protected void perform(AnActionEvent e) {
        XDebugSession debugSession;
        Project project2 = e.getProject();
        ReferenceType selectedClass = this.getSelectedClass(e);
        if (project2 != null && selectedClass != null && (debugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            new InstancesWindow(debugSession, limit -> selectedClass.instances(limit), selectedClass.name()).show();
        }
    }

    @Override
    protected String getLabel() {
        return POPUP_ELEMENT_LABEL;
    }

    @Override
    protected int getInstancesCount(AnActionEvent e) {
        ClassesTable.ReferenceCountProvider countProvider = (ClassesTable.ReferenceCountProvider)e.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        ReferenceType selectedClass = this.getSelectedClass(e);
        if (countProvider == null || selectedClass == null) {
            return -1;
        }
        return countProvider.getTotalCount(selectedClass);
    }
}

