/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")})
public class MemoryViewManager
extends ApplicationComponent.Adapter
implements PersistentStateComponent<MemoryViewManagerState> {
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return (MemoryViewManager)((Object)ApplicationManager.getApplication().getComponent(MemoryViewManager.class));
    }

    @NotNull
    public MemoryViewManagerState getState() {
        MemoryViewManagerState memoryViewManagerState = new MemoryViewManagerState(this.myState);
        if (memoryViewManagerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/component/MemoryViewManager", "getState"));
        }
        return memoryViewManagerState;
    }

    public void loadState(MemoryViewManagerState state) {
        if (state == null) {
            state = new MemoryViewManagerState();
        }
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value) {
        if (this.myState.isShowWithDiffOnly != value) {
            this.myState.isShowWithDiffOnly = value;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value) {
        if (this.myState.isShowWithInstancesOnly != value) {
            this.myState.isShowWithInstancesOnly = value;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value) {
        if (this.myState.isShowTrackedOnly != value) {
            this.myState.isShowTrackedOnly = value;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/memory/component/MemoryViewManager", "addMemoryViewManagerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Nullable
    public ToolWindow getToolWindow(Project project2) {
        return ToolWindowManager.getInstance((Project)project2).getToolWindow("Memory View");
    }

    private void fireStateChanged() {
        ((MemoryViewManagerListener)this.myDispatcher.getMulticaster()).stateChanged(new MemoryViewManagerState(this.myState));
    }
}

