/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.toolwindow;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.awt.BorderLayout;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryViewToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    private static final Logger LOG = Logger.getInstance(ClassesFilteredView.class);
    public static final String TOOL_WINDOW_ID = "Memory View";
    private final JComponent myEmptyContent;
    private final JComponent myMemoryViewNotSupportedContent;
    private final EventDispatcher<ToolWindowStateListener> myDispatcher = EventDispatcher.create(ToolWindowStateListener.class);
    private volatile boolean myIsToolWindowVisible;

    public MemoryViewToolWindowFactory() {
        this.myEmptyContent = new JBLabel("Run debugging to see loaded classes", 0);
        this.myMemoryViewNotSupportedContent = new JBLabel("The Memory View not available for this session", 0);
    }

    public void createToolWindowContent(final @NotNull Project project2, final @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "createToolWindowContent"));
        }
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(XDebuggerManager.TOPIC, (Object)new MyDebuggerStatusChangedListener());
        connection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "contentSelected"));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "lambda$contentSelected$0"));
                    }
                    if (toolWindow == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "lambda$contentSelected$0"));
                    }
                    MemoryViewToolWindowFactory.this.updateCurrentMemoryView(project2, toolWindow);
                });
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "contentRemoved"));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "lambda$contentRemoved$1"));
                    }
                    if (toolWindow == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$1", "lambda$contentRemoved$1"));
                    }
                    MemoryViewToolWindowFactory.this.updateCurrentMemoryView(project2, toolWindow);
                });
            }
        });
        ((ToolWindowImpl)toolWindow).getToolWindowManager().addToolWindowManagerListener(new ToolWindowManagerAdapter(){

            @Override
            public void stateChanged() {
                boolean isVisible = toolWindow.isVisible();
                if (isVisible != MemoryViewToolWindowFactory.this.myIsToolWindowVisible) {
                    ((ToolWindowStateListener)MemoryViewToolWindowFactory.this.myDispatcher.getMulticaster()).visibilityChanged(isVisible);
                    MemoryViewToolWindowFactory.this.myIsToolWindowVisible = isVisible;
                }
            }
        }, (Disposable)project2);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        ((ToolWindowEx)toolWindow).setAdditionalGearActions(group);
        toolWindow.getComponent().setLayout(new BorderLayout());
        for (XDebugSession session2 : XDebuggerManager.getInstance((Project)project2).getDebugSessions()) {
            this.registerMemoryView(session2);
        }
        this.updateCurrentMemoryView(project2, toolWindow);
    }

    private void registerMemoryView(@NotNull XDebugSession session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "registerMemoryView"));
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        XDebugProcess debugProcess = session2.getDebugProcess();
        Project project2 = session2.getProject();
        DebugProcess javaProcess = DebuggerManager.getInstance((Project)session2.getProject()).getDebugProcess(debugProcess.getProcessHandler());
        if (javaProcess instanceof DebugProcessImpl) {
            DebugProcessImpl processImpl = (DebugProcessImpl)javaProcess;
            ClassesFilteredView classesFilteredView = new ClassesFilteredView(debugProcess.getSession());
            this.myDispatcher.addListener(visible -> classesFilteredView.setActive(visible), (Disposable)classesFilteredView);
            MemoryViewDebugProcessData data = new MemoryViewDebugProcessData(classesFilteredView);
            ToolWindow toolWindow = MemoryViewToolWindowFactory.getToolWindow(processImpl.getProject());
            classesFilteredView.setActive(toolWindow != null && toolWindow.isVisible());
            processImpl.putUserData(MemoryViewDebugProcessData.KEY, data);
            if (toolWindow != null) {
                this.updateCurrentMemoryView(project2, toolWindow);
            }
        }
    }

    private void updateCurrentMemoryView(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        XDebugSession session2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "updateCurrentMemoryView"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "updateCurrentMemoryView"));
        }
        Object component = this.myEmptyContent;
        if (!project2.isDisposed() && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            DebugProcess debugProcess = DebuggerManager.getInstance((Project)project2).getDebugProcess(session2.getDebugProcess().getProcessHandler());
            MemoryViewDebugProcessData data = debugProcess != null ? (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY) : null;
            component = data != null ? data.getClassesFilteredView() : this.myMemoryViewNotSupportedContent;
        }
        MemoryViewToolWindowFactory.replaceToolWindowContent(toolWindow, component);
    }

    private static void replaceToolWindowContent(@NotNull ToolWindow toolWindow, JComponent comp) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "replaceToolWindowContent"));
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        JComponent toolWindowComp = toolWindow.getComponent();
        toolWindowComp.removeAll();
        toolWindowComp.add(comp);
        toolWindowComp.repaint();
    }

    @Nullable
    private static ToolWindow getToolWindow(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory", "getToolWindow"));
        }
        return MemoryViewManager.getInstance().getToolWindow(project2);
    }

    private static interface ToolWindowStateListener
    extends EventListener {
        public void visibilityChanged(boolean var1);
    }

    private final class MyDebuggerStatusChangedListener
    implements XDebuggerManagerListener {
        private MyDebuggerStatusChangedListener() {
        }

        public void processStarted(@NotNull XDebugProcess xDebugProcess) {
            if (xDebugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xDebugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$MyDebuggerStatusChangedListener", "processStarted"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (xDebugProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xDebugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$MyDebuggerStatusChangedListener", "lambda$processStarted$0"));
                }
                MemoryViewToolWindowFactory.this.registerMemoryView(xDebugProcess.getSession());
            });
        }

        public void processStopped(@NotNull XDebugProcess xDebugProcess) {
            DebugProcessImpl process2;
            MemoryViewDebugProcessData data;
            if (xDebugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xDebugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$MyDebuggerStatusChangedListener", "processStopped"));
            }
            XDebugSession session2 = xDebugProcess.getSession();
            if (xDebugProcess instanceof JavaDebugProcess && (data = (MemoryViewDebugProcessData)(process2 = ((JavaDebugProcess)xDebugProcess).getDebuggerSession().getProcess()).getUserData(MemoryViewDebugProcessData.KEY)) != null) {
                data.getTrackedStacks().release();
                Disposer.dispose((Disposable)data.getClassesFilteredView());
            }
            ApplicationManager.getApplication().invokeLater(() -> this.updateView(session2));
        }

        private void updateView(@NotNull XDebugSession debugSession) {
            ToolWindow toolWindow;
            if (debugSession == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$MyDebuggerStatusChangedListener", "updateView"));
            }
            Project project2 = debugSession.getProject();
            if (!project2.isDisposed() && (toolWindow = MemoryViewToolWindowFactory.getToolWindow(project2)) != null) {
                MemoryViewToolWindowFactory.this.updateCurrentMemoryView(project2, toolWindow);
            }
        }
    }

    public static class Condition
    implements com.intellij.openapi.util.Condition<Project> {
        public boolean value(Project project2) {
            MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
            connection.subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

                public void processStarted(@NotNull XDebugProcess debugProcess) {
                    if (debugProcess == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$Condition$1", "processStarted"));
                    }
                    this.updateIcon(debugProcess.getSession().getProject(), true);
                }

                public void processStopped(@NotNull XDebugProcess debugProcess) {
                    if (debugProcess == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$Condition$1", "processStopped"));
                    }
                    Project project2 = debugProcess.getSession().getProject();
                    boolean enabled = Arrays.stream(XDebuggerManager.getInstance((Project)project2).getDebugSessions()).anyMatch(session2 -> {
                        if (debugProcess == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$Condition$1", "lambda$processStopped$0"));
                        }
                        return !session2.getDebugProcess().equals(debugProcess);
                    });
                    this.updateIcon(project2, enabled);
                }

                private void updateIcon(@NotNull Project project2, boolean enabled) {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/toolwindow/MemoryViewToolWindowFactory$Condition$1", "updateIcon"));
                    }
                    ToolWindow toolWindow = MemoryViewManager.getInstance().getToolWindow(project2);
                    if (toolWindow != null) {
                        Icon icon = enabled ? AllIcons.Debugger.MemoryView.ToolWindowEnabled : AllIcons.Debugger.MemoryView.ToolWindowDisabled;
                        ApplicationManager.getApplication().invokeLater(() -> toolWindow.setIcon(icon));
                    }
                }
            });
            return true;
        }
    }
}

