/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import org.jetbrains.annotations.NotNull;

public abstract class ClassPreparedListener {
    protected ClassPreparedListener(@NotNull String className, @NotNull XDebugSession debugSession) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/tracking/ClassPreparedListener", "<init>"));
        }
        if (debugSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/intellij/debugger/memory/tracking/ClassPreparedListener", "<init>"));
        }
        DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)debugSession.getProject()).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
        MyClassPreparedRequest request = new MyClassPreparedRequest();
        ClassPrepareRequest classPrepareRequest = debugProcess.getRequestsManager().createClassPrepareRequest(request, className);
        if (classPrepareRequest != null) {
            classPrepareRequest.enable();
        }
    }

    public abstract void onClassPrepared(@NotNull ReferenceType var1);

    private final class MyClassPreparedRequest
    implements ClassPrepareRequestor {
        private MyClassPreparedRequest() {
        }

        public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
            if (debuggerProcess instanceof DebugProcessImpl) {
                ((DebugProcessImpl)debuggerProcess).getRequestsManager().deleteRequest((Requestor)this);
                ClassPreparedListener.this.onClassPrepared(referenceType);
            }
        }
    }
}

