/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.debugger.memory.tracking.ClassPreparedListener;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.KeyboardUtils;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.memory.utils.SingleAlarmWithMutableDelay;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.SmartList;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends BorderLayoutPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClassesFilteredView.class);
    private static final double DELAY_BEFORE_INSTANCES_QUERY_COEFFICIENT = 0.5;
    private static final double MAX_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    private static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final String EMPTY_TABLE_CONTENT_WHEN_RUNNING = "The application is running";
    private static final String EMPTY_TABLE_CONTENT_WHEN_SUSPENDED = "Nothing to show";
    private final Project myProject;
    private final SingleAlarmWithMutableDelay mySingleAlarm;
    private final SearchTextField myFilterTextField;
    private final ClassesTable myTable;
    private final InstancesTracker myInstancesTracker;
    private final Map<ReferenceType, ConstructorInstancesTracker> myConstructorTrackedClasses;
    private final MyDebuggerSessionListener myDebugSessionListener;
    @Nullable
    private volatile SuspendContextImpl myLastSuspendContext;
    private final AtomicBoolean myIsTrackersActivated;
    private boolean myIsActive;

    public ClassesFilteredView(final @NotNull XDebugSession debugSession) {
        if (debugSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/intellij/debugger/memory/ui/ClassesFilteredView", "<init>"));
        }
        this.myFilterTextField = new FilterTextField();
        this.myConstructorTrackedClasses = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
        this.myIsTrackersActivated = new AtomicBoolean(false);
        this.myProject = debugSession.getProject();
        final DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
        if (debugProcess == null) {
            throw new NullPointerException("Failed to receive a java debug process");
        }
        this.myInstancesTracker = InstancesTracker.getInstance(this.myProject);
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            @Override
            public void classChanged(@NotNull String name, final @NotNull TrackingType type) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/ui/ClassesFilteredView$1", "classChanged"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/memory/ui/ClassesFilteredView$1", "classChanged"));
                }
                final ReferenceType ref = ClassesFilteredView.this.myTable.getClassByName(name);
                if (ref != null) {
                    final boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                    debugProcess.getManagerThread().schedule(new LowestPriorityCommand(ClassesFilteredView.this.getSuspendContext()){

                        @Override
                        public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                            if (suspendContext == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/ClassesFilteredView$1$1", "contextAction"));
                            }
                            ClassesFilteredView.this.trackClass(ref, type, activated);
                        }
                    });
                }
                ClassesFilteredView.this.myTable.repaint();
            }

            @Override
            public void classRemoved(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/ui/ClassesFilteredView$1", "classRemoved"));
                }
                ReferenceType ref = ClassesFilteredView.this.myTable.getClassByName(name);
                if (ref != null && ClassesFilteredView.this.myConstructorTrackedClasses.containsKey(ref)) {
                    ConstructorInstancesTracker removed = (ConstructorInstancesTracker)ClassesFilteredView.this.myConstructorTrackedClasses.remove(ref);
                    Disposer.dispose((Disposable)removed);
                    ClassesFilteredView.this.myTable.getRowSorter().allRowsChanged();
                }
            }
        };
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOWEST;
            }

            @Override
            protected void action() throws Exception {
                boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                for (Map.Entry<String, TrackingType> entry : ClassesFilteredView.this.myInstancesTracker.getTrackedClasses().entrySet()) {
                    final TrackingType type = entry.getValue();
                    String className = entry.getKey();
                    List<ReferenceType> classes = debugProcess.getVirtualMachineProxy().classesByName(className);
                    if (classes.isEmpty()) {
                        new ClassPreparedListener(className, debugSession){

                            @Override
                            public void onClassPrepared(@NotNull ReferenceType referenceType) {
                                if (referenceType == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceType", "com/intellij/debugger/memory/ui/ClassesFilteredView$2$1", "onClassPrepared"));
                                }
                                ClassesFilteredView.this.trackClass(referenceType, type, ClassesFilteredView.this.myIsTrackersActivated.get());
                            }
                        };
                        continue;
                    }
                    for (ReferenceType ref : classes) {
                        ClassesFilteredView.this.trackClass(ref, type, activated);
                    }
                }
                ClassesFilteredView.this.myInstancesTracker.addTrackerListener(instancesTrackerListener, ClassesFilteredView.this);
            }
        });
        MemoryViewManagerState memoryViewManagerState = MemoryViewManager.getInstance().getState();
        this.myTable = new ClassesTable(debugSession, memoryViewManagerState.isShowWithDiffOnly, memoryViewManagerState.isShowWithInstancesOnly, memoryViewManagerState.isShowTrackedOnly, this);
        this.myTable.getEmptyText().setText(EMPTY_TABLE_CONTENT_WHEN_RUNNING);
        Disposer.register((Disposable)this, (Disposable)this.myTable);
        this.myTable.addMouseMotionListener(new MyMouseMotionListener());
        this.myTable.addMouseListener(new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.myTable));
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isBackSpace(keyCode)) {
                    String text = ClassesFilteredView.this.myFilterTextField.getText();
                    String newText = KeyboardUtils.isBackSpace(keyCode) ? text.substring(0, text.length() - 1) : text + e.getKeyChar();
                    ClassesFilteredView.this.myFilterTextField.setText(newText);
                    FocusManager.getCurrentManager().focusNextComponent((Component)ClassesFilteredView.this.myFilterTextField);
                }
            }
        });
        this.myFilterTextField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                if (KeyboardUtils.isUpDownKey(e.getKeyCode()) || KeyboardUtils.isEnterKey(e.getKeyCode())) {
                    ClassesFilteredView.this.myTable.dispatchEvent(e);
                }
            }
        });
        this.myFilterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ClassesFilteredView.this.myTable.setFilterPattern(ClassesFilteredView.this.myFilterTextField.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = state -> {
            this.myTable.setFilteringByDiffNonZero(state.isShowWithDiffOnly);
            this.myTable.setFilteringByInstanceExists(state.isShowWithInstancesOnly);
            this.myTable.setFilteringByTrackingState(state.isShowTrackedOnly);
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.myDebugSessionListener = new MyDebuggerSessionListener();
        debugSession.addSessionListener((XDebugSessionListener)this.myDebugSessionListener, (Disposable)this);
        this.mySingleAlarm = new SingleAlarmWithMutableDelay(() -> {
            this.myLastSuspendContext = this.getSuspendContext();
            if (this.myLastSuspendContext != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myTable.setBusy(true));
                debugProcess.getManagerThread().schedule(new MyUpdateClassesCommand(this.myLastSuspendContext));
            }
        }, this);
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu menu = ClassesFilteredView.createContextMenu();
                if (menu != null) {
                    menu.getComponent().show(comp, x, y);
                }
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)2);
        this.addToTop((Component)this.myFilterTextField);
        this.addToCenter(scroll);
    }

    @Nullable
    TrackerForNewInstances getStrategy(@NotNull ReferenceType ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/ui/ClassesFilteredView", "getStrategy"));
        }
        return this.myConstructorTrackedClasses.getOrDefault(ref, null);
    }

    private void trackClass(@NotNull ReferenceType ref, @NotNull TrackingType type, boolean isTrackerEnabled) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/ui/ClassesFilteredView", "trackClass"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/memory/ui/ClassesFilteredView", "trackClass"));
        }
        LOG.assertTrue(DebuggerManager.getInstance((Project)this.myProject).isDebuggerManagerThread());
        if (type == TrackingType.CREATION) {
            XDebugSession debugSession;
            ConstructorInstancesTracker old = this.myConstructorTrackedClasses.getOrDefault(ref, null);
            if (old != null) {
                Disposer.dispose((Disposable)old);
            }
            if ((debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession()) == null) {
                return;
            }
            ConstructorInstancesTracker tracker = new ConstructorInstancesTracker(ref, debugSession);
            tracker.setBackgroundMode(!this.myIsActive);
            if (isTrackerEnabled) {
                tracker.enable();
            } else {
                tracker.disable();
            }
            Disposer.register((Disposable)this, (Disposable)tracker);
            this.myConstructorTrackedClasses.put(ref, tracker);
        }
    }

    private void handleClassSelection(@Nullable ReferenceType ref) {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (ref != null && debugSession != null && debugSession.isSuspended()) {
            new InstancesWindow(debugSession, limit -> ref.instances(limit), ref.name()).show();
        }
    }

    private void commitAllTrackers() {
        this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private SuspendContextImpl getSuspendContext() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContext().getSuspendContext();
    }

    private void updateClassesAndCounts() {
        DebugProcess debugProcess;
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (debugSession != null && (debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler())).isAttached()) {
            this.mySingleAlarm.cancelAndRequest();
        }
    }

    private static ActionPopupMenu createContextMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", group);
    }

    public void dispose() {
        this.myLastSuspendContext = null;
        this.myConstructorTrackedClasses.clear();
    }

    public void setActive(final boolean active) {
        if (this.myIsActive == active) {
            return;
        }
        this.myIsActive = active;
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (debugSession != null) {
            DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
            debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    if (active) {
                        ClassesFilteredView.this.doActivate();
                    } else {
                        ClassesFilteredView.this.doPause();
                    }
                }
            });
        }
    }

    private void doActivate() {
        this.myDebugSessionListener.setActive(true);
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(false));
        SuspendContextImpl lastContext = this.myLastSuspendContext;
        if (lastContext == null || !((Object)((Object)lastContext)).equals((Object)this.getSuspendContext())) {
            this.updateClassesAndCounts();
        }
    }

    private void doPause() {
        this.myDebugSessionListener.setActive(false);
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(true));
    }

    private boolean isShowNewInstancesEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/memory/ui/ClassesFilteredView", "isShowNewInstancesEvent"));
        }
        int col = this.myTable.columnAtPoint(e.getPoint());
        int row = this.myTable.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1 || this.myTable.convertColumnIndexToModel(col) != 2) {
            return false;
        }
        int modelRow = this.myTable.convertRowIndexToModel(row);
        ReferenceType ref = (ReferenceType)this.myTable.getModel().getValueAt(modelRow, 0);
        ConstructorInstancesTracker tracker = this.myConstructorTrackedClasses.getOrDefault(ref, null);
        return tracker != null && tracker.isReady() && tracker.getCount() > 0;
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean myIsActive = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean value) {
            this.myIsActive = value;
        }

        public void sessionResumed() {
            if (this.myIsActive) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::obsolete);
                ApplicationManager.getApplication().invokeLater(() -> {
                    ClassesFilteredView.this.myTable.getEmptyText().setText(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_RUNNING);
                    ClassesFilteredView.this.myTable.hideContent();
                });
                ClassesFilteredView.this.mySingleAlarm.cancelAllRequests();
            }
        }

        public void sessionPaused() {
            if (this.myIsActive) {
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.getEmptyText().setText(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_SUSPENDED));
                ClassesFilteredView.this.updateClassesAndCounts();
            }
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            if (!ClassesFilteredView.this.isShowNewInstancesEvent(event)) {
                ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1 || e.getButton() != 1 || !ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                return;
            }
            ReferenceType ref = ClassesFilteredView.this.myTable.getSelectedClass();
            TrackerForNewInstances strategy = ref == null ? null : ClassesFilteredView.this.getStrategy(ref);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getCurrentSession();
            if (strategy != null && debugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (data != null) {
                    List<ObjectReference> newInstances = strategy.getNewInstances();
                    data.getTrackedStacks().pinStacks(ref);
                    InstancesWindow instancesWindow = new InstancesWindow(debugSession, limit -> newInstances, ref.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> data.getTrackedStacks().unpinStacks(ref));
                    instancesWindow.show();
                } else {
                    LOG.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
            if (suspendContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/ClassesFilteredView$MyUpdateClassesCommand", "contextAction"));
            }
            if (!ClassesFilteredView.this.myIsTrackersActivated.get()) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.myIsTrackersActivated.set(true);
            } else {
                ClassesFilteredView.this.commitAllTrackers();
            }
            List<ReferenceType> classes = suspendContext.getDebugProcess().getVirtualMachineProxy().allClasses();
            if (classes.isEmpty()) {
                return;
            }
            VirtualMachine vm = classes.get(0).virtualMachine();
            int batchSize = AndroidUtil.isAndroidVM(vm) ? 500 : Integer.MAX_VALUE;
            SmartList chunks = new SmartList();
            int size = classes.size();
            int begin = 0;
            int end = Math.min(batchSize, size);
            while (begin != size && this.isContextValid()) {
                List<ReferenceType> batch = classes.subList(begin, end);
                long start = System.nanoTime();
                long[] counts = vm.instanceCounts(batch);
                long delay = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                chunks.add(counts);
                int waitTime = (int)Math.min(0.5 * (double)delay, MAX_DELAY_MILLIS);
                ClassesFilteredView.this.mySingleAlarm.setDelay(waitTime);
                LOG.info(String.format("Instances query time = %d ms. Count = %d", delay, batch.size()));
                begin = end;
                end = Math.min(end + batchSize, size);
            }
            if (this.isContextValid()) {
                long[] counts = chunks.size() == 1 ? (long[])chunks.get(0) : IntStream.range(0, chunks.size()).boxed().flatMapToLong(arg_0 -> MyUpdateClassesCommand.lambda$contextAction$0((List)chunks, arg_0)).toArray();
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.setClassesAndUpdateCounts(classes, counts));
            }
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.setBusy(false));
        }

        private boolean isContextValid() {
            return ClassesFilteredView.this.getSuspendContext() == this.getSuspendContext();
        }

        private static /* synthetic */ LongStream lambda$contextAction$0(List chunks, Integer integer) {
            return Arrays.stream((long[])chunks.get(integer));
        }
    }
}

