/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class SingleAlarmWithMutableDelay
extends Alarm {
    private final Runnable myTask;
    private volatile int myDelay;

    public SingleAlarmWithMutableDelay(@NotNull Runnable task, @NotNull Disposable parentDisposable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/memory/utils/SingleAlarmWithMutableDelay", "<init>"));
        }
        super(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.myTask = task;
    }

    public void setDelay(int value) {
        this.myDelay = value;
    }

    public void cancelAndRequest() {
        if (!this.isDisposed()) {
            this.cancelAllRequests();
            this.addRequest(this.myTask, this.myDelay);
        }
    }
}

