/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureConfigurable
implements SearchableConfigurable {
    private MyTableModel myTableModel;

    @NotNull
    public String getId() {
        if ("reference.idesettings.debugger.capture" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CaptureConfigurable", "getId"));
        }
        return "reference.idesettings.debugger.capture";
    }

    @Nullable
    public JComponent createComponent() {
        this.myTableModel = new MyTableModel();
        final JBTable table = new JBTable((TableModel)this.myTableModel);
        table.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = table.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        return ToolbarDecorator.createDecorator((JTable)table).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CaptureConfigurable.this.myTableModel.addRow();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)table);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)table);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)table);
            }
        }).createPanel();
    }

    public boolean isModified() {
        return !DebuggerSettings.getInstance().getCapturePoints().equals(this.myTableModel.myCapturePoints);
    }

    public void apply() throws ConfigurationException {
        DebuggerSettings.getInstance().setCapturePoints(this.myTableModel.myCapturePoints);
    }

    public void reset() {
        this.myTableModel.myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        this.myTableModel.fireTableDataChanged();
    }

    @Nls
    public String getDisplayName() {
        return "Capture";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        public static final int ENABLED_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int PARAM_COLUMN = 3;
        public static final int INSERT_CLASS_COLUMN = 4;
        public static final int INSERT_METHOD_COLUMN = 5;
        public static final int INSERT_KEY_EXPR = 6;
        static final String[] COLUMN_NAMES = new String[]{"", "Class name", "Method name", "Param index", "Insert class name", "Insert method name", "Insert key expression"};
        List<CapturePoint> myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();

        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return this.myCapturePoints.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    return point.myEnabled;
                }
                case 1: {
                    return point.myClassName;
                }
                case 2: {
                    return point.myMethodName;
                }
                case 3: {
                    return point.myParamNo;
                }
                case 4: {
                    return point.myInsertClassName;
                }
                case 5: {
                    return point.myInsertMethodName;
                }
                case 6: {
                    return point.myInsertKeyExpression;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    point.myEnabled = (Boolean)value;
                    break;
                }
                case 1: {
                    point.myClassName = (String)value;
                    break;
                }
                case 2: {
                    point.myMethodName = (String)value;
                    break;
                }
                case 3: {
                    point.myParamNo = (Integer)value;
                    break;
                }
                case 4: {
                    point.myInsertClassName = (String)value;
                    break;
                }
                case 5: {
                    point.myInsertMethodName = (String)value;
                    break;
                }
                case 6: {
                    point.myInsertKeyExpression = (String)value;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 3: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        public void addRow() {
            this.myCapturePoints.add(new CapturePoint());
            int lastRow = this.getRowCount() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
        }

        public void removeRow(int row) {
            if (row >= 0 && row < this.getRowCount()) {
                this.myCapturePoints.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }
    }
}

