/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class StackCapturingLineBreakpoint
extends WildcardMethodBreakpoint {
    private static final Logger LOG = Logger.getInstance(StackCapturingLineBreakpoint.class);
    private final CapturePoint myCapturePoint;
    private final String mySignature;
    private final NullableLazyValue<ExpressionEvaluator> myEvaluator;
    public static final Key<List<StackCapturingLineBreakpoint>> CAPTURE_BREAKPOINTS = Key.create((String)"CAPTURE_BREAKPOINTS");
    public static final Key<Map<ObjectReference, List<StackFrameItem>>> CAPTURED_STACKS = Key.create((String)"CAPTURED_STACKS");
    private static final int MAX_STORED_STACKS = 1000;
    public static final int MAX_STACK_LENGTH = 500;
    private final JavaMethodBreakpointProperties myProperties = new JavaMethodBreakpointProperties();

    public StackCapturingLineBreakpoint(Project project2, CapturePoint capturePoint) {
        super(project2, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.myCapturePoint = capturePoint;
        this.mySignature = null;
        this.myProperties.EMULATED = true;
        this.myProperties.WATCH_EXIT = false;
        this.myProperties.myClassPattern = this.myCapturePoint.myClassName;
        this.myProperties.myMethodName = this.myCapturePoint.myMethodName;
        this.myEvaluator = NullableLazyValue.createValue(() -> (ExpressionEvaluator)ReadAction.compute(() -> {
            try {
                return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.myCapturePoint.myInsertKeyExpression), null, null, project2);
            }
            catch (EvaluateException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }));
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = this.myProperties;
        if (javaMethodBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getProperties"));
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    public String getSuspendPolicy() {
        return "SuspendThread";
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        try {
            StackFrameProxyImpl frameProxy;
            SuspendContextImpl suspendContext = action.getSuspendContext();
            if (suspendContext != null && (frameProxy = suspendContext.getFrameProxy()) != null) {
                Value key2;
                DebugProcessImpl process2 = suspendContext.getDebugProcess();
                Map stacks2 = (Map)process2.getUserData(CAPTURED_STACKS);
                if (stacks2 == null) {
                    stacks2 = new CapturedStacksMap();
                    process2.putUserData(CAPTURED_STACKS, Collections.synchronizedMap(stacks2));
                }
                if ((key2 = (Value)ContainerUtil.getOrElse(frameProxy.getArgumentValues(), (int)this.myCapturePoint.myParamNo, null)) instanceof ObjectReference) {
                    List<StackFrameItem> frames = StackFrameItem.createFrames(suspendContext.getThread(), suspendContext, true);
                    if (frames.size() > 500) {
                        frames = frames.subList(0, 500);
                    }
                    stacks2.put((ObjectReference)key2, frames);
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        String methodName = this.getMethodName();
        return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && (this.mySignature == null || Comparing.equal((String)this.mySignature, (String)m.signature())))).limit(1L);
    }

    public static void recreateAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List bpts = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)bpts)) {
            bpts.forEach(debugProcess.getRequestsManager()::deleteRequest);
            bpts.clear();
        }
        if (Registry.is((String)"debugger.capture.points")) {
            DebuggerSettings.getInstance().getCapturePoints().stream().filter(c -> c.myEnabled).forEach(c -> StackCapturingLineBreakpoint.track(debugProcess, c));
        }
    }

    private static void track(DebugProcessImpl debugProcess, CapturePoint capturePoint) {
        if (StringUtil.isEmpty((String)capturePoint.myClassName)) {
            return;
        }
        StackCapturingLineBreakpoint breakpoint = new StackCapturingLineBreakpoint(debugProcess.getProject(), capturePoint);
        breakpoint.createRequest(debugProcess);
        CopyOnWriteArrayList<StackCapturingLineBreakpoint> bpts = (CopyOnWriteArrayList<StackCapturingLineBreakpoint>)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (bpts == null) {
            bpts = new CopyOnWriteArrayList<StackCapturingLineBreakpoint>();
            debugProcess.putUserData(CAPTURE_BREAKPOINTS, bpts);
        }
        bpts.add(breakpoint);
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getRelatedStack"));
        }
        if (frame != null) {
            DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
            Map capturedStacks = (Map)debugProcess.getUserData(CAPTURED_STACKS);
            if (ContainerUtil.isEmpty((Map)capturedStacks)) {
                return null;
            }
            List captureBreakpoints = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
            if (ContainerUtil.isEmpty((Collection)captureBreakpoints)) {
                return null;
            }
            try {
                Location location = frame.location();
                String className = location.declaringType().name();
                String methodName = location.method().name();
                List<Value> argumentValues = null;
                for (StackCapturingLineBreakpoint b : captureBreakpoints) {
                    String insertClassName = b.myCapturePoint.myInsertClassName;
                    if (!StringUtil.isEmpty((String)insertClassName) && !StringUtil.equals((CharSequence)insertClassName, (CharSequence)className) || !StringUtil.equals((CharSequence)b.myCapturePoint.myInsertMethodName, (CharSequence)methodName)) continue;
                    if (argumentValues == null) {
                        argumentValues = frame.getArgumentValues();
                    }
                    try {
                        EvaluationContextImpl evaluationContext;
                        Value key2;
                        ExpressionEvaluator evaluator = (ExpressionEvaluator)b.myEvaluator.getValue();
                        if (evaluator == null || !((key2 = evaluator.evaluate((EvaluationContext)(evaluationContext = new EvaluationContextImpl(suspendContext, frame, frame.thisObject())))) instanceof ObjectReference)) continue;
                        return (List)capturedStacks.get(key2);
                    }
                    catch (EvaluateException evaluateException) {
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable ObjectReference key2, @Nullable DebugProcessImpl process2) {
        Map data;
        if (process2 != null && key2 != null && (data = (Map)process2.getUserData(CAPTURED_STACKS)) != null) {
            return (List)data.get(key2);
        }
        return null;
    }

    private static class CapturedStacksMap
    extends LinkedHashMap<ObjectReference, List<StackFrameItem>> {
        private CapturedStacksMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

