/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier myModifier;
    protected TextWithImports myText;

    protected EvaluationDescriptor(TextWithImports text, Project project2, Value value) {
        super(project2, value);
        this.myText = text;
    }

    protected EvaluationDescriptor(TextWithImports text, Project project2) {
        super(project2);
        this.setLvalue(false);
        this.myText = text;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement context) {
        TextWithImports text = this.getEvaluationText();
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context).createCodeFragment(text, context, this.myProject);
    }

    @Override
    public final Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        try {
            EvaluationContextImpl thisEvaluationContext = this.getEvaluationContext(evaluationContext);
            SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
            PsiElement psiContext = ContextUtil.getContextElement((StackFrameContext)evaluationContext, position);
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> {
                PsiCodeFragment code2 = this.getEvaluationCode((StackFrameContext)thisEvaluationContext);
                try {
                    return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.getEvaluationText(), psiContext).getEvaluatorBuilder().build((PsiElement)code2, position);
                }
                catch (UnsupportedExpressionException ex) {
                    ExpressionEvaluator eval = CompilingEvaluatorImpl.create(this.myProject, code2.getContext(), element -> code2);
                    if (eval != null) {
                        return eval;
                    }
                    throw ex;
                }
            });
            if (!thisEvaluationContext.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl frameProxy = thisEvaluationContext.getFrameProxy();
            if (frameProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Value value = evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            DebuggerUtilsEx.keep(value, thisEvaluationContext);
            this.myModifier = evaluator.getModifier();
            this.setLvalue(this.myModifier != null);
            return value;
        }
        catch (EvaluateException ex) {
            throw new EvaluateException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (ObjectCollectedException ex) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiCodeFragment evaluationCode = this.getEvaluationCode((StackFrameContext)context);
        if (evaluationCode instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)evaluationCode).getExpression();
        }
        throw new EvaluateException(DebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Nullable
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.myModifier != null && this.myModifier.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }

    @Override
    public XValueModifier getModifier(JavaValue value) {
        return new JavaValueModifier(value){

            @Override
            protected void setValueImpl(@NotNull String expression, @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor$1", "setValueImpl"));
                }
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor$1", "setValueImpl"));
                }
                final EvaluationDescriptor evaluationDescriptor = EvaluationDescriptor.this;
                if (evaluationDescriptor.canSetValue()) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(EvaluationDescriptor.this.getProject()).getContext();
                    this.set(expression, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            Modifier modifier = evaluationDescriptor.getModifier();
                            modifier.setValue(1.preprocessValue(evaluationContext, newValue, modifier.getExpectedType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, evaluationContext.getClassLoader());
                        }
                    });
                }
            }
        };
    }
}

