/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.actions;

import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;

public class TableTabAction
extends ToggleAction
implements DumbAware {
    private final PropertyTablePanel myPanel;
    private final PropertyTableTab myTab;
    private final ActionButton myButton;

    public TableTabAction(PropertyTablePanel panel2, PropertyTableTab tab) {
        this.myPanel = panel2;
        this.myTab = tab;
        Presentation presentation = this.getTemplatePresentation();
        String text = tab.getDescription();
        presentation.setText(text);
        presentation.setDescription(text);
        presentation.setIcon(tab.getIcon());
        this.myButton = new ActionButton((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.updateState();
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myTab == this.myPanel.getCurrentTab();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            this.myPanel.setCurrentTab(this.myTab);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.updateState());
        }
    }

    public ActionButton getButton() {
        return this.myButton;
    }

    public void updateState() {
        this.getTemplatePresentation().putClientProperty("selected", (Object)this.isSelected(null));
        this.myButton.repaint();
    }
}

