/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jetbrains.annotations.NotNull;

public class DialogAppender
extends AppenderSkeleton {
    private static final ErrorLogger DEFAULT_LOGGER = new DefaultIdeaErrorLogger();
    private static final int MAX_ASYNC_LOGGING_EVENTS = 5;
    private volatile Runnable myDialogRunnable;
    private final AtomicInteger myPendingAppendCounts = new AtomicInteger();

    protected synchronized void append(@NotNull LoggingEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/DialogAppender", "append"));
        }
        if (!event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) || Main.isCommandLine() || !IdeaApplication.isLoaded()) {
            return;
        }
        if (this.myPendingAppendCounts.addAndGet(1) > 5) {
            this.myPendingAppendCounts.decrementAndGet();
        } else {
            SwingUtilities.invokeLater(() -> {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/DialogAppender", "lambda$append$0"));
                }
                try {
                    this.appendToLoggers(event, new ErrorLogger[]{DEFAULT_LOGGER});
                }
                finally {
                    this.myPendingAppendCounts.decrementAndGet();
                }
            });
        }
    }

    void appendToLoggers(@NotNull LoggingEvent event, @NotNull ErrorLogger[] errorLoggers) {
        IdeaLoggingEvent ideaEvent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (errorLoggers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLoggers", "com/intellij/diagnostic/DialogAppender", "appendToLoggers"));
        }
        if (this.myDialogRunnable != null) {
            return;
        }
        Object message = event.getMessage();
        if (message instanceof IdeaLoggingEvent) {
            ideaEvent = (IdeaLoggingEvent)message;
        } else {
            ThrowableInformation info = event.getThrowableInformation();
            if (info == null) {
                return;
            }
            ideaEvent = DialogAppender.extractLoggingEvent(message, info.getThrowable());
        }
        for (int i2 = errorLoggers.length - 1; i2 >= 0; --i2) {
            ErrorLogger logger = errorLoggers[i2];
            if (!logger.canHandle(ideaEvent)) continue;
            this.myDialogRunnable = () -> {
                try {
                    logger.handle(ideaEvent);
                }
                finally {
                    this.myDialogRunnable = null;
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                new Thread(this.myDialogRunnable, "dialog appender logger").start();
                break;
            }
            app.executeOnPooledThread(this.myDialogRunnable);
            break;
        }
    }

    private static IdeaLoggingEvent extractLoggingEvent(Object message, Throwable throwable) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)throwable);
        if (rootCause instanceof LogEventException) {
            return ((LogEventException)rootCause).getLogMessage();
        }
        String strMessage = message == null ? "<null> " : message.toString();
        ExceptionWithAttachments withAttachments = (ExceptionWithAttachments)ExceptionUtil.findCause((Throwable)throwable, ExceptionWithAttachments.class);
        if (withAttachments != null) {
            return LogMessageEx.createEvent(strMessage, ExceptionUtil.getThrowableText((Throwable)throwable), withAttachments.getAttachments());
        }
        return new IdeaLoggingEvent(strMessage, throwable);
    }

    Runnable getDialogRunnable() {
        return this.myDialogRunnable;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }
}

