/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.EditLogPatternDialog;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.SmartList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class LogConfigurationPanel<T extends RunConfigurationBase>
extends SettingsEditor<T> {
    private final TableView<LogFileOptions> myFilesTable;
    private final ListTableModel<LogFileOptions> myModel;
    private JPanel myWholePanel;
    private JPanel myScrollPanel;
    private JBCheckBox myRedirectOutputCb;
    private TextFieldWithBrowseButton myOutputFile;
    private JCheckBox myShowConsoleOnStdOutCb;
    private JCheckBox myShowConsoleOnStdErrCb;
    private final Map<LogFileOptions, PredefinedLogFile> myLog2Predefined;
    private final List<PredefinedLogFile> myUnresolvedPredefined;

    public LogConfigurationPanel() {
        this.$$$setupUI$$$();
        this.myLog2Predefined = new THashMap();
        this.myUnresolvedPredefined = new SmartList();
        MyIsActiveColumnInfo IS_SHOW = new MyIsActiveColumnInfo();
        MyLogFileColumnInfo FILE = new MyLogFileColumnInfo();
        MyIsSkipColumnInfo IS_SKIP_CONTENT = new MyIsSkipColumnInfo();
        this.myModel = new ListTableModel(new ColumnInfo[]{IS_SHOW, FILE, IS_SKIP_CONTENT});
        this.myFilesTable = new TableView(this.myModel);
        this.myFilesTable.getEmptyText().setText(DiagnosticBundle.message("log.monitor.no.files", new Object[0]));
        JTableHeader tableHeader = this.myFilesTable.getTableHeader();
        FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = fontMetrics.stringWidth(IS_SHOW.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 0);
        preferredWidth = fontMetrics.stringWidth(IS_SKIP_CONTENT.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 2);
        this.myFilesTable.setColumnSelectionAllowed(false);
        this.myFilesTable.setShowGrid(false);
        this.myFilesTable.setDragEnabled(false);
        this.myFilesTable.setShowHorizontalLines(false);
        this.myFilesTable.setShowVerticalLines(false);
        this.myFilesTable.setIntercellSpacing(new Dimension(0, 0));
        this.myScrollPanel.add((Component)ToolbarDecorator.createDecorator(this.myFilesTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<LogFileOptions> newList = new ArrayList<LogFileOptions>(LogConfigurationPanel.this.myModel.getItems());
                LogFileOptions newOptions = new LogFileOptions("", "", true, true, false);
                if (LogConfigurationPanel.showEditorDialog(newOptions)) {
                    newList.add(newOptions);
                    LogConfigurationPanel.this.myModel.setItems(newList);
                    int index = LogConfigurationPanel.this.myModel.getRowCount() - 1;
                    LogConfigurationPanel.this.myModel.fireTableRowsInserted(index, index);
                    LogConfigurationPanel.this.myFilesTable.setRowSelectionInterval(index, index);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int i2;
                TableUtil.stopEditing((JTable)LogConfigurationPanel.this.myFilesTable);
                int[] selected = LogConfigurationPanel.this.myFilesTable.getSelectedRows();
                if (selected.length == 0) {
                    return;
                }
                for (i2 = selected.length - 1; i2 >= 0; --i2) {
                    LogConfigurationPanel.this.myModel.removeRow(selected[i2]);
                }
                for (i2 = selected.length - 1; i2 >= 0; --i2) {
                    int idx = selected[i2];
                    LogConfigurationPanel.this.myModel.fireTableRowsDeleted(idx, idx);
                }
                int selection = selected[0];
                if (selection >= LogConfigurationPanel.this.myModel.getRowCount()) {
                    selection = LogConfigurationPanel.this.myModel.getRowCount() - 1;
                }
                if (selection >= 0) {
                    LogConfigurationPanel.this.myFilesTable.setRowSelectionInterval(selection, selection);
                }
                LogConfigurationPanel.this.myFilesTable.requestFocus();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = LogConfigurationPanel.this.myFilesTable.getSelectedRow();
                LogConfigurationPanel.showEditorDialog((LogFileOptions)LogConfigurationPanel.this.myFilesTable.getSelectedObject());
                LogConfigurationPanel.this.myModel.fireTableDataChanged();
                LogConfigurationPanel.this.myFilesTable.setRowSelectionInterval(selectedRow, selectedRow);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return LogConfigurationPanel.this.myFilesTable.getSelectedRowCount() >= 1 && !LogConfigurationPanel.this.myLog2Predefined.containsKey(LogConfigurationPanel.this.myFilesTable.getSelectedObject());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return LogConfigurationPanel.this.myFilesTable.getSelectedRowCount() >= 1 && !LogConfigurationPanel.this.myLog2Predefined.containsKey(LogConfigurationPanel.this.myFilesTable.getSelectedObject()) && LogConfigurationPanel.this.myFilesTable.getSelectedObject() != null;
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myWholePanel.setPreferredSize(new Dimension(-1, 150));
        this.myOutputFile.addBrowseFolderListener("Choose File to Save Console Output", "Console output would be saved to the specified file", null, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myRedirectOutputCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/logging/LogConfigurationPanel$6", "actionPerformed"));
                }
                LogConfigurationPanel.this.myOutputFile.setEnabled(LogConfigurationPanel.this.myRedirectOutputCb.isSelected());
            }
        });
    }

    private void setUpColumnWidth(JTableHeader tableHeader, int preferredWidth, int columnIdx) {
        this.myFilesTable.getColumnModel().getColumn(columnIdx).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn tableColumn = tableHeader.getColumnModel().getColumn(columnIdx);
        tableColumn.setWidth(preferredWidth);
        tableColumn.setPreferredWidth(preferredWidth);
        tableColumn.setMinWidth(preferredWidth);
        tableColumn.setMaxWidth(preferredWidth);
    }

    public void refreshPredefinedLogFiles(RunConfigurationBase configurationBase) {
        PredefinedLogFile[] unresolved;
        List items = this.myModel.getItems();
        ArrayList<LogFileOptions> newItems = new ArrayList<LogFileOptions>();
        boolean changed = false;
        for (LogFileOptions item : items) {
            PredefinedLogFile predefined = this.myLog2Predefined.get(item);
            if (predefined != null) {
                LogFileOptions options = configurationBase.getOptionsForPredefinedLogFile(predefined);
                if (LogFileOptions.areEqual((LogFileOptions)item, (LogFileOptions)options)) {
                    newItems.add(item);
                    continue;
                }
                changed = true;
                this.myLog2Predefined.remove(item);
                if (options == null) {
                    this.myUnresolvedPredefined.add(predefined);
                    continue;
                }
                newItems.add(options);
                this.myLog2Predefined.put(options, predefined);
                continue;
            }
            newItems.add(item);
        }
        for (PredefinedLogFile logFile : unresolved = this.myUnresolvedPredefined.toArray(new PredefinedLogFile[this.myUnresolvedPredefined.size()])) {
            LogFileOptions options = configurationBase.getOptionsForPredefinedLogFile(logFile);
            if (options == null) continue;
            changed = true;
            this.myUnresolvedPredefined.remove(logFile);
            this.myLog2Predefined.put(options, logFile);
            newItems.add(options);
        }
        if (changed) {
            this.myModel.setItems(newItems);
        }
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/diagnostic/logging/LogConfigurationPanel", "resetEditorFrom"));
        }
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>();
        ArrayList logFiles = configuration.getLogFiles();
        for (Object setting : logFiles) {
            list.add(new LogFileOptions(setting.getName(), setting.getPathPattern(), setting.isEnabled(), setting.isSkipContent(), setting.isShowAll()));
        }
        this.myLog2Predefined.clear();
        this.myUnresolvedPredefined.clear();
        ArrayList predefinedLogFiles = configuration.getPredefinedLogFiles();
        for (PredefinedLogFile predefinedLogFile : predefinedLogFiles) {
            PredefinedLogFile logFile = new PredefinedLogFile(predefinedLogFile);
            LogFileOptions options = configuration.getOptionsForPredefinedLogFile(logFile);
            if (options != null) {
                this.myLog2Predefined.put(options, logFile);
                list.add(options);
                continue;
            }
            this.myUnresolvedPredefined.add(logFile);
        }
        this.myModel.setItems(list);
        boolean redirectOutputToFile = configuration.isSaveOutputToFile();
        this.myRedirectOutputCb.setSelected(redirectOutputToFile);
        String fileOutputPath = configuration.getOutputFilePath();
        this.myOutputFile.setText(fileOutputPath != null ? FileUtil.toSystemDependentName((String)fileOutputPath) : "");
        this.myOutputFile.setEnabled(redirectOutputToFile);
        this.myShowConsoleOnStdOutCb.setSelected(configuration.isShowConsoleOnStdOut());
        this.myShowConsoleOnStdErrCb.setSelected(configuration.isShowConsoleOnStdErr());
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/diagnostic/logging/LogConfigurationPanel", "applyEditorTo"));
        }
        this.myFilesTable.stopEditing();
        configuration.removeAllLogFiles();
        configuration.removeAllPredefinedLogFiles();
        for (int i2 = 0; i2 < this.myModel.getRowCount(); ++i2) {
            LogFileOptions options = (LogFileOptions)this.myModel.getValueAt(i2, 1);
            if (Comparing.equal((String)options.getPathPattern(), (String)"")) continue;
            Boolean checked = (Boolean)this.myModel.getValueAt(i2, 0);
            Boolean skipped = (Boolean)this.myModel.getValueAt(i2, 2);
            PredefinedLogFile predefined = this.myLog2Predefined.get(options);
            if (predefined != null) {
                configuration.addPredefinedLogFile(new PredefinedLogFile(predefined.getId(), options.isEnabled()));
                continue;
            }
            configuration.addLogFile(options.getPathPattern(), options.getName(), checked.booleanValue(), skipped.booleanValue(), options.isShowAll());
        }
        for (PredefinedLogFile logFile : this.myUnresolvedPredefined) {
            configuration.addPredefinedLogFile(logFile);
        }
        String text = this.myOutputFile.getText();
        configuration.setFileOutputPath(StringUtil.isEmpty((String)text) ? null : FileUtil.toSystemIndependentName((String)text));
        configuration.setSaveOutputToFile(this.myRedirectOutputCb.isSelected());
        configuration.setShowConsoleOnStdOut(this.myShowConsoleOnStdOutCb.isSelected());
        configuration.setShowConsoleOnStdErr(this.myShowConsoleOnStdErrCb.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConfigurationPanel", "createEditor"));
        }
        return jPanel;
    }

    private static boolean showEditorDialog(@NotNull LogFileOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/diagnostic/logging/LogConfigurationPanel", "showEditorDialog"));
        }
        EditLogPatternDialog dialog2 = new EditLogPatternDialog();
        dialog2.init(options.getName(), options.getPathPattern(), options.isShowAll());
        if (dialog2.showAndGet()) {
            options.setName(dialog2.getName());
            options.setPathPattern(dialog2.getLogPattern());
            options.setShowAll(dialog2.isShowAllFiles());
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 10, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.group"), (int)0, (int)0, null, null));
        this.myScrollPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(-1, 150), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRedirectOutputCb = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Save console output to file:");
        jBCheckBox.setMnemonic('S');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myOutputFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myShowConsoleOnStdOutCb = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("logs.show.console.on.stdout"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowConsoleOnStdErrCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("logs.show.console.on.stderr"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class LogFileCellEditor
    extends AbstractTableCellEditor {
        private final CellEditorComponentWithBrowseButton<JTextField> myComponent;
        private final LogFileOptions myLogFileOptions;

        public LogFileCellEditor(LogFileOptions options) {
            this.myLogFileOptions = options;
            this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(), (TableCellEditor)((Object)this));
            this.getChildComponent().setEditable(false);
            this.getChildComponent().setBorder(null);
            this.myComponent.getComponentWithButton().getButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/logging/LogConfigurationPanel$LogFileCellEditor$1", "actionPerformed"));
                    }
                    LogConfigurationPanel.showEditorDialog(LogFileCellEditor.this.myLogFileOptions);
                    JTextField textField = LogFileCellEditor.this.getChildComponent();
                    textField.setText(LogFileCellEditor.this.myLogFileOptions.getName());
                    textField.requestFocus();
                    LogConfigurationPanel.this.myModel.fireTableDataChanged();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.myLogFileOptions;
        }

        private JTextField getChildComponent() {
            return this.myComponent.getChildComponent();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.getChildComponent().setText(((LogFileOptions)value).getName());
            return this.myComponent;
        }
    }

    private class MyIsSkipColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsSkipColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.skipped.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions element) {
            return element.isSkipContent();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return !LogConfigurationPanel.this.myLog2Predefined.containsKey(element);
        }

        public void setValue(LogFileOptions element, Boolean skipped) {
            element.setSkipContent(skipped.booleanValue());
        }
    }

    private class MyIsActiveColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsActiveColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.active.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions object) {
            return object.isEnabled();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return true;
        }

        public void setValue(LogFileOptions element, Boolean checked) {
            PredefinedLogFile predefinedLogFile = (PredefinedLogFile)LogConfigurationPanel.this.myLog2Predefined.get(element);
            if (predefinedLogFile != null) {
                predefinedLogFile.setEnabled(checked.booleanValue());
            }
            element.setEnable(checked.booleanValue());
        }
    }

    private class MyLogFileColumnInfo
    extends ColumnInfo<LogFileOptions, LogFileOptions> {
        public MyLogFileColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.log.file.column", new Object[0]));
        }

        public TableCellRenderer getRenderer(LogFileOptions p0) {
            return new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/diagnostic/logging/LogConfigurationPanel$MyLogFileColumnInfo$1", "getTableCellRendererComponent"));
                    }
                    Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(((LogFileOptions)value).getName());
                    this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.setBorder(null);
                    Component component = renderer;
                    if (component == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/logging/LogConfigurationPanel$MyLogFileColumnInfo$1", "getTableCellRendererComponent"));
                    }
                    return component;
                }
            };
        }

        public LogFileOptions valueOf(LogFileOptions object) {
            return object;
        }

        public TableCellEditor getEditor(LogFileOptions item) {
            return new LogFileCellEditor(item);
        }

        public void setValue(LogFileOptions o, LogFileOptions aValue) {
            if (aValue != null) {
                if (!o.getName().equals(aValue.getName()) || !o.getPathPattern().equals(aValue.getPathPattern()) || o.isShowAll() != aValue.isShowAll()) {
                    LogConfigurationPanel.this.myLog2Predefined.remove(o);
                }
                o.setName(aValue.getName());
                o.setShowAll(aValue.isShowAll());
                o.setPathPattern(aValue.getPathPattern());
            }
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogConfigurationPanel.this.myLog2Predefined.containsKey(o);
        }
    }
}

