/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeViewer
implements MergeTool.MergeViewer {
    private static final Logger LOG = Logger.getInstance(TextMergeViewer.class);
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    private final MyThreesideViewer myViewer;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeViewer", "<init>"));
        }
        this.myMergeContext = context;
        this.myMergeRequest = request;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest));
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = new MyThreesideViewer(diffContext, (ContentDiffRequest)diffRequest);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/TextMergeViewer", "getDiffContents"));
        }
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output = mergeRequest.getOutputContent();
        List list = ContainerUtil.list((Object[])new DiffContent[]{left, output, right});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer", "getDiffContents"));
        }
        return list;
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        if (mergeRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/TextMergeViewer", "getDiffContentTitles"));
        }
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), "Result");
        List<String> list = titles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer", "getDiffContentTitles"));
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init = this.myViewer.init();
        components.statusPanel = init.statusPanel;
        components.toolbarActions = init.toolbarActions;
        components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext);
        MergeTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer", "init"));
        }
        return toolbarComponents;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/TextMergeViewer", "getResolveAction"));
        }
        return this.myViewer.getResolveAction(result2);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MyThreesideViewer getViewer() {
        MyThreesideViewer myThreesideViewer = this.myViewer;
        if (myThreesideViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer", "getViewer"));
        }
        return myThreesideViewer;
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        public InnerChunkData(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "<init>"));
            }
            if (documents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "<init>"));
            }
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "getChunks"));
            }
            if (documents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "getChunks"));
            }
            List list = ThreeSide.map(side -> {
                int endLine;
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "lambda$getChunks$0"));
                }
                if (documents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documents", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "lambda$getChunks$0"));
                }
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$InnerChunkData", "getChunks"));
            }
            return list;
        }
    }

    public class MyThreesideViewer
    extends ThreesideTextDiffViewerEx {
        @NotNull
        private final MergeModelBase myModel;
        @NotNull
        private final ModifierProvider myModifierProvider;
        @NotNull
        private final MyInnerDiffWorker myInnerDiffWorker;
        @NotNull
        private final MyLineStatusTracker myLineStatusTracker;
        @NotNull
        private final TextDiffProviderBase myTextDiffProvider;
        @NotNull
        private final List<TextMergeChange> myAllMergeChanges;
        private boolean myInitialRediffStarted;
        private boolean myInitialRediffFinished;
        private boolean myContentModified;

        public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "<init>"));
            }
            super(context, request);
            this.myAllMergeChanges = new ArrayList<TextMergeChange>();
            this.myModel = new MyMergeModel(this.getProject(), this.getEditor().getDocument());
            this.myModifierProvider = new ModifierProvider();
            this.myInnerDiffWorker = new MyInnerDiffWorker();
            this.myLineStatusTracker = new MyLineStatusTracker(this.getProject(), this.getEditor().getDocument());
            this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), this.myInnerDiffWorker::onSettingsChanged, new IgnorePolicy[]{IgnorePolicy.DEFAULT}, new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD});
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction((AnAction)new MyShowPrevChangeMarkerAction(null), this.myPanel);
            DiffUtil.registerAction((AnAction)new MyShowNextChangeMarkerAction(null), this.myPanel);
            ProxyUndoRedoAction.register(this.getProject(), this.getEditor(), this.myContentPanel);
        }

        @Override
        protected void onInit() {
            super.onInit();
            this.myModifierProvider.init();
        }

        @Override
        protected void onDispose() {
            Disposer.dispose((Disposable)this.myModel);
            this.myLineStatusTracker.release();
            super.onDispose();
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.addAll(this.myTextDiffProvider.getToolbarActions());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            group.add((AnAction)this.myEditorSettingsAction);
            DefaultActionGroup diffGroup = new DefaultActionGroup("Compare With", true);
            diffGroup.getTemplatePresentation().setIcon(AllIcons.Diff.Diff);
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.LEFT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.BASE));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.RIGHT));
            group.add((AnAction)diffGroup);
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.BASE));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.LEFT));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.RIGHT));
            ArrayList<AnAction> arrayList = group;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "createToolbarActions"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected List<AnAction> createEditorPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.add(new ApplySelectedChangesAction(Side.LEFT, false));
            group.add(new ApplySelectedChangesAction(Side.RIGHT, false));
            group.add(new ResolveSelectedChangesAction(Side.LEFT));
            group.add(new ResolveSelectedChangesAction(Side.RIGHT));
            group.add(new IgnoreSelectedChangesSideAction(Side.LEFT, false));
            group.add(new IgnoreSelectedChangesSideAction(Side.RIGHT, false));
            group.add(new IgnoreSelectedChangesAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(TextDiffViewerUtil.createEditorPopupActions());
            ArrayList<AnAction> arrayList = group;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "createEditorPopupActions"));
            }
            return arrayList;
        }

        @Override
        @Nullable
        protected List<AnAction> createPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.addAll(this.myTextDiffProvider.getPopupActions());
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            return group;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getResolveAction"));
            }
            String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) && MyThreesideViewer.this.myContentModified && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.message", (Object[])new Object[]{result2 == MergeResult.LEFT ? 0 : 1}), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.RESOLVED && (MyThreesideViewer.this.getChangesCount() > 0 || MyThreesideViewer.this.getConflictsCount() > 0) && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext)) {
                        return;
                    }
                    MyThreesideViewer.this.destroyChangedBlocks();
                    TextMergeViewer.this.myMergeContext.finishMerge(result2);
                }
            };
        }

        private boolean setInitialOutputContent() {
            Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
            Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
            return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), "Init merge content", () -> {
                outputDocument.setText(baseDocument.getCharsSequence());
                DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
                if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                    this.myLineStatusTracker.setBaseRevision(baseDocument.getCharsSequence());
                    this.getEditor().getGutterComponentEx().setForceShowRightFreePaintersArea(true);
                }
            });
        }

        @Override
        public void rediff(boolean trySync) {
            if (this.myInitialRediffStarted) {
                return;
            }
            this.myInitialRediffStarted = true;
            assert (this.myAllMergeChanges.isEmpty());
            this.doRediff();
        }

        @Override
        @NotNull
        protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "performRediff"));
            }
            throw new UnsupportedOperationException();
        }

        private void doRediff() {
            this.myStatusPanel.setBusy(true);
            this.getEditor().setViewer(true);
            ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), "Computing Differences...", true){
                private Runnable myCallback;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$2", "run"));
                    }
                    this.myCallback = MyThreesideViewer.this.doPerformRediff(indicator);
                }

                public void onCancel() {
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$2", "onThrowable"));
                    }
                    LOG.error(error);
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onSuccess() {
                    if (MyThreesideViewer.this.isDisposed()) {
                        return;
                    }
                    this.myCallback.run();
                }
            }));
        }

        @NotNull
        protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
            Runnable runnable2;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
            }
            try {
                indicator.checkCanceled();
                List contents = TextMergeViewer.this.myMergeRequest.getContents();
                List sequences = (List)ReadAction.compute(() -> {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "lambda$doPerformRediff$3"));
                    }
                    indicator.checkCanceled();
                    return ContainerUtil.map((Collection)contents, content -> content.getDocument().getImmutableCharSequence());
                });
                List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsets::create);
                ComparisonManager manager = ComparisonManager.getInstance();
                List lineFragments = manager.compareLines((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), ComparisonPolicy.DEFAULT, indicator);
                List conflictTypes = ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, ComparisonPolicy.DEFAULT));
                runnable2 = this.apply(lineFragments, conflictTypes);
            }
            catch (DiffTooBigException e) {
                Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
                if (runnable3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                }
                return runnable3;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                Runnable runnable4 = () -> {
                    this.clearDiffPresentation();
                    this.myPanel.setErrorContent();
                };
                if (runnable4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
                }
                return runnable4;
            }
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "doPerformRediff"));
            }
            return runnable2;
        }

        @NotNull
        private Runnable apply(@NotNull List<MergeLineFragment> fragments, @NotNull List<MergeConflictType> conflictTypes) {
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "apply"));
            }
            if (conflictTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictTypes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "apply"));
            }
            Runnable runnable2 = () -> {
                if (fragments == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "lambda$apply$7"));
                }
                if (conflictTypes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictTypes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "lambda$apply$7"));
                }
                this.clearDiffPresentation();
                boolean success = this.setInitialOutputContent();
                if (!success) {
                    this.myPanel.addNotification(DiffNotifications.createNotification("Can't resolve conflicts in a read-only file"));
                    return;
                }
                this.myModel.setChanges(ContainerUtil.map((Collection)fragments, f -> new LineRange(f.getStartLine(ThreeSide.BASE), f.getEndLine(ThreeSide.BASE))));
                this.resetChangeCounters();
                for (int index = 0; index < fragments.size(); ++index) {
                    MergeLineFragment fragment = (MergeLineFragment)fragments.get(index);
                    MergeConflictType conflictType = (MergeConflictType)conflictTypes.get(index);
                    TextMergeChange change = new TextMergeChange(index, fragment, conflictType, TextMergeViewer.this);
                    this.myAllMergeChanges.add(change);
                    this.onChangeAdded(change);
                }
                this.myInitialScrollHelper.onRediff();
                this.myContentPanel.repaintDividers();
                this.myStatusPanel.update();
                this.getEditor().setViewer(false);
                this.myInnerDiffWorker.onSettingsChanged();
                this.myInitialRediffFinished = true;
                if (TextMergeViewer.this.myViewer.getTextSettings().isAutoApplyNonConflictedChanges() && this.getFirstUnresolvedChange(false, ThreeSide.BASE) != null) {
                    this.applyNonConflictedChanges(ThreeSide.BASE);
                }
            };
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "apply"));
            }
            return runnable2;
        }

        @Override
        protected void destroyChangedBlocks() {
            super.destroyChangedBlocks();
            this.myInnerDiffWorker.stop();
            for (TextMergeChange change : this.myAllMergeChanges) {
                change.destroy();
            }
            this.myAllMergeChanges.clear();
            this.myModel.setChanges(Collections.emptyList());
        }

        @Override
        protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "onBeforeDocumentChange"));
            }
            super.onBeforeDocumentChange(e);
            if (this.myInitialRediffFinished) {
                this.myContentModified = true;
            }
        }

        public void repaintDividers() {
            this.myContentPanel.repaintDividers();
        }

        private void onChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "onChangeResolved"));
            }
            if (change.isResolved()) {
                this.onChangeRemoved(change);
            } else {
                this.onChangeAdded(change);
            }
            if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                LOG.assertTrue(this.getFirstUnresolvedChange(true, ThreeSide.BASE) == null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component = this.getEditor().getComponent();
                    RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, JBUI.scale((int)5)));
                    String message = DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message, point, (Disposable)this, () -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }

        @NotNull
        public MergeModelBase getModel() {
            MergeModelBase mergeModelBase = this.myModel;
            if (mergeModelBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getModel"));
            }
            return mergeModelBase;
        }

        @NotNull
        public List<TextMergeChange> getAllChanges() {
            List<TextMergeChange> list = this.myAllMergeChanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getAllChanges"));
            }
            return list;
        }

        @NotNull
        public List<TextMergeChange> getChanges() {
            List list = ContainerUtil.filter(this.myAllMergeChanges, mergeChange -> !mergeChange.isResolved());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getDividerPaintable"));
            }
            MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
            if (myDividerPaintable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getDividerPaintable"));
            }
            return myDividerPaintable;
        }

        @NotNull
        public ModifierProvider getModifierProvider() {
            ModifierProvider modifierProvider = this.myModifierProvider;
            if (modifierProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getModifierProvider"));
            }
            return modifierProvider;
        }

        @NotNull
        public EditorEx getEditor() {
            EditorEx editorEx = this.getEditor(ThreeSide.BASE);
            if (editorEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getEditor"));
            }
            return editorEx;
        }

        public boolean executeMergeCommand(@Nullable String commandName, boolean underBulkUpdate, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "executeMergeCommand"));
            }
            this.myContentModified = true;
            TIntArrayList affectedIndexes = null;
            if (affected != null) {
                affectedIndexes = new TIntArrayList(affected.size());
                for (TextMergeChange change : affected) {
                    affectedIndexes.add(change.getIndex());
                }
            }
            return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, affectedIndexes, task);
        }

        public boolean executeMergeCommand(@Nullable String commandName, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "executeMergeCommand"));
            }
            return this.executeMergeCommand(commandName, false, affected, task);
        }

        public void markChangeResolved(@NotNull TextMergeChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
            }
            if (change.isResolved()) {
                return;
            }
            change.setResolved(Side.LEFT, true);
            change.setResolved(Side.RIGHT, true);
            this.onChangeResolved(change);
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "markChangeResolved"));
            }
            if (change.isResolved(side)) {
                return;
            }
            change.setResolved(side, true);
            if (change.isResolved()) {
                this.onChangeResolved(change);
            }
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "ignoreChange"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "ignoreChange"));
            }
            if (!change.isConflict() || resolveChange) {
                this.markChangeResolved(change);
            } else {
                this.markChangeResolved(change, side);
            }
        }

        public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "replaceChange"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "replaceChange"));
            }
            if (change.isResolved(side)) {
                return;
            }
            if (!change.isChange(side)) {
                this.markChangeResolved(change);
                return;
            }
            ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            Document sourceDocument = this.getContent(sourceSide).getDocument();
            int sourceStartLine = change.getStartLine(sourceSide);
            int sourceEndLine = change.getEndLine(sourceSide);
            List<String> newContent = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
            if (change.isConflict()) {
                boolean append = change.isOnesideAppliedConflict();
                if (append) {
                    this.myModel.appendChange(change.getIndex(), newContent);
                } else {
                    this.myModel.replaceChange(change.getIndex(), newContent);
                }
                if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                    this.markChangeResolved(change);
                } else {
                    change.markOnesideAppliedConflict();
                    this.markChangeResolved(change, side);
                }
            } else {
                this.myModel.replaceChange(change.getIndex(), newContent);
                this.markChangeResolved(change);
            }
        }

        @Nullable
        public CharSequence resolveConflictUsingInnerDifferences(@NotNull TextMergeChange change) {
            CharSequence resultContent;
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "resolveConflictUsingInnerDifferences"));
            }
            if (!change.isConflict()) {
                return null;
            }
            if (change.isResolved(Side.LEFT) || change.isResolved(Side.RIGHT)) {
                return null;
            }
            MergeLineFragment changeFragment = change.getFragment();
            if (changeFragment.getStartLine(ThreeSide.LEFT) == changeFragment.getEndLine(ThreeSide.LEFT)) {
                return null;
            }
            if (changeFragment.getStartLine(ThreeSide.BASE) == changeFragment.getEndLine(ThreeSide.BASE)) {
                return null;
            }
            if (changeFragment.getStartLine(ThreeSide.RIGHT) == changeFragment.getEndLine(ThreeSide.RIGHT)) {
                return null;
            }
            int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
            int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
            DiffContent baseDiffContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
            Document baseDocument = ((DocumentContent)baseDiffContent).getDocument();
            int resultStartLine = change.getStartLine();
            int resultEndLine = change.getEndLine();
            DocumentEx resultDocument = this.getEditor().getDocument();
            CharSequence baseContent = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
            if (!StringUtil.equals((CharSequence)baseContent, (CharSequence)(resultContent = DiffUtil.getLinesContent(resultDocument, resultStartLine, resultEndLine)))) {
                return null;
            }
            List texts = ThreeSide.map(side -> {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "lambda$resolveConflictUsingInnerDifferences$11"));
                }
                return DiffUtil.getLinesContent(this.getEditor((ThreeSide)side).getDocument(), change.getStartLine((ThreeSide)side), change.getEndLine((ThreeSide)side));
            });
            return ComparisonMergeUtil.tryResolveConflict((CharSequence)texts.get(0), (CharSequence)texts.get(1), (CharSequence)texts.get(2));
        }

        public void resolveConflictedChange(@NotNull TextMergeChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "resolveConflictedChange"));
            }
            CharSequence newContent = this.resolveConflictUsingInnerDifferences(change);
            if (newContent == null) {
                return;
            }
            String[] newContentLines = LineTokenizer.tokenize((CharSequence)newContent, (boolean)false);
            this.myModel.replaceChange(change.getIndex(), Arrays.asList(newContentLines));
            this.markChangeResolved(change);
        }

        @Nullable
        private TextMergeChange getFirstUnresolvedChange(boolean acceptConflicts, @NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "getFirstUnresolvedChange"));
            }
            for (TextMergeChange change : this.getAllChanges()) {
                if (change.isResolved() || !acceptConflicts && change.isConflict() || !change.isChange(side)) continue;
                return change;
            }
            return null;
        }

        private void applyNonConflictedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "applyNonConflictedChanges"));
            }
            this.executeMergeCommand("Apply Non Conflicted Changes", true, null, () -> {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer", "lambda$applyNonConflictedChanges$12"));
                }
                ArrayList allChanges = ContainerUtil.newArrayList(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    if (change.isConflict() || change.isResolved(side) || !change.isChange(side)) continue;
                    Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
                    this.replaceChange(change, masterSide, false);
                }
            });
            TextMergeChange firstConflict = this.getFirstUnresolvedChange(true, ThreeSide.BASE);
            if (firstConflict != null) {
                this.doScrollToChange(firstConflict, true);
            }
        }

        private class ToggleByWordDiffAction
        extends LineStatusMarkerPopup.ToggleByWordDiffActionBase {
            @NotNull
            private final Range myRange;
            @Nullable
            private final Point myMousePosition;

            public ToggleByWordDiffAction(@Nullable Range range, Point mousePosition) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ToggleByWordDiffAction", "<init>"));
                }
                this.myRange = range;
                this.myMousePosition = mousePosition;
            }

            @Override
            protected void reshowPopup() {
                new MyLineStatusMarkerPopup(this.myRange).showHintAt(this.myMousePosition);
            }
        }

        private class MyShowNextChangeMarkerAction
        extends ShowChangeMarkerAction {
            public MyShowNextChangeMarkerAction(Range range) {
                super(range, "VcsShowNextChangeMarker");
            }

            @Override
            @Nullable
            protected Range getTargetRange(@NotNull Range range) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyShowNextChangeMarkerAction", "getTargetRange"));
                }
                return MyThreesideViewer.this.myLineStatusTracker.getNextRange(range);
            }

            @Override
            @Nullable
            protected Range getTargetRange(int line) {
                return MyThreesideViewer.this.myLineStatusTracker.getNextRange(line);
            }
        }

        private class MyShowPrevChangeMarkerAction
        extends ShowChangeMarkerAction {
            public MyShowPrevChangeMarkerAction(Range range) {
                super(range, "VcsShowPrevChangeMarker");
            }

            @Override
            @Nullable
            protected Range getTargetRange(@NotNull Range range) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyShowPrevChangeMarkerAction", "getTargetRange"));
                }
                return MyThreesideViewer.this.myLineStatusTracker.getPrevRange(range);
            }

            @Override
            @Nullable
            protected Range getTargetRange(int line) {
                return MyThreesideViewer.this.myLineStatusTracker.getPrevRange(line);
            }
        }

        private abstract class ShowChangeMarkerAction
        extends DumbAwareAction {
            @Nullable
            private final Range myRange;

            protected ShowChangeMarkerAction(@NotNull Range range, String actionId) {
                if (actionId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ShowChangeMarkerAction", "<init>"));
                }
                this.myRange = range;
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            @Nullable
            protected abstract Range getTargetRange(@NotNull Range var1);

            @Nullable
            protected abstract Range getTargetRange(int var1);

            public void update(AnActionEvent e) {
                boolean isKeyboardShortcut = this.myRange == null;
                boolean enabled = MyThreesideViewer.this.getTextSettings().isEnableLstGutterMarkersInMerge();
                e.getPresentation().setEnabled(enabled &= isKeyboardShortcut || MyThreesideViewer.this.myLineStatusTracker.isValid() && this.getTargetRange(this.myRange) != null);
            }

            public void actionPerformed(AnActionEvent e) {
                Range targetRange;
                if (!MyThreesideViewer.this.myLineStatusTracker.isValid()) {
                    return;
                }
                int line = MyThreesideViewer.this.getEditor().getCaretModel().getLogicalPosition().line;
                Range range = targetRange = this.myRange != null ? this.getTargetRange(this.myRange) : this.getTargetRange(line);
                if (targetRange != null) {
                    new MyLineStatusMarkerPopup(targetRange).scrollAndShow();
                }
            }
        }

        private class MyLineStatusMarkerPopup
        extends LineStatusMarkerPopup {
            public MyLineStatusMarkerPopup(Range range) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerPopup", "<init>"));
                }
                super(MyThreesideViewer.this.myLineStatusTracker, MyThreesideViewer.this.getEditor(), range);
            }

            @Override
            public void scrollAndShow() {
                if (!this.myTracker.isValid()) {
                    return;
                }
                Document document = this.myTracker.getDocument();
                int line = Math.min(this.myRange.getType() == 3 ? this.myRange.getLine2() : this.myRange.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
                int[] startLines = new int[]{((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, ((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
                for (ThreeSide side : ThreeSide.values()) {
                    DiffUtil.moveCaret(MyThreesideViewer.this.getEditor(side), side.select(startLines));
                }
                MyThreesideViewer.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.showAfterScroll();
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions(@Nullable Point mousePosition) {
                ArrayList<AnAction> actions = new ArrayList<AnAction>();
                actions.add((AnAction)new MyShowPrevChangeMarkerAction(this.myRange));
                actions.add((AnAction)new MyShowNextChangeMarkerAction(this.myRange));
                actions.add((AnAction)new ShowLineStatusRangeDiffAction(this.myTracker, this.myRange, this.myEditor));
                actions.add((AnAction)new CopyLineStatusRangeAction(this.myTracker, this.myRange));
                actions.add((AnAction)new ToggleByWordDiffAction(this.myRange, mousePosition));
                ArrayList<AnAction> arrayList = actions;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusMarkerPopup", "createToolbarActions"));
                }
                return arrayList;
            }
        }

        private class MyLineStatusMarkerRenderer
        extends LineStatusMarkerRenderer {
            private final Range myRange;

            public MyLineStatusMarkerRenderer(Range range) {
                super(range);
                this.myRange = range;
            }

            @Override
            public boolean canDoAction(MouseEvent e) {
                return MyLineStatusMarkerRenderer.isInsideMarkerArea(e);
            }

            @Override
            public void doAction(Editor editor1, MouseEvent e) {
                MyLineStatusMarkerPopup popup = new MyLineStatusMarkerPopup(this.myRange);
                popup.showHint(e);
            }

            @Override
            protected int getFramingBorderSize() {
                return JBUI.scale((int)2);
            }
        }

        private class MyLineStatusTracker
        extends LineStatusTrackerBase {
            public MyLineStatusTracker(@NotNull Project project2, Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusTracker", "<init>"));
                }
                super(project2, document);
            }

            @Override
            protected void createHighlighter(@NotNull Range range) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyLineStatusTracker", "createHighlighter"));
                }
                this.myApplication.assertIsDispatchThread();
                if (range.getHighlighter() != null) {
                    LOG.error("Multiple highlighters registered for the same Range");
                    return;
                }
                int first = range.getLine1() < DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getLineStartOffset(range.getLine1()) : this.myDocument.getTextLength();
                int second = range.getLine2() < DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getLineStartOffset(range.getLine2()) : this.myDocument.getTextLength();
                MarkupModelEx markupModel = MyThreesideViewer.this.getEditor().getMarkupModel();
                RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range, new TextRange(first, second), markupModel);
                highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyLineStatusMarkerRenderer(range));
                range.setHighlighter(highlighter);
            }
        }

        public class ModifierProvider
        extends KeyboardModifierListener {
            public void init() {
                this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
            }

            @Override
            public void onModifiersChanged() {
                for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                    change.updateGutterActions(false);
                }
            }
        }

        private class MyDividerPaintable
        implements DiffDividerDrawUtil.DividerPaintable {
            @NotNull
            private final Side mySide;

            public MyDividerPaintable(Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyDividerPaintable", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyDividerPaintable", "process"));
                }
                ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                    if (!mergeChange.isChange(this.mySide)) continue;
                    Color color = mergeChange.getDiffType().getColor(MyThreesideViewer.this.getEditor());
                    boolean isResolved = mergeChange.isResolved(this.mySide);
                    if (handler2.process(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), color, isResolved)) continue;
                    return;
                }
            }
        }

        private class ShowDiffWithBaseAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ShowDiffWithBaseAction(ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ShowDiffWithBaseAction", "<init>"));
                }
                this.mySide = side;
                String actionId = (String)this.mySide.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            public void actionPerformed(AnActionEvent e) {
                DiffContent baseContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
                String baseTitle = (String)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContentTitles());
                DiffContent otherContent = (DiffContent)this.mySide.select(MyThreesideViewer.this.myRequest.getContents());
                String otherTitle = (String)this.mySide.select(MyThreesideViewer.this.myRequest.getContentTitles());
                SimpleDiffRequest request = new SimpleDiffRequest(MyThreesideViewer.this.myRequest.getTitle(), baseContent, otherContent, baseTitle, otherTitle);
                ThreeSide currentSide = MyThreesideViewer.this.getCurrentSide();
                LogicalPosition currentPosition = DiffUtil.getCaretPosition(MyThreesideViewer.this.getCurrentEditor());
                LogicalPosition resultPosition = MyThreesideViewer.this.transferPosition(currentSide, this.mySide, currentPosition);
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
                DiffManager.getInstance().showDiff(MyThreesideViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)MyThreesideViewer.this.myPanel));
            }
        }

        public class ApplyNonConflictsAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ApplyNonConflictsAction(ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplyNonConflictsAction", "<init>"));
                }
                String id = (String)side.select((Object)"Diff.ApplyNonConflicts.Left", (Object)"Diff.ApplyNonConflicts", (Object)"Diff.ApplyNonConflicts.Right");
                ActionUtil.copyFrom((AnAction)this, (String)id);
                this.mySide = side;
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.getFirstUnresolvedChange(false, this.mySide) != null);
            }

            public void actionPerformed(AnActionEvent e) {
                MyThreesideViewer.this.applyNonConflictedChanges(this.mySide);
            }
        }

        private class ResolveSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public ResolveSelectedChangesAction(Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "<init>"));
                }
                super(false);
                this.mySide = side;
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "getText"));
                }
                return (String)this.mySide.select((Object)"Resolve using Left", (Object)"Resolve using Right");
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "isVisible"));
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "isEnabled"));
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "apply"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ResolveSelectedChangesAction", "apply"));
                }
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, true);
                }
            }
        }

        private class ApplySelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public ApplySelectedChangesAction(Side side, boolean shortcut) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "<init>"));
                }
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "getText"));
                }
                return side != ThreeSide.BASE ? "Accept" : this.getTemplatePresentation().getText();
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "isVisible"));
                }
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "isEnabled"));
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "apply"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesAction", "apply"));
                }
                for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    MyThreesideViewer.this.replaceChange(changes.get(i2), this.mySide, false);
                }
            }
        }

        private class IgnoreSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            public IgnoreSelectedChangesAction() {
                super(false);
                this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "getText"));
                }
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "isVisible"));
                }
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "isEnabled"));
                }
                return !change.isResolved();
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "apply"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesAction", "apply"));
                }
                for (TextMergeChange change : changes) {
                    MyThreesideViewer.this.markChangeResolved(change);
                }
            }
        }

        private class IgnoreSelectedChangesSideAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            public IgnoreSelectedChangesSideAction(Side side, boolean shortcut) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "<init>"));
                }
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "getText"));
                }
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "isVisible"));
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "isEnabled"));
                }
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "apply"));
                }
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$IgnoreSelectedChangesSideAction", "apply"));
                }
                for (TextMergeChange change : changes) {
                    MyThreesideViewer.this.ignoreChange(change, this.mySide, false);
                }
            }
        }

        private abstract class ApplySelectedChangesActionBase
        extends AnAction
        implements DumbAware {
            private final boolean myShortcut;

            public ApplySelectedChangesActionBase(boolean shortcut) {
                this.myShortcut = shortcut;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "update"));
                }
                if (this.myShortcut) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                Presentation presentation = e.getPresentation();
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (side == null) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                if (!this.isVisible(side)) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                presentation.setText(this.getText(side));
                presentation.setVisible(true);
                presentation.setEnabled(this.isSomeChangeSelected(side));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "actionPerformed"));
                }
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (editor == null || side == null) {
                    return;
                }
                List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                if (selectedChanges.isEmpty()) {
                    return;
                }
                String title = e.getPresentation().getText() + " in merge";
                MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> this.apply(side, selectedChanges));
            }

            private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "isSomeChangeSelected"));
                }
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                List carets = editor.getCaretModel().getAllCarets();
                if (carets.size() != 1) {
                    return true;
                }
                Caret caret = (Caret)carets.get(0);
                if (caret.hasSelection()) {
                    return true;
                }
                int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
                List<TextMergeChange> changes = MyThreesideViewer.this.getAllChanges();
                for (TextMergeChange change : changes) {
                    int line2;
                    int line1;
                    if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(line, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                    return true;
                }
                return false;
            }

            @NotNull
            private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "getSelectedChanges"));
                }
                BitSet lines = DiffUtil.getSelectedLines(MyThreesideViewer.this.getEditor(side));
                List<TextMergeChange> changes = MyThreesideViewer.this.getChanges();
                ArrayList<TextMergeChange> affectedChanges = new ArrayList<TextMergeChange>();
                for (TextMergeChange change : changes) {
                    int line2;
                    int line1;
                    if (!this.isEnabled(change) || !DiffUtil.isSelectedByLine(lines, line1 = change.getStartLine(side), line2 = change.getEndLine(side))) continue;
                    affectedChanges.add(change);
                }
                ArrayList<TextMergeChange> arrayList = affectedChanges;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$ApplySelectedChangesActionBase", "getSelectedChanges"));
                }
                return arrayList;
            }

            protected abstract String getText(@NotNull ThreeSide var1);

            protected abstract boolean isVisible(@NotNull ThreeSide var1);

            protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

            protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<TextMergeChange> var2);
        }

        private class MyMergeModel
        extends MergeModelBase<TextMergeChange.State> {
            public MyMergeModel(@NotNull Project project2, Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel", "<init>"));
                }
                super(project2, document);
            }

            @Override
            protected void reinstallHighlighters(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                change.reinstallHighlighters();
                MyThreesideViewer.this.myInnerDiffWorker.scheduleRediff(change);
            }

            @Override
            @NotNull
            protected TextMergeChange.State storeChangeState(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                TextMergeChange.State state = change.storeState();
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel", "storeChangeState"));
                }
                return state;
            }

            @Override
            protected void restoreChangeState(@NotNull TextMergeChange.State state) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyMergeModel", "restoreChangeState"));
                }
                super.restoreChangeState(state);
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(state.myIndex);
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                if (wasResolved != change.isResolved()) {
                    MyThreesideViewer.this.onChangeResolved(change);
                }
            }

            @Override
            @Nullable
            protected TextMergeChange.State processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
                TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index, oldLine1, oldLine2, shift);
                TextMergeChange mergeChange = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                if (mergeChange.getStartLine() == mergeChange.getEndLine() && mergeChange.getDiffType() == TextDiffType.DELETED && !mergeChange.isResolved()) {
                    TextMergeViewer.this.myViewer.markChangeResolved(mergeChange);
                }
                return state;
            }
        }

        private class MyInnerDiffWorker {
            @NotNull
            private final Set<TextMergeChange> myScheduled = ContainerUtil.newHashSet();
            @NotNull
            private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
            @Nullable
            private ProgressIndicator myProgress;
            private boolean myEnabled = false;

            private MyInnerDiffWorker() {
            }

            public void scheduleRediff(@NotNull TextMergeChange change) {
                if (change == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "scheduleRediff"));
                }
                this.scheduleRediff(Collections.singletonList(change));
            }

            public void scheduleRediff(@NotNull Collection<TextMergeChange> changes) {
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "scheduleRediff"));
                }
                if (!this.myEnabled) {
                    return;
                }
                this.putChanges(changes);
                this.schedule();
            }

            public void onSettingsChanged() {
                boolean enabled;
                boolean bl = enabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                if (this.myEnabled == enabled) {
                    return;
                }
                this.myEnabled = enabled;
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                if (this.myEnabled) {
                    this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                    this.launchRediff();
                } else {
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    this.myScheduled.clear();
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.setInnerFragments(null);
                    }
                }
            }

            public void stop() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                this.myScheduled.clear();
                this.myAlarm.cancelAllRequests();
            }

            private void putChanges(@NotNull Collection<TextMergeChange> changes) {
                if (changes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "putChanges"));
                }
                for (TextMergeChange change : changes) {
                    if (change.isResolved()) continue;
                    this.myScheduled.add(change);
                }
            }

            private void schedule() {
                if (this.myProgress != null) {
                    return;
                }
                if (this.myScheduled.isEmpty()) {
                    return;
                }
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(this::launchRediff, 300);
            }

            private void launchRediff() {
                MyThreesideViewer.this.myStatusPanel.setBusy(true);
                this.myProgress = new EmptyProgressIndicator();
                ArrayList scheduled = ContainerUtil.newArrayList(this.myScheduled);
                this.myScheduled.clear();
                List documents = ThreeSide.map(side -> MyThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
                List data = ContainerUtil.map((Collection)scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
                ProgressIndicator indicator = this.myProgress;
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.performRediff(scheduled, data, indicator));
            }

            private void performRediff(@NotNull List<TextMergeChange> scheduled, @NotNull List<InnerChunkData> data, @NotNull ProgressIndicator indicator) {
                if (scheduled == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheduled", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                }
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "performRediff"));
                }
                ArrayList<MergeInnerDifferences> result2 = new ArrayList<MergeInnerDifferences>(data.size());
                for (InnerChunkData chunkData : data) {
                    result2.add(DiffUtil.compareThreesideInner(chunkData.text, ComparisonPolicy.DEFAULT, indicator));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "lambda$performRediff$3"));
                    }
                    if (scheduled == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheduled", "com/intellij/diff/merge/TextMergeViewer$MyThreesideViewer$MyInnerDiffWorker", "lambda$performRediff$3"));
                    }
                    if (!this.myEnabled || indicator.isCanceled()) {
                        return;
                    }
                    this.myProgress = null;
                    for (int i2 = 0; i2 < scheduled.size(); ++i2) {
                        TextMergeChange change = (TextMergeChange)scheduled.get(i2);
                        if (this.myScheduled.contains(change)) continue;
                        change.setInnerFragments((MergeInnerDifferences)result2.get(i2));
                    }
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    if (!this.myScheduled.isEmpty()) {
                        this.launchRediff();
                    }
                }, ModalityState.any());
            }
        }
    }
}

