/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "canCreateFile"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            return !(file2 instanceof VirtualFileWithoutContent);
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (content instanceof EmptyContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
            if (tempInputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return tempInputFile;
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file2);
                if (localInputFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return localInputFile;
            }
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName));
            if (tempInputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return tempInputFile;
        }
        if (content instanceof DocumentContent) {
            TempInputFile tempInputFile = new TempInputFile(ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName));
            if (tempInputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return tempInputFile;
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content).getFile();
            if (file3.isInLocalFileSystem()) {
                LocalInputFile localInputFile = new LocalInputFile(file3);
                if (localInputFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return localInputFile;
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(@NotNull DocumentContent content, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        Boolean hasBom;
        Charset charset;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        if ((charset = content.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        if ((hasBom = content.hasBom()) == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = (String)ReadAction.compute(() -> {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "lambda$createTempFile$0"));
            }
            return content.getDocument().getText();
        });
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        File file2 = ExternalDiffToolUtil.createFile(bytes, fileName);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        return file2;
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        byte[] bytes = file2.contentsToByteArray();
        File file3 = ExternalDiffToolUtil.createFile(bytes, fileName);
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createTempFile"));
        }
        return file3;
    }

    @NotNull
    private static OutputFile createOutputFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                LocalOutputFile localOutputFile = new LocalOutputFile(file2);
                if (localOutputFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
                }
                return localOutputFile;
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName);
            NonLocalOutputFile nonLocalOutputFile = new NonLocalOutputFile(file2, tempFile);
            if (nonLocalOutputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
            }
            return nonLocalOutputFile;
        }
        if (content instanceof DocumentContent) {
            File tempFile = ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName);
            DocumentOutputFile documentOutputFile = new DocumentOutputFile(((DocumentContent)content).getDocument(), ((DocumentContent)content).getCharset(), tempFile);
            if (documentOutputFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createOutputFile"));
            }
            return documentOutputFile;
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createFile(@NotNull byte[] bytes, @NotNull FileNameInfo fileName) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file2 = tempFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        return file2;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files = new ArrayList<InputFile>();
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            DiffContent content = contents.get(i2);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
            files.add(ExternalDiffToolUtil.createFile(content, fileName));
        }
        HashMap patterns = ContainerUtil.newHashMap();
        if (files.size() == 2) {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(2)).getPath());
            patterns.put("%3", ((InputFile)files.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project2, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "executeMerge"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "executeMerge"));
        }
        boolean success = false;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i2 = 0; i2 < contents.size(); ++i2) {
                DiffContent content = (DiffContent)contents.get(i2);
                FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
                inputFiles.add(ExternalDiffToolUtil.createFile(content, fileName));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            com.intellij.util.containers.hash.HashMap patterns = new com.intellij.util.containers.hash.HashMap();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), (Map<String, String>)patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Waiting for External Tool", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$1", "run"));
                        }
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Launching External Tool", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffToolUtil$2", "run"));
                        }
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project2, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
            throw throwable;
        }
        if (outputFile != null) {
            outputFile.cleanup();
        }
        for (InputFile file3 : inputFiles) {
            file3.cleanup();
        }
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (parametersTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersTemplate", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        List parameters = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters) {
            String arg = StringUtil.replace((String)parameter, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        Process process2 = generalCommandLine.createProcess();
        if (process2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        return process2;
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        public FileNameInfo(@NotNull String prefix, @NotNull String name) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "<init>"));
            }
            this.prefix = prefix;
            this.name = name;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "create"));
            }
            if (titles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "create"));
            }
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name);
                if (fileNameInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "create"));
                }
                return fileNameInfo;
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                FileNameInfo fileNameInfo = new FileNameInfo(prefix, name);
                if (fileNameInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "create"));
                }
                return fileNameInfo;
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content, @Nullable String windowTitle) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "createMergeResult"));
            }
            String name = FileNameInfo.getFileName(content, null, windowTitle);
            FileNameInfo fileNameInfo = new FileNameInfo("merge_result", name);
            if (fileNameInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "createMergeResult"));
            }
            return fileNameInfo;
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "getFileName"));
            }
            if (content instanceof EmptyContent) {
                if ("no_content.tmp" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "getFileName"));
                }
                return "no_content.tmp";
            }
            String fileName = (String)content.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content instanceof FileContent) {
                fileName = ((FileContent)content).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                String string = fileName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "getFileName"));
                }
                return string;
            }
            FileType fileType = content.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            String name = "";
            if (title != null && windowTitle != null) {
                name = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                String string2 = name = title != null ? title : windowTitle;
            }
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            String string3 = PathUtil.suggestFileName((String)(name + "." + ext), (boolean)true, (boolean)false);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$FileNameInfo", "getFileName"));
            }
            return string3;
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        public TempInputFile(@NotNull File localFile) {
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile", "<init>"));
            }
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myLocalFile.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$TempInputFile", "getPath"));
            }
            return string;
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        public LocalInputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile", "<init>"));
            }
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalInputFile", "getPath"));
            }
            return string;
        }

        @Override
        public void cleanup() {
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        public DocumentOutputFile(@NotNull Document document, @Nullable Charset charset, @NotNull File localFile) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile", "<init>"));
            }
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/diff/tools/external/ExternalDiffToolUtil$DocumentOutputFile", "<init>"));
            }
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset != null ? charset : Charset.defaultCharset();
        }

        @Override
        public void apply() throws IOException {
            String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        public NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile", "<init>"));
            }
            if (localFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/intellij/diff/tools/external/ExternalDiffToolUtil$NonLocalOutputFile", "<init>"));
            }
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            this.myFile.setBinaryContent(FileUtil.loadFileBytes((File)this.myLocalFile));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        public LocalOutputFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/tools/external/ExternalDiffToolUtil$LocalOutputFile", "<init>"));
            }
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

