/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedContentPanel;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntFunction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final UnifiedDiffPanel myPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final TwosideTextDiffProvider.NoIgnore myTextDiffProvider;
    @NotNull
    protected Side myMasterSide;
    @Nullable
    private ChangedBlockData myChangedBlockData;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myMasterSide = Side.RIGHT;
        this.myReadOnlyLockSet = false;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.myEditor, this.myEditor}));
        UnifiedContentPanel contentPanel = new UnifiedContentPanel(titles, this.myEditor);
        this.myPanel = new UnifiedDiffPanel(this.myProject, contentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        this.myTextDiffProvider = DiffUtil.createNoIgnoreTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff);
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications(this.myContext, (DiffRequest)this.myRequest));
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    protected void updateEditorCanBeTyped() {
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.addAll(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (this.isEditable(Side.RIGHT, false)) {
            group.add(new ReplaceSelectedChangesAction(Side.LEFT, false));
            group.add(new ReplaceSelectedChangesAction(Side.RIGHT, false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "createEditorPopupActions"));
        }
        return arrayList;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            Document document1 = this.getContent1().getDocument();
            Document document2 = this.getContent2().getDocument();
            CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
            List<LineFragment> fragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
            DocumentContent content1 = this.getContent1();
            DocumentContent content2 = this.getContent2();
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ReadAction.compute(() -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$performRediff$1"));
                }
                indicator.checkCanceled();
                UnifiedFragmentBuilder builder = new UnifiedFragmentBuilder(fragments, document1, document2, this.myMasterSide);
                builder.exec();
                indicator.checkCanceled();
                EditorHighlighter highlighter = this.buildHighlighter(this.myProject, content1, content2, texts[0], texts[1], builder.getRanges(), builder.getText().length());
                UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(this.myProject, document1, document2, builder.getRanges());
                return new TwosideDocumentData(builder, highlighter, rangeHighlighter);
            });
            UnifiedFragmentBuilder builder = data.getBuilder();
            FileType fileType = content2.getContentType() == null ? content1.getContentType() : content2.getContentType();
            LineNumberConvertor convertor1 = builder.getConvertor1();
            LineNumberConvertor convertor2 = builder.getConvertor2();
            List<LineRange> changedLines = builder.getChangedLines();
            boolean isContentsEqual = builder.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder.getText(), data.getHighlighter(), data.getRangeHighlighter(), fileType, convertor1.createConvertor(), convertor2.createConvertor());
            runnable2 = this.apply(editorData, builder.getBlocks(), convertor1, convertor2, changedLines, isContentsEqual);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setTooBigContent();
            };
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setErrorContent();
            };
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    protected void markSuppressEditorTyping() {
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    protected void markStateIsOutOfDate() {
        this.myStateIsOutOfDate = true;
        if (this.myChangedBlockData != null) {
            for (UnifiedDiffChange diffChange : this.myChangedBlockData.getDiffChanges()) {
                diffChange.updateGutterActions();
            }
        }
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project2, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "buildHighlighter"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "buildHighlighter"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "buildHighlighter"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "buildHighlighter"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "buildHighlighter"));
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project2, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project2, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    private Runnable apply(@NotNull CombinedEditorData data, @NotNull List<ChangedBlock> blocks, @NotNull LineNumberConvertor convertor1, @NotNull LineNumberConvertor convertor2, @NotNull List<LineRange> changedLines, boolean isContentsEqual) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        if (convertor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        if (convertor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        if (changedLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLines", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        Runnable runnable2 = () -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$apply$5"));
            }
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$apply$5"));
            }
            if (convertor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$apply$5"));
            }
            if (convertor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$apply$5"));
            }
            if (changedLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLines", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$apply$5"));
            }
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            LineCol oldCaretPosition = LineCol.fromOffset((Document)this.myDocument, (int)this.myEditor.getCaretModel().getPrimaryCaret().getOffset());
            Pair<int[], Side> oldCaretLineTwoside = this.transferLineFromOneside(oldCaretPosition.line);
            this.clearDiffPresentation();
            if (isContentsEqual) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            TIntFunction separatorLines = this.myFoldingModel.getLineNumberConvertor();
            this.myEditor.getGutterComponentEx().setLineNumberConvertor(UnifiedDiffViewer.mergeConverters(data.getLineConvertor1(), separatorLines), UnifiedDiffViewer.mergeConverters(data.getLineConvertor2(), separatorLines));
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$null$4"));
                }
                this.myDuringOnesideDocumentModification = true;
                try {
                    this.myDocument.setText(data.getText());
                }
                finally {
                    this.myDuringOnesideDocumentModification = false;
                }
            });
            if (data.getHighlighter() != null) {
                this.myEditor.setHighlighter(data.getHighlighter());
            }
            DiffUtil.setEditorCodeStyle(this.myProject, this.myEditor, data.getFileType());
            if (data.getRangeHighlighter() != null) {
                data.getRangeHighlighter().apply(this.myProject, this.myDocument);
            }
            ArrayList<UnifiedDiffChange> diffChanges = new ArrayList<UnifiedDiffChange>(blocks.size());
            for (Object block : blocks) {
                diffChanges.add(new UnifiedDiffChange(this, (ChangedBlock)block));
            }
            ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
            if (!this.myEditor.isViewer()) {
                for (ChangedBlock block : blocks) {
                    LineRange range = (LineRange)this.myMasterSide.select((Object)block.getRange2(), (Object)block.getRange1());
                    if (range.isEmpty()) continue;
                    TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range.start, range.end);
                    guarderRangeBlocks.add(this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                }
                int textLength = this.myDocument.getTextLength();
                guarderRangeBlocks.add(this.createGuardedBlock(textLength, textLength));
            }
            this.myChangedBlockData = new ChangedBlockData(diffChanges, guarderRangeBlocks, convertor1, convertor2, isContentsEqual);
            int newCaretLine = this.transferLineToOneside((Side)oldCaretLineTwoside.second, ((Side)oldCaretLineTwoside.second).select((int[])oldCaretLineTwoside.first));
            this.myEditor.getCaretModel().moveToOffset(LineCol.toOffset((Document)this.myDocument, (int)newCaretLine, (int)oldCaretPosition.column));
            this.myFoldingModel.install(changedLines, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myStatusPanel.update();
            this.myPanel.setGoodContent();
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "apply"));
        }
        return runnable2;
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    @Contract(value="!null, _ -> !null")
    private static TIntFunction mergeConverters(@NotNull TIntFunction convertor, @NotNull TIntFunction separatorLines) {
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "mergeConverters"));
        }
        if (separatorLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorLines", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "mergeConverters"));
        }
        return value -> {
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$mergeConverters$6"));
            }
            if (separatorLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorLines", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "lambda$mergeConverters$6"));
            }
            return convertor.execute(separatorLines.execute(value));
        };
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "transferLineToOnesideStrict"));
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertInv(line);
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "transferLineFromOnesideStrict"));
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convert(line);
    }

    public int transferLineToOneside(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "transferLineToOneside"));
        }
        if (this.myChangedBlockData == null) {
            return line;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertApproximateInv(line);
    }

    @NotNull
    public Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines = new int[2];
        if (this.myChangedBlockData == null) {
            lines[0] = line;
            lines[1] = line;
            Pair pair = Pair.create((Object)lines, (Object)this.myMasterSide);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "transferLineFromOneside"));
            }
            return pair;
        }
        LineNumberConvertor lineConvertor1 = this.myChangedBlockData.getLineNumberConvertor(Side.LEFT);
        LineNumberConvertor lineConvertor2 = this.myChangedBlockData.getLineNumberConvertor(Side.RIGHT);
        Side side = this.myMasterSide;
        lines[0] = lineConvertor1.convert(line);
        lines[1] = lineConvertor2.convert(line);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line);
            lines[1] = lineConvertor2.convertApproximate(line);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor2.convertApproximate(line);
            side = Side.LEFT;
        }
        Pair pair = Pair.create((Object)lines, (Object)side);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "transferLineFromOneside"));
        }
        return pair;
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        for (RangeMarker block : this.myChangedBlockData.getGuardedRangeBlocks()) {
            this.myDocument.removeGuardedBlock(block);
        }
        this.myChangedBlockData = null;
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "onDocumentChange"));
        }
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.scheduleRediff();
    }

    public void replaceChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "replaceChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "replaceChange"));
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    public void appendChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "appendChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "appendChange"));
        }
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getFoldingModelSettings"));
        }
        return settings;
    }

    @NotNull
    public Side getMasterSide() {
        Side side = this.myMasterSide;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getMasterSide"));
        }
        return side;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list = Collections.singletonList(this.myEditor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list = this.myRequest.getContents();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getContents"));
        }
        return list;
    }

    @NotNull
    protected DocumentContent getContent(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getContent"));
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getContent"));
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent1() {
        DocumentContent documentContent = this.getContent(Side.LEFT);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getContent1"));
        }
        return documentContent;
    }

    @NotNull
    protected DocumentContent getContent2() {
        DocumentContent documentContent = this.getContent(Side.RIGHT);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getContent2"));
        }
        return documentContent;
    }

    @Nullable
    protected List<UnifiedDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        UnifiedDiffPanel unifiedDiffPanel = this.myPanel;
        if (unifiedDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getComponent"));
        }
        return unifiedDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "isEditable"));
        }
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument(side));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getDocument"));
        }
        Document document = this.getContent(side).getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getDocument"));
        }
        return document;
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getNavigatable(LineCol.fromCaret((Editor)this.myEditor));
    }

    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        if (this.myChangedBlockData == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @NotNull
    private List<UnifiedDiffChange> getSelectedChanges() {
        if (this.myChangedBlockData == null) {
            List<UnifiedDiffChange> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getSelectedChanges"));
            }
            return list;
        }
        BitSet lines = DiffUtil.getSelectedLines(this.myEditor);
        List<UnifiedDiffChange> changes = this.myChangedBlockData.getDiffChanges();
        ArrayList<UnifiedDiffChange> affectedChanges = new ArrayList<UnifiedDiffChange>();
        for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
            int line2;
            UnifiedDiffChange change = changes.get(i2);
            int line1 = change.getLine1();
            if (!DiffUtil.isSelectedByLine(lines, line1, line2 = change.getLine2())) continue;
            affectedChanges.add(change);
        }
        ArrayList<UnifiedDiffChange> arrayList = affectedChanges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getSelectedChanges"));
        }
        return arrayList;
    }

    @Nullable
    protected Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "getNavigatable"));
        }
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int line1 = ((int[])pair.first)[0];
        int line2 = ((int[])pair.first)[1];
        Navigatable navigatable1 = this.getContent1().getNavigatable(new LineCol(line1, position.column));
        Navigatable navigatable2 = this.getContent2().getNavigatable(new LineCol(line2, position.column));
        if (navigatable1 == null) {
            return navigatable2;
        }
        if (navigatable2 == null) {
            return navigatable1;
        }
        return (Navigatable)((Side)pair.second).select((Object)navigatable1, (Object)navigatable2);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        UnifiedDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        public MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor}, disposable);
        }

        /*
         * Exception decompiling
         */
        public void install(@Nullable List<LineRange> changedLines, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            TIntFunction tIntFunction = this.getLineConvertor(0);
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel", "getLineNumberConvertor"));
            }
            return tIntFunction;
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = UnifiedDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                LogicalPosition logicalPosition = new LogicalPosition(0, 0);
                if (logicalPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "getPosition"));
                }
                return logicalPosition;
            }
            LogicalPosition logicalPosition = new LogicalPosition(line, column);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "getPosition"));
            }
            return logicalPosition;
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "doScrollToLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "doScrollToLine"));
            }
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (scrollToChangePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToChangePolicy", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "doScrollToChange"));
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            UnifiedDiffChange targetChange = scrollToChangePolicy.select(changes);
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges());
            int line = this.myNavigationContext.contextMatchCheck((Iterator)changedLinesIterator);
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(UnifiedDiffViewer.this.getContent2().getDocument());
                line = this.myNavigationContext.contextMatchCheck((Iterator)allLinesIterator);
            }
            if (line == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
            return true;
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;
        @Nullable
        private final FileType myFileType;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @NotNull
        private final TIntFunction myLineConvertor2;

        public CombinedEditorData(@NotNull CharSequence text, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter, @Nullable FileType fileType, @NotNull TIntFunction convertor1, @NotNull TIntFunction convertor2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "<init>"));
            }
            if (convertor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "<init>"));
            }
            if (convertor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "<init>"));
            }
            this.myText = text;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myFileType = fileType;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "getText"));
            }
            return charSequence;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            TIntFunction tIntFunction = this.myLineConvertor1;
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "getLineConvertor1"));
            }
            return tIntFunction;
        }

        @NotNull
        public TIntFunction getLineConvertor2() {
            TIntFunction tIntFunction = this.myLineConvertor2;
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$CombinedEditorData", "getLineConvertor2"));
            }
            return tIntFunction;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final List<RangeMarker> myGuardedRangeBlocks;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor1;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor2;
        private final boolean myIsContentsEqual;

        public ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull List<RangeMarker> guarderRangeBlocks, @NotNull LineNumberConvertor lineNumberConvertor1, @NotNull LineNumberConvertor lineNumberConvertor2, boolean isContentsEqual) {
            if (diffChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffChanges", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "<init>"));
            }
            if (guarderRangeBlocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guarderRangeBlocks", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "<init>"));
            }
            if (lineNumberConvertor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor1", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "<init>"));
            }
            if (lineNumberConvertor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor2", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "<init>"));
            }
            this.myDiffChanges = diffChanges;
            this.myGuardedRangeBlocks = guarderRangeBlocks;
            this.myLineNumberConvertor1 = lineNumberConvertor1;
            this.myLineNumberConvertor2 = lineNumberConvertor2;
            this.myIsContentsEqual = isContentsEqual;
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            List<UnifiedDiffChange> list = this.myDiffChanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "getDiffChanges"));
            }
            return list;
        }

        @NotNull
        public List<RangeMarker> getGuardedRangeBlocks() {
            List<RangeMarker> list = this.myGuardedRangeBlocks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "getGuardedRangeBlocks"));
            }
            return list;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "getLineNumberConvertor"));
            }
            LineNumberConvertor lineNumberConvertor = (LineNumberConvertor)side.select((Object)this.myLineNumberConvertor1, (Object)this.myLineNumberConvertor2);
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedBlockData", "getLineNumberConvertor"));
            }
            return lineNumberConvertor;
        }

        public boolean isContentsEqual() {
            return this.myIsContentsEqual;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final UnifiedFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        public TwosideDocumentData(@NotNull UnifiedFragmentBuilder builder, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$TwosideDocumentData", "<init>"));
            }
            this.myBuilder = builder;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public UnifiedFragmentBuilder getBuilder() {
            UnifiedFragmentBuilder unifiedFragmentBuilder = this.myBuilder;
            if (unifiedFragmentBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$TwosideDocumentData", "getBuilder"));
            }
            return unifiedFragmentBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return null;
            }
            int changesCount = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges().size();
            if (changesCount == 0 && !UnifiedDiffViewer.this.myChangedBlockData.isContentsEqual()) {
                return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{changesCount});
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final List<UnifiedDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(List<UnifiedDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent2().getDocument();
            CharSequence insertedText = DiffUtil.getLinesContent(document, lineFragment.getStartLine2(), lineFragment.getEndLine2());
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line : tokenizer.execute()) {
                this.addLine(lineNumber, line);
                ++lineNumber;
            }
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            if (UnifiedDiffViewer.this.myChangedBlockData != null) {
                for (UnifiedDiffChange unifiedDiffChange : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    unifiedDiffChange.updateGutterActions();
                }
            }
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            UnifiedDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
            }
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getNavigatable(new LineCol(line));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            List list = ContainerUtil.notNullize(UnifiedDiffViewer.this.getDiffChanges());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable", "getChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = UnifiedDiffViewer.this.myEditor;
            if (editorEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable", "getEditor"));
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable", "getStartLine"));
            }
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable", "getEndLine"));
            }
            return change.getLine2();
        }

        @Override
        protected void scrollToChange(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable", "scrollToChange"));
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, change.getLine1(), true);
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedSide", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$AppendSelectedChangesAction", "<init>"));
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Append");
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            for (UnifiedDiffChange change : changes) {
                UnifiedDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedSide", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ReplaceSelectedChangesAction", "<init>"));
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText((String)focusedSide.select((Object)"Revert", (Object)"Accept"));
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.Remove, (Object)AllIcons.Actions.Checked));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            for (UnifiedDiffChange change : changes) {
                UnifiedDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;
        protected final boolean myShortcut;

        public ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            if (modifiedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedSide", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase", "<init>"));
            }
            this.myModifiedSide = modifiedSide;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase", "update"));
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase", "actionPerformed"));
            }
            List selectedChanges = UnifiedDiffViewer.this.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title, () -> {
                this.apply(selectedChanges);
                UnifiedDiffViewer.this.scheduleRediff();
            });
        }

        protected boolean isSomeChangeSelected() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            if (changes.isEmpty()) {
                return false;
            }
            List carets = UnifiedDiffViewer.this.getEditor().getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = UnifiedDiffViewer.this.getEditor().getDocument().getLineNumber(UnifiedDiffViewer.this.getEditor().getExpectedCaretOffset());
            for (UnifiedDiffChange change : changes) {
                if (!DiffUtil.isSelectedByLine(line, change.getLine1(), change.getLine2())) continue;
                return true;
            }
            return false;
        }

        protected abstract void apply(@NotNull List<UnifiedDiffChange> var1);
    }

    private class MyOnesideDocumentListener
    extends DocumentAdapter {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                LOG.warn("oneside beforeDocumentChange - myChangedBlockData == null");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor masterConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide);
                LineNumberConvertor slaveConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide.other());
                masterConvertor.handleMasterChange(line1, line2, shift, true);
                slaveConvertor.handleMasterChange(line1, line2, shift, false);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            StringBuilder info = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== UnifiedDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }
    }
}

